/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.gui.ApplicationContext;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public abstract class OptionsDialog {
    protected Logger logger = Logger.getLogger(OptionsDialog.class.getName());

    protected abstract void doSave(Path var1);

    protected abstract void doOpenFile(Path var1);

    protected void doSaveDialog() {
        File file;
        this.logger.finest("+doSaveDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("saveAs"));
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        String string = sEPAPreferences.loadPreference("last.save.dir");
        if (string != null && (file = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("saveFile"));
        switch (n) {
            case 0: {
                sEPAPreferences.savePreference("last.save.dir", jFileChooser.getCurrentDirectory().toString());
                this.doSave(Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
                break;
            }
            case 1: {
                jFileChooser.setVisible(false);
                this.logger.fine("cancel pressed.");
                break;
            }
        }
        this.logger.finest("-doSaveDialog");
    }

    protected void doOpenFileDialog() {
        File file;
        this.logger.finest("+doOpenFileDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("selectFile"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        String string = sEPAPreferences.loadPreference("last.open.dir");
        if (string != null && (file = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("importFile"));
        switch (n) {
            case 0: {
                sEPAPreferences.savePreference("last.open.dir", jFileChooser.getCurrentDirectory().toString());
                this.doOpenFile(Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
                break;
            }
            case 1: {
                this.logger.fine("Cancel pressed.");
                jFileChooser.setVisible(false);
                break;
            }
        }
        this.logger.finest("-doOpenFileDialog");
    }
}

