/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.gui.DebitParser;
import com.codecamp.sepa.parser.csv.CSVDirectDebitParser;
import com.codecamp.sepa.parser.excel.ExcelDirectDebitParser;
import com.codecamp.sepa.parser.odf.ODFDirectDebitParser;
import java.nio.file.Path;

public class DirectDebitParserFactory {
    public static final String XLS = "XLS";
    public static final String CSV = "CSV";
    public static final String XLSX = "XLSX";
    public static final String ODS = "ODS";

    public static DebitParser create(Path path) {
        String string = path.toAbsolutePath().toString().toUpperCase();
        if (string.endsWith(CSV)) {
            return new CSVDirectDebitParser();
        }
        if (string.endsWith(XLS) || string.endsWith(XLSX)) {
            return new ExcelDirectDebitParser();
        }
        if (string.endsWith(ODS)) {
            return new ODFDirectDebitParser();
        }
        throw new NullPointerException("File type not supported. " + string);
    }
}

