/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.gui.CreditParser;
import com.codecamp.sepa.parser.csv.CSVCreditTransferParser;
import com.codecamp.sepa.parser.excel.ExcelCreditParser;
import com.codecamp.sepa.parser.odf.ODFCreditParser;
import java.nio.file.Path;

public class CreditTransferParserFactory {
    public static final String XLS = "XLS";
    public static final String CSV = "CSV";
    public static final String XLSX = "XLSX";
    public static final String ODS = "ODS";

    public static CreditParser create(Path path) {
        String string = path.toAbsolutePath().toString().toUpperCase();
        if (string.endsWith(CSV)) {
            return new CSVCreditTransferParser();
        }
        if (string.endsWith(XLS) || string.endsWith(XLSX)) {
            return new ExcelCreditParser();
        }
        if (string.endsWith(ODS)) {
            return new ODFCreditParser();
        }
        throw new NullPointerException("File type not supported. " + string);
    }
}

