/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.pain008_002_02.AccountIdentificationSEPA;
import com.codecamp.sepa.pain008_002_02.ActiveOrHistoricCurrencyAndAmountSEPA;
import com.codecamp.sepa.pain008_002_02.ActiveOrHistoricCurrencyCodeEUR;
import com.codecamp.sepa.pain008_002_02.BranchAndFinancialInstitutionIdentificationSEPA1;
import com.codecamp.sepa.pain008_002_02.CashAccountSEPA1;
import com.codecamp.sepa.pain008_002_02.CashAccountSEPA2;
import com.codecamp.sepa.pain008_002_02.CategoryPurposeSEPA;
import com.codecamp.sepa.pain008_002_02.ChargeBearerTypeSEPACode;
import com.codecamp.sepa.pain008_002_02.CustomerDirectDebitInitiationV02;
import com.codecamp.sepa.pain008_002_02.DirectDebitTransactionInformationSDD;
import com.codecamp.sepa.pain008_002_02.DirectDebitTransactionSDD;
import com.codecamp.sepa.pain008_002_02.Document;
import com.codecamp.sepa.pain008_002_02.FinancialInstitutionIdentificationSEPA1;
import com.codecamp.sepa.pain008_002_02.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain008_002_02.GenericPersonIdentification1;
import com.codecamp.sepa.pain008_002_02.GroupHeaderSDD;
import com.codecamp.sepa.pain008_002_02.IdentificationSchemeNameSEPA;
import com.codecamp.sepa.pain008_002_02.LocalInstrumentSEPA;
import com.codecamp.sepa.pain008_002_02.LocalInstrumentSEPACode;
import com.codecamp.sepa.pain008_002_02.MandateRelatedInformationSDD;
import com.codecamp.sepa.pain008_002_02.OrganisationIdentificationSEPAChoice;
import com.codecamp.sepa.pain008_002_02.PartyIdentificationSEPA1;
import com.codecamp.sepa.pain008_002_02.PartyIdentificationSEPA2;
import com.codecamp.sepa.pain008_002_02.PartyIdentificationSEPA3;
import com.codecamp.sepa.pain008_002_02.PartyIdentificationSEPA5;
import com.codecamp.sepa.pain008_002_02.PartySEPA2;
import com.codecamp.sepa.pain008_002_02.PartySEPAChoice;
import com.codecamp.sepa.pain008_002_02.PaymentIdentificationSEPA;
import com.codecamp.sepa.pain008_002_02.PaymentInstructionInformationSDD;
import com.codecamp.sepa.pain008_002_02.PaymentMethod2Code;
import com.codecamp.sepa.pain008_002_02.PaymentTypeInformationSDD;
import com.codecamp.sepa.pain008_002_02.PersonIdentificationSEPA1Choice;
import com.codecamp.sepa.pain008_002_02.PersonIdentificationSEPA2;
import com.codecamp.sepa.pain008_002_02.PostalAddressSEPA;
import com.codecamp.sepa.pain008_002_02.RemittanceInformationSEPA1Choice;
import com.codecamp.sepa.pain008_002_02.RestrictedPersonIdentificationSEPA;
import com.codecamp.sepa.pain008_002_02.RestrictedPersonIdentificationSchemeNameSEPA;
import com.codecamp.sepa.pain008_002_02.ServiceLevelSEPA;
import com.codecamp.sepa.pain008_002_02.ServiceLevelSEPACode;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLDirectDebitBuilder002 {
    private final Logger logger = Logger.getLogger(SEPAXMLDirectDebitBuilder002.class.getName());

    protected Document getDirectDebit(SEPADirectDebit sEPADirectDebit) {
        PartySEPAChoice partySEPAChoice;
        Object object;
        Object object2;
        Document document = new Document();
        CustomerDirectDebitInitiationV02 customerDirectDebitInitiationV02 = new CustomerDirectDebitInitiationV02();
        document.setCstmrDrctDbtInitn(customerDirectDebitInitiationV02);
        GroupHeaderSDD groupHeaderSDD = new GroupHeaderSDD();
        customerDirectDebitInitiationV02.setGrpHdr(groupHeaderSDD);
        groupHeaderSDD.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeaderSDD.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPADirectDebit.getTransactionList().size());
        groupHeaderSDD.setNbOfTxs(string);
        PartyIdentificationSEPA1 partyIdentificationSEPA1 = new PartyIdentificationSEPA1();
        groupHeaderSDD.setInitgPty(partyIdentificationSEPA1);
        partyIdentificationSEPA1.setNm(sEPADirectDebit.getKontoinhaber());
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
            object2 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object2).setId(sEPADirectDebit.getIdentificationID());
            object = new OrganisationIdentificationSEPAChoice();
            ((OrganisationIdentificationSEPAChoice)object).setOthr((GenericOrganisationIdentification1)object2);
            partySEPAChoice = new PartySEPAChoice();
            partySEPAChoice.setOrgId((OrganisationIdentificationSEPAChoice)object);
            partyIdentificationSEPA1.setId(partySEPAChoice);
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
            object2 = new GenericPersonIdentification1();
            ((GenericPersonIdentification1)object2).setId(sEPADirectDebit.getIdentificationID());
            object = new PersonIdentificationSEPA1Choice();
            ((PersonIdentificationSEPA1Choice)object).setOthr((GenericPersonIdentification1)object2);
            partySEPAChoice = new PartySEPAChoice();
            partySEPAChoice.setPrvtId((PersonIdentificationSEPA1Choice)object);
            partyIdentificationSEPA1.setId(partySEPAChoice);
        }
        object2 = customerDirectDebitInitiationV02.getPmtInf();
        object = new BigDecimal(0).setScale(2);
        object = sEPADirectDebit.getUsePIIforEachTrx() || sEPADirectDebit.isCollectionDateFromFile() || sEPADirectDebit.isDirectDebitTypeFromFile() ? this.addPIIForEachTrx(sEPADirectDebit, (List<PaymentInstructionInformationSDD>)object2) : this.addSinglePII(sEPADirectDebit, (List<PaymentInstructionInformationSDD>)object2, string);
        groupHeaderSDD.setCtrlSum(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformationSDD> list) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            PaymentInstructionInformationSDD paymentInstructionInformationSDD = new PaymentInstructionInformationSDD();
            list.add(paymentInstructionInformationSDD);
            paymentInstructionInformationSDD.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformationSDD.setPmtMtd(PaymentMethod2Code.DD);
            paymentInstructionInformationSDD.setNbOfTxs("1");
            if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformationSDD.setBtchBookg(Boolean.TRUE);
            } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformationSDD.setBtchBookg(Boolean.FALSE);
            }
            PaymentTypeInformationSDD paymentTypeInformationSDD = new PaymentTypeInformationSDD();
            ServiceLevelSEPA serviceLevelSEPA = new ServiceLevelSEPA();
            serviceLevelSEPA.setCd(ServiceLevelSEPACode.SEPA);
            paymentTypeInformationSDD.setSvcLvl(serviceLevelSEPA);
            LocalInstrumentSEPA localInstrumentSEPA = new LocalInstrumentSEPA();
            if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
                localInstrumentSEPA.setCd(LocalInstrumentSEPACode.B_2_B);
            } else {
                localInstrumentSEPA.setCd(LocalInstrumentSEPACode.CORE);
            }
            paymentTypeInformationSDD.setLclInstrm(localInstrumentSEPA);
            paymentTypeInformationSDD.setSeqTp(sEPADirectDebit.isDirectDebitTypeFromFile() ? DirectDebitType.getSequenceType002(sEPADirectDebitTransaction.getDirectDebitType()) : DirectDebitType.getSequenceType002(sEPADirectDebit.getType()));
            paymentInstructionInformationSDD.setPmtTpInf(paymentTypeInformationSDD);
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.isCollectionDateFromFile() ? sEPADirectDebitTransaction.getCollectionDate() : sEPADirectDebit.getCollectionDate());
                paymentInstructionInformationSDD.setReqdColltnDt(xMLGregorianCalendar);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
            }
            PartyIdentificationSEPA5 partyIdentificationSEPA5 = new PartyIdentificationSEPA5();
            partyIdentificationSEPA5.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformationSDD.setCdtr(partyIdentificationSEPA5);
            CashAccountSEPA1 cashAccountSEPA1 = new CashAccountSEPA1();
            AccountIdentificationSEPA accountIdentificationSEPA = new AccountIdentificationSEPA();
            accountIdentificationSEPA.setIBAN(sEPADirectDebit.getIBAN());
            cashAccountSEPA1.setId(accountIdentificationSEPA);
            paymentInstructionInformationSDD.setCdtrAcct(cashAccountSEPA1);
            BranchAndFinancialInstitutionIdentificationSEPA1 branchAndFinancialInstitutionIdentificationSEPA1 = new BranchAndFinancialInstitutionIdentificationSEPA1();
            FinancialInstitutionIdentificationSEPA1 financialInstitutionIdentificationSEPA1 = new FinancialInstitutionIdentificationSEPA1();
            financialInstitutionIdentificationSEPA1.setBIC(sEPADirectDebit.getBIC());
            branchAndFinancialInstitutionIdentificationSEPA1.setFinInstnId(financialInstitutionIdentificationSEPA1);
            paymentInstructionInformationSDD.setCdtrAgt(branchAndFinancialInstitutionIdentificationSEPA1);
            if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformationSDD.setChrgBr(ChargeBearerTypeSEPACode.fromValue(sEPADirectDebit.getChargeBearer().name()));
            }
            PartyIdentificationSEPA3 partyIdentificationSEPA3 = new PartyIdentificationSEPA3();
            PartySEPA2 partySEPA2 = new PartySEPA2();
            PersonIdentificationSEPA2 personIdentificationSEPA2 = new PersonIdentificationSEPA2();
            RestrictedPersonIdentificationSEPA restrictedPersonIdentificationSEPA = new RestrictedPersonIdentificationSEPA();
            restrictedPersonIdentificationSEPA.setId(sEPADirectDebit.getGlaeubigerId());
            RestrictedPersonIdentificationSchemeNameSEPA restrictedPersonIdentificationSchemeNameSEPA = new RestrictedPersonIdentificationSchemeNameSEPA();
            restrictedPersonIdentificationSchemeNameSEPA.setPrtry(IdentificationSchemeNameSEPA.SEPA);
            restrictedPersonIdentificationSEPA.setSchmeNm(restrictedPersonIdentificationSchemeNameSEPA);
            personIdentificationSEPA2.setOthr(restrictedPersonIdentificationSEPA);
            partySEPA2.setPrvtId(personIdentificationSEPA2);
            partyIdentificationSEPA3.setId(partySEPA2);
            paymentInstructionInformationSDD.setCdtrSchmeId(partyIdentificationSEPA3);
            if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                CategoryPurposeSEPA categoryPurposeSEPA = new CategoryPurposeSEPA();
                categoryPurposeSEPA.setCd(sEPADirectDebit.getCategoryPurpose().name());
                paymentTypeInformationSDD.setCtgyPurp(categoryPurposeSEPA);
            }
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformationSDD.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), 1, sEPADirectDebit.isSetTxNo(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
            paymentInstructionInformationSDD.setCtrlSum(sEPADirectDebitTransaction.getAmount().setScale(2));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformationSDD> list, String string) {
        Object object;
        PaymentInstructionInformationSDD paymentInstructionInformationSDD = new PaymentInstructionInformationSDD();
        list.add(paymentInstructionInformationSDD);
        paymentInstructionInformationSDD.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformationSDD.setPmtMtd(PaymentMethod2Code.DD);
        paymentInstructionInformationSDD.setNbOfTxs(string);
        if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformationSDD.setBtchBookg(Boolean.TRUE);
        } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformationSDD.setBtchBookg(Boolean.FALSE);
        }
        PaymentTypeInformationSDD paymentTypeInformationSDD = new PaymentTypeInformationSDD();
        ServiceLevelSEPA serviceLevelSEPA = new ServiceLevelSEPA();
        serviceLevelSEPA.setCd(ServiceLevelSEPACode.SEPA);
        paymentTypeInformationSDD.setSvcLvl(serviceLevelSEPA);
        LocalInstrumentSEPA localInstrumentSEPA = new LocalInstrumentSEPA();
        if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
            localInstrumentSEPA.setCd(LocalInstrumentSEPACode.B_2_B);
        } else {
            localInstrumentSEPA.setCd(LocalInstrumentSEPACode.CORE);
        }
        paymentTypeInformationSDD.setLclInstrm(localInstrumentSEPA);
        paymentTypeInformationSDD.setSeqTp(DirectDebitType.getSequenceType002(sEPADirectDebit.getType()));
        paymentInstructionInformationSDD.setPmtTpInf(paymentTypeInformationSDD);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.getCollectionDate());
            paymentInstructionInformationSDD.setReqdColltnDt(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
        }
        PartyIdentificationSEPA5 partyIdentificationSEPA5 = new PartyIdentificationSEPA5();
        partyIdentificationSEPA5.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformationSDD.setCdtr(partyIdentificationSEPA5);
        CashAccountSEPA1 cashAccountSEPA1 = new CashAccountSEPA1();
        AccountIdentificationSEPA accountIdentificationSEPA = new AccountIdentificationSEPA();
        accountIdentificationSEPA.setIBAN(sEPADirectDebit.getIBAN());
        cashAccountSEPA1.setId(accountIdentificationSEPA);
        paymentInstructionInformationSDD.setCdtrAcct(cashAccountSEPA1);
        BranchAndFinancialInstitutionIdentificationSEPA1 branchAndFinancialInstitutionIdentificationSEPA1 = new BranchAndFinancialInstitutionIdentificationSEPA1();
        FinancialInstitutionIdentificationSEPA1 financialInstitutionIdentificationSEPA1 = new FinancialInstitutionIdentificationSEPA1();
        financialInstitutionIdentificationSEPA1.setBIC(sEPADirectDebit.getBIC());
        branchAndFinancialInstitutionIdentificationSEPA1.setFinInstnId(financialInstitutionIdentificationSEPA1);
        paymentInstructionInformationSDD.setCdtrAgt(branchAndFinancialInstitutionIdentificationSEPA1);
        if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformationSDD.setChrgBr(ChargeBearerTypeSEPACode.fromValue(sEPADirectDebit.getChargeBearer().name()));
        }
        PartyIdentificationSEPA3 partyIdentificationSEPA3 = new PartyIdentificationSEPA3();
        PartySEPA2 partySEPA2 = new PartySEPA2();
        PersonIdentificationSEPA2 personIdentificationSEPA2 = new PersonIdentificationSEPA2();
        RestrictedPersonIdentificationSEPA restrictedPersonIdentificationSEPA = new RestrictedPersonIdentificationSEPA();
        restrictedPersonIdentificationSEPA.setId(sEPADirectDebit.getGlaeubigerId());
        RestrictedPersonIdentificationSchemeNameSEPA restrictedPersonIdentificationSchemeNameSEPA = new RestrictedPersonIdentificationSchemeNameSEPA();
        restrictedPersonIdentificationSchemeNameSEPA.setPrtry(IdentificationSchemeNameSEPA.SEPA);
        restrictedPersonIdentificationSEPA.setSchmeNm(restrictedPersonIdentificationSchemeNameSEPA);
        personIdentificationSEPA2.setOthr(restrictedPersonIdentificationSEPA);
        partySEPA2.setPrvtId(personIdentificationSEPA2);
        partyIdentificationSEPA3.setId(partySEPA2);
        paymentInstructionInformationSDD.setCdtrSchmeId(partyIdentificationSEPA3);
        if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object = new CategoryPurposeSEPA();
            ((CategoryPurposeSEPA)object).setCd(sEPADirectDebit.getCategoryPurpose().name());
            paymentTypeInformationSDD.setCtgyPurp((CategoryPurposeSEPA)object);
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformationSDD.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), ++n, sEPADirectDebit.isSetTxNo(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
        }
        paymentInstructionInformationSDD.setCtrlSum(((BigDecimal)object).setScale(2));
        return object;
    }

    private DirectDebitTransactionInformationSDD getDirectDebitTransaction(BigDecimal bigDecimal, String string, String string2, String string3, String string4, String string5, GregorianCalendar gregorianCalendar, boolean bl, String string6, boolean bl2, String string7, int n, boolean bl3, String string8, String string9, String string10) {
        Object object;
        DirectDebitTransactionInformationSDD directDebitTransactionInformationSDD = new DirectDebitTransactionInformationSDD();
        PaymentIdentificationSEPA paymentIdentificationSEPA = new PaymentIdentificationSEPA();
        if (bl) {
            paymentIdentificationSEPA.setEndToEndId(IDGenerator.generateId());
        } else if (bl2 && StringUtils.trimToNull(string7) != null) {
            paymentIdentificationSEPA.setEndToEndId(string7);
        } else if (StringUtils.trimToNull(string6) != null) {
            paymentIdentificationSEPA.setEndToEndId(string6);
        } else {
            paymentIdentificationSEPA.setEndToEndId("NOTPROVIDED");
        }
        if (bl3) {
            paymentIdentificationSEPA.setInstrId(String.valueOf(n));
        }
        directDebitTransactionInformationSDD.setPmtId(paymentIdentificationSEPA);
        ActiveOrHistoricCurrencyAndAmountSEPA activeOrHistoricCurrencyAndAmountSEPA = new ActiveOrHistoricCurrencyAndAmountSEPA();
        activeOrHistoricCurrencyAndAmountSEPA.setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR);
        activeOrHistoricCurrencyAndAmountSEPA.setValue(bigDecimal);
        directDebitTransactionInformationSDD.setInstdAmt(activeOrHistoricCurrencyAndAmountSEPA);
        DirectDebitTransactionSDD directDebitTransactionSDD = new DirectDebitTransactionSDD();
        MandateRelatedInformationSDD mandateRelatedInformationSDD = new MandateRelatedInformationSDD();
        mandateRelatedInformationSDD.setMndtId(string4);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            mandateRelatedInformationSDD.setDtOfSgntr(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (dateOfSignature)!", datatypeConfigurationException);
        }
        directDebitTransactionSDD.setMndtRltdInf(mandateRelatedInformationSDD);
        directDebitTransactionInformationSDD.setDrctDbtTx(directDebitTransactionSDD);
        BranchAndFinancialInstitutionIdentificationSEPA1 branchAndFinancialInstitutionIdentificationSEPA1 = new BranchAndFinancialInstitutionIdentificationSEPA1();
        FinancialInstitutionIdentificationSEPA1 financialInstitutionIdentificationSEPA1 = new FinancialInstitutionIdentificationSEPA1();
        financialInstitutionIdentificationSEPA1.setBIC(string2);
        branchAndFinancialInstitutionIdentificationSEPA1.setFinInstnId(financialInstitutionIdentificationSEPA1);
        directDebitTransactionInformationSDD.setDbtrAgt(branchAndFinancialInstitutionIdentificationSEPA1);
        PartyIdentificationSEPA2 partyIdentificationSEPA2 = new PartyIdentificationSEPA2();
        partyIdentificationSEPA2.setNm(string);
        if (string8 != null || string9 != null || string10 != null) {
            object = new PostalAddressSEPA();
            partyIdentificationSEPA2.setPstlAdr((PostalAddressSEPA)object);
            if (!string8.isEmpty()) {
                ((PostalAddressSEPA)object).setCtry(string8);
            }
            if (string9 != null && !string9.isEmpty()) {
                ((PostalAddressSEPA)object).getAdrLine().add(string9);
            }
            if (string10 != null && !string10.isEmpty()) {
                ((PostalAddressSEPA)object).getAdrLine().add(string10);
            }
        }
        directDebitTransactionInformationSDD.setDbtr(partyIdentificationSEPA2);
        object = new CashAccountSEPA2();
        AccountIdentificationSEPA accountIdentificationSEPA = new AccountIdentificationSEPA();
        accountIdentificationSEPA.setIBAN(string3);
        ((CashAccountSEPA2)object).setId(accountIdentificationSEPA);
        directDebitTransactionInformationSDD.setDbtrAcct((CashAccountSEPA2)object);
        RemittanceInformationSEPA1Choice remittanceInformationSEPA1Choice = new RemittanceInformationSEPA1Choice();
        remittanceInformationSEPA1Choice.setUstrd(string5);
        directDebitTransactionInformationSDD.setRmtInf(remittanceInformationSEPA1Choice);
        return directDebitTransactionInformationSDD;
    }
}

