/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.pain008_001_01.AccountIdentification3Choice;
import com.codecamp.sepa.pain008_001_01.BranchAndFinancialInstitutionIdentification3;
import com.codecamp.sepa.pain008_001_01.CashAccount7;
import com.codecamp.sepa.pain008_001_01.ChargeBearerType1Code;
import com.codecamp.sepa.pain008_001_01.CurrencyAndAmount;
import com.codecamp.sepa.pain008_001_01.DirectDebitTransaction1;
import com.codecamp.sepa.pain008_001_01.DirectDebitTransactionInformation1;
import com.codecamp.sepa.pain008_001_01.Document;
import com.codecamp.sepa.pain008_001_01.FinancialInstitutionIdentification5Choice;
import com.codecamp.sepa.pain008_001_01.GenericIdentification3;
import com.codecamp.sepa.pain008_001_01.GenericIdentification4;
import com.codecamp.sepa.pain008_001_01.GroupHeader1;
import com.codecamp.sepa.pain008_001_01.LocalInstrument1Choice;
import com.codecamp.sepa.pain008_001_01.MandateRelatedInformation1;
import com.codecamp.sepa.pain008_001_01.OrganisationIdentification2;
import com.codecamp.sepa.pain008_001_01.Pain00800101;
import com.codecamp.sepa.pain008_001_01.Party2Choice;
import com.codecamp.sepa.pain008_001_01.PartyIdentification8;
import com.codecamp.sepa.pain008_001_01.PaymentCategoryPurpose1Code;
import com.codecamp.sepa.pain008_001_01.PaymentIdentification1;
import com.codecamp.sepa.pain008_001_01.PaymentInstructionInformation2;
import com.codecamp.sepa.pain008_001_01.PaymentMethod2Code;
import com.codecamp.sepa.pain008_001_01.PaymentTypeInformation2;
import com.codecamp.sepa.pain008_001_01.PersonIdentification3;
import com.codecamp.sepa.pain008_001_01.PostalAddress1;
import com.codecamp.sepa.pain008_001_01.RemittanceInformation1;
import com.codecamp.sepa.pain008_001_01.ServiceLevel2Code;
import com.codecamp.sepa.pain008_001_01.ServiceLevel3Choice;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLDirectDebitBuilder001_01 {
    private final Logger logger = Logger.getLogger(SEPAXMLDirectDebitBuilder001_01.class.getName());

    protected Document getDirectDebit(SEPADirectDebit sEPADirectDebit) {
        Party2Choice party2Choice;
        Object object;
        Object object2;
        Document document = new Document();
        Pain00800101 pain00800101 = new Pain00800101();
        document.setPain00800101(pain00800101);
        GroupHeader1 groupHeader1 = new GroupHeader1();
        pain00800101.setGrpHdr(groupHeader1);
        groupHeader1.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader1.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPADirectDebit.getTransactionList().size());
        groupHeader1.setNbOfTxs(string);
        PartyIdentification8 partyIdentification8 = new PartyIdentification8();
        groupHeader1.setInitgPty(partyIdentification8);
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
            object2 = new GenericIdentification3();
            ((GenericIdentification3)object2).setId(sEPADirectDebit.getIdentificationID());
            object = new OrganisationIdentification2();
            ((OrganisationIdentification2)object).setPrtryId((GenericIdentification3)object2);
            party2Choice = new Party2Choice();
            party2Choice.setOrgId((OrganisationIdentification2)object);
            partyIdentification8.setId(party2Choice);
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
            object2 = new GenericIdentification4();
            ((GenericIdentification4)object2).setId(sEPADirectDebit.getIdentificationID());
            object = new PersonIdentification3();
            ((PersonIdentification3)object).setOthrId((GenericIdentification4)object2);
            party2Choice = new Party2Choice();
            party2Choice.getPrvtId().add((PersonIdentification3)object);
            partyIdentification8.setId(party2Choice);
        }
        partyIdentification8.setNm(sEPADirectDebit.getKontoinhaber());
        object2 = pain00800101.getPmtInf();
        object = new BigDecimal(0).setScale(2);
        object = sEPADirectDebit.getUsePIIforEachTrx() || sEPADirectDebit.isCollectionDateFromFile() || sEPADirectDebit.isDirectDebitTypeFromFile() ? this.addPIIForEachTrx(sEPADirectDebit, (List<PaymentInstructionInformation2>)object2) : this.addSinglePII(sEPADirectDebit, (List<PaymentInstructionInformation2>)object2, string);
        groupHeader1.setCtrlSum(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation2> list) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            PaymentInstructionInformation2 paymentInstructionInformation2 = new PaymentInstructionInformation2();
            list.add(paymentInstructionInformation2);
            paymentInstructionInformation2.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation2.setPmtMtd(PaymentMethod2Code.DD);
            PaymentTypeInformation2 paymentTypeInformation2 = new PaymentTypeInformation2();
            ServiceLevel3Choice serviceLevel3Choice = new ServiceLevel3Choice();
            serviceLevel3Choice.setCd(ServiceLevel2Code.SEPA);
            paymentTypeInformation2.setSvcLvl(serviceLevel3Choice);
            LocalInstrument1Choice localInstrument1Choice = new LocalInstrument1Choice();
            if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
                localInstrument1Choice.setCd("B2B");
            } else if (DirectDebitKind.COR1.equals((Object)sEPADirectDebit.getKind())) {
                localInstrument1Choice.setCd("COR1");
            } else {
                localInstrument1Choice.setCd("CORE");
            }
            paymentTypeInformation2.setLclInstrm(localInstrument1Choice);
            paymentTypeInformation2.setSeqTp(sEPADirectDebit.isDirectDebitTypeFromFile() ? DirectDebitType.getSequenceType001_01(sEPADirectDebitTransaction.getDirectDebitType()) : DirectDebitType.getSequenceType001_01(sEPADirectDebit.getType()));
            paymentInstructionInformation2.setPmtTpInf(paymentTypeInformation2);
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.isCollectionDateFromFile() ? sEPADirectDebitTransaction.getCollectionDate() : sEPADirectDebit.getCollectionDate());
                paymentInstructionInformation2.setReqdColltnDt(xMLGregorianCalendar);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
            }
            PartyIdentification8 partyIdentification8 = new PartyIdentification8();
            partyIdentification8.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformation2.setCdtr(partyIdentification8);
            CashAccount7 cashAccount7 = new CashAccount7();
            AccountIdentification3Choice accountIdentification3Choice = new AccountIdentification3Choice();
            accountIdentification3Choice.setIBAN(sEPADirectDebit.getIBAN());
            cashAccount7.setId(accountIdentification3Choice);
            paymentInstructionInformation2.setCdtrAcct(cashAccount7);
            BranchAndFinancialInstitutionIdentification3 branchAndFinancialInstitutionIdentification3 = new BranchAndFinancialInstitutionIdentification3();
            FinancialInstitutionIdentification5Choice financialInstitutionIdentification5Choice = new FinancialInstitutionIdentification5Choice();
            financialInstitutionIdentification5Choice.setBIC(sEPADirectDebit.getBIC());
            branchAndFinancialInstitutionIdentification3.setFinInstnId(financialInstitutionIdentification5Choice);
            paymentInstructionInformation2.setCdtrAgt(branchAndFinancialInstitutionIdentification3);
            if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation2.setChrgBr(ChargeBearerType1Code.fromValue(sEPADirectDebit.getChargeBearer().name()));
            }
            if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                PaymentCategoryPurpose1Code paymentCategoryPurpose1Code = PaymentCategoryPurpose1Code.fromValue(sEPADirectDebit.getCategoryPurpose().name());
                paymentTypeInformation2.setCtgyPurp(paymentCategoryPurpose1Code);
            }
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation2.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), 1, sEPADirectDebit.isSetTxNo(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2(), sEPADirectDebit.getGlaeubigerId()));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation2> list, String string) {
        Object object;
        PaymentInstructionInformation2 paymentInstructionInformation2 = new PaymentInstructionInformation2();
        list.add(paymentInstructionInformation2);
        paymentInstructionInformation2.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation2.setPmtMtd(PaymentMethod2Code.DD);
        PaymentTypeInformation2 paymentTypeInformation2 = new PaymentTypeInformation2();
        ServiceLevel3Choice serviceLevel3Choice = new ServiceLevel3Choice();
        serviceLevel3Choice.setCd(ServiceLevel2Code.SEPA);
        paymentTypeInformation2.setSvcLvl(serviceLevel3Choice);
        LocalInstrument1Choice localInstrument1Choice = new LocalInstrument1Choice();
        if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
            localInstrument1Choice.setCd("B2B");
        } else if (DirectDebitKind.COR1.equals((Object)sEPADirectDebit.getKind())) {
            localInstrument1Choice.setCd("COR1");
        } else {
            localInstrument1Choice.setCd("CORE");
        }
        paymentTypeInformation2.setLclInstrm(localInstrument1Choice);
        paymentTypeInformation2.setSeqTp(DirectDebitType.getSequenceType001_01(sEPADirectDebit.getType()));
        paymentInstructionInformation2.setPmtTpInf(paymentTypeInformation2);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.getCollectionDate());
            paymentInstructionInformation2.setReqdColltnDt(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
        }
        PartyIdentification8 partyIdentification8 = new PartyIdentification8();
        partyIdentification8.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformation2.setCdtr(partyIdentification8);
        CashAccount7 cashAccount7 = new CashAccount7();
        AccountIdentification3Choice accountIdentification3Choice = new AccountIdentification3Choice();
        accountIdentification3Choice.setIBAN(sEPADirectDebit.getIBAN());
        cashAccount7.setId(accountIdentification3Choice);
        paymentInstructionInformation2.setCdtrAcct(cashAccount7);
        BranchAndFinancialInstitutionIdentification3 branchAndFinancialInstitutionIdentification3 = new BranchAndFinancialInstitutionIdentification3();
        FinancialInstitutionIdentification5Choice financialInstitutionIdentification5Choice = new FinancialInstitutionIdentification5Choice();
        financialInstitutionIdentification5Choice.setBIC(sEPADirectDebit.getBIC());
        branchAndFinancialInstitutionIdentification3.setFinInstnId(financialInstitutionIdentification5Choice);
        paymentInstructionInformation2.setCdtrAgt(branchAndFinancialInstitutionIdentification3);
        if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation2.setChrgBr(ChargeBearerType1Code.fromValue(sEPADirectDebit.getChargeBearer().name()));
        }
        if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object = PaymentCategoryPurpose1Code.fromValue(sEPADirectDebit.getCategoryPurpose().name());
            paymentTypeInformation2.setCtgyPurp((PaymentCategoryPurpose1Code)((Object)object));
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation2.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), ++n, sEPADirectDebit.isSetTxNo(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2(), sEPADirectDebit.getGlaeubigerId()));
        }
        return object;
    }

    private DirectDebitTransactionInformation1 getDirectDebitTransaction(BigDecimal bigDecimal, String string, String string2, String string3, String string4, String string5, GregorianCalendar gregorianCalendar, boolean bl, String string6, boolean bl2, String string7, int n, boolean bl3, String string8, String string9, String string10, String string11, String string12, String string13) {
        Object object;
        Object object2;
        DirectDebitTransactionInformation1 directDebitTransactionInformation1 = new DirectDebitTransactionInformation1();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (bl2 && StringUtils.trimToNull(string7) != null) {
            paymentIdentification1.setEndToEndId(string7);
        } else if (StringUtils.trimToNull(string6) != null) {
            paymentIdentification1.setEndToEndId(string6);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        if (bl3) {
            paymentIdentification1.setInstrId(String.valueOf(n));
        }
        directDebitTransactionInformation1.setPmtId(paymentIdentification1);
        CurrencyAndAmount currencyAndAmount = new CurrencyAndAmount();
        currencyAndAmount.setCcy(string9 != null ? string9 : string8);
        currencyAndAmount.setValue(bigDecimal);
        directDebitTransactionInformation1.setInstdAmt(currencyAndAmount);
        DirectDebitTransaction1 directDebitTransaction1 = new DirectDebitTransaction1();
        PartyIdentification8 partyIdentification8 = new PartyIdentification8();
        Party2Choice party2Choice = new Party2Choice();
        PersonIdentification3 personIdentification3 = new PersonIdentification3();
        GenericIdentification4 genericIdentification4 = new GenericIdentification4();
        genericIdentification4.setId(string13);
        genericIdentification4.setIdTp("SEPA");
        personIdentification3.setOthrId(genericIdentification4);
        party2Choice.getPrvtId().add(personIdentification3);
        partyIdentification8.setId(party2Choice);
        directDebitTransaction1.setCdtrSchmeId(partyIdentification8);
        MandateRelatedInformation1 mandateRelatedInformation1 = new MandateRelatedInformation1();
        mandateRelatedInformation1.setMndtId(string4);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            mandateRelatedInformation1.setDtOfSgntr(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (dateOfSignature)!", datatypeConfigurationException);
        }
        directDebitTransaction1.setMndtRltdInf(mandateRelatedInformation1);
        directDebitTransactionInformation1.setDrctDbtTx(directDebitTransaction1);
        BranchAndFinancialInstitutionIdentification3 branchAndFinancialInstitutionIdentification3 = new BranchAndFinancialInstitutionIdentification3();
        FinancialInstitutionIdentification5Choice financialInstitutionIdentification5Choice = new FinancialInstitutionIdentification5Choice();
        if (string2 != null && !string2.isEmpty()) {
            financialInstitutionIdentification5Choice.setBIC(string2);
        } else {
            object2 = new GenericIdentification3();
            ((GenericIdentification3)object2).setId("NOTPROVIDED");
            financialInstitutionIdentification5Choice.setPrtryId((GenericIdentification3)object2);
        }
        branchAndFinancialInstitutionIdentification3.setFinInstnId(financialInstitutionIdentification5Choice);
        directDebitTransactionInformation1.setDbtrAgt(branchAndFinancialInstitutionIdentification3);
        object2 = new PartyIdentification8();
        ((PartyIdentification8)object2).setNm(string);
        if (string10 != null || string11 != null || string12 != null) {
            object = new PostalAddress1();
            ((PartyIdentification8)object2).setPstlAdr((PostalAddress1)object);
            if (!string10.isEmpty()) {
                ((PostalAddress1)object).setCtry(string10);
            }
            if (string11 != null && !string11.isEmpty()) {
                ((PostalAddress1)object).getAdrLine().add(string11);
            }
            if (string12 != null && !string12.isEmpty()) {
                ((PostalAddress1)object).getAdrLine().add(string12);
            }
        }
        directDebitTransactionInformation1.setDbtr((PartyIdentification8)object2);
        object = new CashAccount7();
        AccountIdentification3Choice accountIdentification3Choice = new AccountIdentification3Choice();
        accountIdentification3Choice.setIBAN(string3);
        ((CashAccount7)object).setId(accountIdentification3Choice);
        directDebitTransactionInformation1.setDbtrAcct((CashAccount7)object);
        RemittanceInformation1 remittanceInformation1 = new RemittanceInformation1();
        remittanceInformation1.getUstrd().add(string5);
        directDebitTransactionInformation1.setRmtInf(remittanceInformation1);
        return directDebitTransactionInformation1;
    }
}

