/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.pain008_001_02_ch_01.AccountIdentification4ChoiceCH;
import com.codecamp.sepa.pain008_001_02_ch_01.ActiveOrHistoricCurrencyAndAmountCHEUR;
import com.codecamp.sepa.pain008_001_02_ch_01.ActiveOrHistoricCurrencyCodeCHEUR;
import com.codecamp.sepa.pain008_001_02_ch_01.BranchAndFinancialInstitutionIdentification4CHFinId;
import com.codecamp.sepa.pain008_001_02_ch_01.CashAccount16CHIdAndCurrency;
import com.codecamp.sepa.pain008_001_02_ch_01.CategoryPurpose1Choice;
import com.codecamp.sepa.pain008_001_02_ch_01.ChargeBearerType1CodeCH;
import com.codecamp.sepa.pain008_001_02_ch_01.ContactDetails2CH;
import com.codecamp.sepa.pain008_001_02_ch_01.CustomerDirectDebitInitiationV02CH;
import com.codecamp.sepa.pain008_001_02_ch_01.DirectDebitTransaction6CH;
import com.codecamp.sepa.pain008_001_02_ch_01.DirectDebitTransactionInformation9CH;
import com.codecamp.sepa.pain008_001_02_ch_01.Document;
import com.codecamp.sepa.pain008_001_02_ch_01.FinancialInstitutionIdentification7CHBic;
import com.codecamp.sepa.pain008_001_02_ch_01.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain008_001_02_ch_01.GenericPersonIdentification1;
import com.codecamp.sepa.pain008_001_02_ch_01.GenericPersonIdentification1CHPrtry;
import com.codecamp.sepa.pain008_001_02_ch_01.GroupHeader39CH;
import com.codecamp.sepa.pain008_001_02_ch_01.LocalInstrument2CH;
import com.codecamp.sepa.pain008_001_02_ch_01.LocalInstrumentCodeCH;
import com.codecamp.sepa.pain008_001_02_ch_01.MandateRelatedInformation6CH;
import com.codecamp.sepa.pain008_001_02_ch_01.OrganisationIdentification4CH;
import com.codecamp.sepa.pain008_001_02_ch_01.OrganisationIdentification4CH2;
import com.codecamp.sepa.pain008_001_02_ch_01.Party6CHOrgId;
import com.codecamp.sepa.pain008_001_02_ch_01.Party6CHPrivId2;
import com.codecamp.sepa.pain008_001_02_ch_01.Party6ChoiceCHId;
import com.codecamp.sepa.pain008_001_02_ch_01.PartyIdentification32CHNameAddressId;
import com.codecamp.sepa.pain008_001_02_ch_01.PartyIdentification32CHNameAndAddress;
import com.codecamp.sepa.pain008_001_02_ch_01.PartyIdentification32CHNameAndId;
import com.codecamp.sepa.pain008_001_02_ch_01.PartyIdentification32CHNameAndOrgId;
import com.codecamp.sepa.pain008_001_02_ch_01.PartyIdentification32CHPrivId;
import com.codecamp.sepa.pain008_001_02_ch_01.PaymentIdentification1CH;
import com.codecamp.sepa.pain008_001_02_ch_01.PaymentInstructionInformation4CH;
import com.codecamp.sepa.pain008_001_02_ch_01.PaymentMethod2Code;
import com.codecamp.sepa.pain008_001_02_ch_01.PaymentTypeInformation20CH;
import com.codecamp.sepa.pain008_001_02_ch_01.PersonIdentification5CH;
import com.codecamp.sepa.pain008_001_02_ch_01.PersonIdentification5CHPrtry;
import com.codecamp.sepa.pain008_001_02_ch_01.PersonIdentificationSchemeName1CHPrtry;
import com.codecamp.sepa.pain008_001_02_ch_01.PersonIdentificationSchemeName1CodeCH;
import com.codecamp.sepa.pain008_001_02_ch_01.PostalAddress6CH;
import com.codecamp.sepa.pain008_001_02_ch_01.RemittanceInformation5CH;
import com.codecamp.sepa.pain008_001_02_ch_01.ServiceLevel8CHCode;
import com.codecamp.sepa.pain008_001_02_ch_01.ServiceLevel8CodeCH;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLDirectDebitBuilder001CH {
    private final Logger logger = Logger.getLogger(SEPAXMLDirectDebitBuilder001CH.class.getName());

    protected Document getDirectDebit(SEPADirectDebit sEPADirectDebit) {
        Object object;
        Object object2;
        Document document = new Document();
        CustomerDirectDebitInitiationV02CH customerDirectDebitInitiationV02CH = new CustomerDirectDebitInitiationV02CH();
        document.setCstmrDrctDbtInitn(customerDirectDebitInitiationV02CH);
        GroupHeader39CH groupHeader39CH = new GroupHeader39CH();
        customerDirectDebitInitiationV02CH.setGrpHdr(groupHeader39CH);
        groupHeader39CH.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader39CH.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPADirectDebit.getTransactionList().size());
        groupHeader39CH.setNbOfTxs(string);
        PartyIdentification32CHNameAndOrgId partyIdentification32CHNameAndOrgId = new PartyIdentification32CHNameAndOrgId();
        groupHeader39CH.setInitgPty(partyIdentification32CHNameAndOrgId);
        if (sEPADirectDebit.isAddSoftwareNameAndVendor()) {
            object2 = new ContactDetails2CH();
            partyIdentification32CHNameAndOrgId.setCtctDtls((ContactDetails2CH)object2);
            object = new SEPAPreferences();
            ((ContactDetails2CH)object2).setNm(((SEPAPreferences)object).loadPreference(FieldType.SOFTWARE_NAME_AND_VENDOR.name(), "SEPAApp/Janus Software Solutions"));
        }
        object2 = customerDirectDebitInitiationV02CH.getPmtInf();
        object = new BigDecimal(0).setScale(2);
        object = sEPADirectDebit.getUsePIIforEachTrx() || sEPADirectDebit.isCollectionDateFromFile() || sEPADirectDebit.isDirectDebitTypeFromFile() ? this.addPIIForEachTrx(sEPADirectDebit, (List<PaymentInstructionInformation4CH>)object2, partyIdentification32CHNameAndOrgId) : this.addSinglePII(sEPADirectDebit, (List<PaymentInstructionInformation4CH>)object2, string, partyIdentification32CHNameAndOrgId);
        groupHeader39CH.setCtrlSum(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation4CH> list, PartyIdentification32CHNameAndOrgId partyIdentification32CHNameAndOrgId) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            PaymentInstructionInformation4CH paymentInstructionInformation4CH = new PaymentInstructionInformation4CH();
            list.add(paymentInstructionInformation4CH);
            if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
                object4 = new PartyIdentification32CHNameAndId();
                object3 = new Party6ChoiceCHId();
                ((PartyIdentification32CHNameAndId)object4).setId((Party6ChoiceCHId)object3);
                paymentInstructionInformation4CH.setUltmtCdtr((PartyIdentification32CHNameAndId)object4);
                object2 = new GenericOrganisationIdentification1();
                ((GenericOrganisationIdentification1)object2).setId(sEPADirectDebit.getIdentificationID());
                object = new OrganisationIdentification4CH();
                ((OrganisationIdentification4CH)object).setOthr((GenericOrganisationIdentification1)object2);
                ((Party6ChoiceCHId)object3).setOrgId((OrganisationIdentification4CH)object);
            }
            if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
                object4 = new PartyIdentification32CHNameAndId();
                object3 = new Party6ChoiceCHId();
                ((PartyIdentification32CHNameAndId)object4).setId((Party6ChoiceCHId)object3);
                paymentInstructionInformation4CH.setUltmtCdtr((PartyIdentification32CHNameAndId)object4);
                object2 = new GenericPersonIdentification1();
                ((GenericPersonIdentification1)object2).setId(sEPADirectDebit.getIdentificationID());
                object = new PersonIdentification5CH();
                ((PersonIdentification5CH)object).setOthr((GenericPersonIdentification1)object2);
                ((Party6ChoiceCHId)object3).setPrvtId((PersonIdentification5CH)object);
            }
            partyIdentification32CHNameAndOrgId.setNm(sEPADirectDebit.getKontoinhaber());
            object4 = new Party6CHOrgId();
            object3 = new OrganisationIdentification4CH2();
            object2 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object2).setId(sEPADirectDebit.getGlaeubigerId());
            ((OrganisationIdentification4CH2)object3).setOthr((GenericOrganisationIdentification1)object2);
            ((Party6CHOrgId)object4).setOrgId((OrganisationIdentification4CH2)object3);
            partyIdentification32CHNameAndOrgId.setId((Party6CHOrgId)object4);
            paymentInstructionInformation4CH.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation4CH.setPmtMtd(PaymentMethod2Code.DD);
            paymentInstructionInformation4CH.setNbOfTxs("1");
            if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformation4CH.setBtchBookg(Boolean.TRUE);
            } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformation4CH.setBtchBookg(Boolean.FALSE);
            }
            object = new PaymentTypeInformation20CH();
            ServiceLevel8CHCode serviceLevel8CHCode = new ServiceLevel8CHCode();
            serviceLevel8CHCode.setCd(ServiceLevel8CodeCH.SEPA);
            ((PaymentTypeInformation20CH)object).setSvcLvl(serviceLevel8CHCode);
            LocalInstrument2CH localInstrument2CH = new LocalInstrument2CH();
            if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
                localInstrument2CH.setCd(LocalInstrumentCodeCH.B_2_B);
            } else {
                localInstrument2CH.setCd(LocalInstrumentCodeCH.CORE);
            }
            ((PaymentTypeInformation20CH)object).setLclInstrm(localInstrument2CH);
            ((PaymentTypeInformation20CH)object).setSeqTp(sEPADirectDebit.isDirectDebitTypeFromFile() ? DirectDebitType.getSequenceType001CH(sEPADirectDebitTransaction.getDirectDebitType()) : DirectDebitType.getSequenceType001CH(sEPADirectDebit.getType()));
            paymentInstructionInformation4CH.setPmtTpInf((PaymentTypeInformation20CH)object);
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.isCollectionDateFromFile() ? sEPADirectDebitTransaction.getCollectionDate() : sEPADirectDebit.getCollectionDate());
                paymentInstructionInformation4CH.setReqdColltnDt(xMLGregorianCalendar);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender(collectionDate)!", datatypeConfigurationException);
            }
            PartyIdentification32CHNameAndAddress partyIdentification32CHNameAndAddress = new PartyIdentification32CHNameAndAddress();
            partyIdentification32CHNameAndAddress.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformation4CH.setCdtr(partyIdentification32CHNameAndAddress);
            CashAccount16CHIdAndCurrency cashAccount16CHIdAndCurrency = new CashAccount16CHIdAndCurrency();
            AccountIdentification4ChoiceCH accountIdentification4ChoiceCH = new AccountIdentification4ChoiceCH();
            accountIdentification4ChoiceCH.setIBAN(sEPADirectDebit.getIBAN());
            cashAccount16CHIdAndCurrency.setId(accountIdentification4ChoiceCH);
            paymentInstructionInformation4CH.setCdtrAcct(cashAccount16CHIdAndCurrency);
            BranchAndFinancialInstitutionIdentification4CHFinId branchAndFinancialInstitutionIdentification4CHFinId = new BranchAndFinancialInstitutionIdentification4CHFinId();
            FinancialInstitutionIdentification7CHBic financialInstitutionIdentification7CHBic = new FinancialInstitutionIdentification7CHBic();
            financialInstitutionIdentification7CHBic.setBIC(sEPADirectDebit.getBIC());
            branchAndFinancialInstitutionIdentification4CHFinId.setFinInstnId(financialInstitutionIdentification7CHBic);
            paymentInstructionInformation4CH.setCdtrAgt(branchAndFinancialInstitutionIdentification4CHFinId);
            if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation4CH.setChrgBr(ChargeBearerType1CodeCH.fromValue(sEPADirectDebit.getChargeBearer().name()));
            }
            PartyIdentification32CHPrivId partyIdentification32CHPrivId = new PartyIdentification32CHPrivId();
            Party6CHPrivId2 party6CHPrivId2 = new Party6CHPrivId2();
            PersonIdentification5CHPrtry personIdentification5CHPrtry = new PersonIdentification5CHPrtry();
            GenericPersonIdentification1CHPrtry genericPersonIdentification1CHPrtry = new GenericPersonIdentification1CHPrtry();
            genericPersonIdentification1CHPrtry.setId(sEPADirectDebit.getGlaeubigerId());
            PersonIdentificationSchemeName1CHPrtry personIdentificationSchemeName1CHPrtry = new PersonIdentificationSchemeName1CHPrtry();
            personIdentificationSchemeName1CHPrtry.setPrtry(PersonIdentificationSchemeName1CodeCH.SEPA);
            genericPersonIdentification1CHPrtry.setSchmeNm(personIdentificationSchemeName1CHPrtry);
            personIdentification5CHPrtry.setOthr(genericPersonIdentification1CHPrtry);
            party6CHPrivId2.setPrvtId(personIdentification5CHPrtry);
            partyIdentification32CHPrivId.setId(party6CHPrivId2);
            paymentInstructionInformation4CH.setCdtrSchmeId(partyIdentification32CHPrivId);
            if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                CategoryPurpose1Choice categoryPurpose1Choice = new CategoryPurpose1Choice();
                categoryPurpose1Choice.setCd(sEPADirectDebit.getCategoryPurpose().name());
                ((PaymentTypeInformation20CH)object).setCtgyPurp(categoryPurpose1Choice);
            }
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation4CH.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), 1, sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation4CH> list, String string, PartyIdentification32CHNameAndOrgId partyIdentification32CHNameAndOrgId) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PaymentInstructionInformation4CH paymentInstructionInformation4CH = new PaymentInstructionInformation4CH();
        list.add(paymentInstructionInformation4CH);
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
            object5 = new PartyIdentification32CHNameAndId();
            object4 = new Party6ChoiceCHId();
            ((PartyIdentification32CHNameAndId)object5).setId((Party6ChoiceCHId)object4);
            paymentInstructionInformation4CH.setUltmtCdtr((PartyIdentification32CHNameAndId)object5);
            object3 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
            object2 = new OrganisationIdentification4CH();
            ((OrganisationIdentification4CH)object2).setOthr((GenericOrganisationIdentification1)object3);
            ((Party6ChoiceCHId)object4).setOrgId((OrganisationIdentification4CH)object2);
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
            object5 = new PartyIdentification32CHNameAndId();
            object4 = new Party6ChoiceCHId();
            ((PartyIdentification32CHNameAndId)object5).setId((Party6ChoiceCHId)object4);
            paymentInstructionInformation4CH.setUltmtCdtr((PartyIdentification32CHNameAndId)object5);
            object3 = new GenericPersonIdentification1();
            ((GenericPersonIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
            object2 = new PersonIdentification5CH();
            ((PersonIdentification5CH)object2).setOthr((GenericPersonIdentification1)object3);
            ((Party6ChoiceCHId)object4).setPrvtId((PersonIdentification5CH)object2);
        }
        partyIdentification32CHNameAndOrgId.setNm(sEPADirectDebit.getKontoinhaber());
        object5 = new Party6CHOrgId();
        object4 = new OrganisationIdentification4CH2();
        object3 = new GenericOrganisationIdentification1();
        ((GenericOrganisationIdentification1)object3).setId(sEPADirectDebit.getGlaeubigerId());
        ((OrganisationIdentification4CH2)object4).setOthr((GenericOrganisationIdentification1)object3);
        ((Party6CHOrgId)object5).setOrgId((OrganisationIdentification4CH2)object4);
        partyIdentification32CHNameAndOrgId.setId((Party6CHOrgId)object5);
        paymentInstructionInformation4CH.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation4CH.setPmtMtd(PaymentMethod2Code.DD);
        paymentInstructionInformation4CH.setNbOfTxs(string);
        if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformation4CH.setBtchBookg(Boolean.TRUE);
        } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformation4CH.setBtchBookg(Boolean.FALSE);
        }
        object2 = new PaymentTypeInformation20CH();
        ServiceLevel8CHCode serviceLevel8CHCode = new ServiceLevel8CHCode();
        serviceLevel8CHCode.setCd(ServiceLevel8CodeCH.SEPA);
        ((PaymentTypeInformation20CH)object2).setSvcLvl(serviceLevel8CHCode);
        LocalInstrument2CH localInstrument2CH = new LocalInstrument2CH();
        if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
            localInstrument2CH.setCd(LocalInstrumentCodeCH.B_2_B);
        } else {
            localInstrument2CH.setCd(LocalInstrumentCodeCH.CORE);
        }
        ((PaymentTypeInformation20CH)object2).setLclInstrm(localInstrument2CH);
        ((PaymentTypeInformation20CH)object2).setSeqTp(DirectDebitType.getSequenceType001CH(sEPADirectDebit.getType()));
        paymentInstructionInformation4CH.setPmtTpInf((PaymentTypeInformation20CH)object2);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.getCollectionDate());
            paymentInstructionInformation4CH.setReqdColltnDt(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
        }
        PartyIdentification32CHNameAndAddress partyIdentification32CHNameAndAddress = new PartyIdentification32CHNameAndAddress();
        partyIdentification32CHNameAndAddress.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformation4CH.setCdtr(partyIdentification32CHNameAndAddress);
        CashAccount16CHIdAndCurrency cashAccount16CHIdAndCurrency = new CashAccount16CHIdAndCurrency();
        AccountIdentification4ChoiceCH accountIdentification4ChoiceCH = new AccountIdentification4ChoiceCH();
        accountIdentification4ChoiceCH.setIBAN(sEPADirectDebit.getIBAN());
        cashAccount16CHIdAndCurrency.setId(accountIdentification4ChoiceCH);
        paymentInstructionInformation4CH.setCdtrAcct(cashAccount16CHIdAndCurrency);
        BranchAndFinancialInstitutionIdentification4CHFinId branchAndFinancialInstitutionIdentification4CHFinId = new BranchAndFinancialInstitutionIdentification4CHFinId();
        FinancialInstitutionIdentification7CHBic financialInstitutionIdentification7CHBic = new FinancialInstitutionIdentification7CHBic();
        financialInstitutionIdentification7CHBic.setBIC(sEPADirectDebit.getBIC());
        branchAndFinancialInstitutionIdentification4CHFinId.setFinInstnId(financialInstitutionIdentification7CHBic);
        paymentInstructionInformation4CH.setCdtrAgt(branchAndFinancialInstitutionIdentification4CHFinId);
        if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation4CH.setChrgBr(ChargeBearerType1CodeCH.fromValue(sEPADirectDebit.getChargeBearer().name()));
        }
        PartyIdentification32CHPrivId partyIdentification32CHPrivId = new PartyIdentification32CHPrivId();
        Party6CHPrivId2 party6CHPrivId2 = new Party6CHPrivId2();
        PersonIdentification5CHPrtry personIdentification5CHPrtry = new PersonIdentification5CHPrtry();
        GenericPersonIdentification1CHPrtry genericPersonIdentification1CHPrtry = new GenericPersonIdentification1CHPrtry();
        genericPersonIdentification1CHPrtry.setId(sEPADirectDebit.getGlaeubigerId());
        PersonIdentificationSchemeName1CHPrtry personIdentificationSchemeName1CHPrtry = new PersonIdentificationSchemeName1CHPrtry();
        personIdentificationSchemeName1CHPrtry.setPrtry(PersonIdentificationSchemeName1CodeCH.SEPA);
        genericPersonIdentification1CHPrtry.setSchmeNm(personIdentificationSchemeName1CHPrtry);
        personIdentification5CHPrtry.setOthr(genericPersonIdentification1CHPrtry);
        party6CHPrivId2.setPrvtId(personIdentification5CHPrtry);
        partyIdentification32CHPrivId.setId(party6CHPrivId2);
        paymentInstructionInformation4CH.setCdtrSchmeId(partyIdentification32CHPrivId);
        if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object = new CategoryPurpose1Choice();
            ((CategoryPurpose1Choice)object).setCd(sEPADirectDebit.getCategoryPurpose().name());
            ((PaymentTypeInformation20CH)object2).setCtgyPurp((CategoryPurpose1Choice)object);
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation4CH.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), ++n, sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
        }
        return object;
    }

    private DirectDebitTransactionInformation9CH getDirectDebitTransaction(BigDecimal bigDecimal, String string, String string2, String string3, String string4, String string5, GregorianCalendar gregorianCalendar, boolean bl, int n, String string6, boolean bl2, String string7, String string8, String string9, String string10) {
        Object object;
        Object object2;
        DirectDebitTransactionInformation9CH directDebitTransactionInformation9CH = new DirectDebitTransactionInformation9CH();
        PaymentIdentification1CH paymentIdentification1CH = new PaymentIdentification1CH();
        if (bl) {
            paymentIdentification1CH.setEndToEndId(IDGenerator.generateId());
        } else if (bl2 && StringUtils.trimToNull(string7) != null) {
            paymentIdentification1CH.setEndToEndId(string7);
        } else if (StringUtils.trimToNull(string6) != null) {
            paymentIdentification1CH.setEndToEndId(string6);
        } else {
            paymentIdentification1CH.setEndToEndId("NOTPROVIDED");
        }
        paymentIdentification1CH.setInstrId(String.valueOf(n));
        directDebitTransactionInformation9CH.setPmtId(paymentIdentification1CH);
        ActiveOrHistoricCurrencyAndAmountCHEUR activeOrHistoricCurrencyAndAmountCHEUR = new ActiveOrHistoricCurrencyAndAmountCHEUR();
        activeOrHistoricCurrencyAndAmountCHEUR.setCcy(ActiveOrHistoricCurrencyCodeCHEUR.EUR);
        activeOrHistoricCurrencyAndAmountCHEUR.setValue(bigDecimal);
        directDebitTransactionInformation9CH.setInstdAmt(activeOrHistoricCurrencyAndAmountCHEUR);
        DirectDebitTransaction6CH directDebitTransaction6CH = new DirectDebitTransaction6CH();
        MandateRelatedInformation6CH mandateRelatedInformation6CH = new MandateRelatedInformation6CH();
        mandateRelatedInformation6CH.setMndtId(string4);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            mandateRelatedInformation6CH.setDtOfSgntr(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (dateOfSignature)!", datatypeConfigurationException);
        }
        directDebitTransaction6CH.setMndtRltdInf(mandateRelatedInformation6CH);
        directDebitTransactionInformation9CH.setDrctDbtTx(directDebitTransaction6CH);
        if (string2 != null && !string2.isEmpty()) {
            object2 = new BranchAndFinancialInstitutionIdentification4CHFinId();
            object = new FinancialInstitutionIdentification7CHBic();
            ((FinancialInstitutionIdentification7CHBic)object).setBIC(string2);
            ((BranchAndFinancialInstitutionIdentification4CHFinId)object2).setFinInstnId((FinancialInstitutionIdentification7CHBic)object);
            directDebitTransactionInformation9CH.setDbtrAgt((BranchAndFinancialInstitutionIdentification4CHFinId)object2);
        }
        object2 = new PartyIdentification32CHNameAddressId();
        ((PartyIdentification32CHNameAddressId)object2).setNm(string);
        if (string8 != null || string9 != null || string10 != null) {
            object = new PostalAddress6CH();
            ((PartyIdentification32CHNameAddressId)object2).setPstlAdr((PostalAddress6CH)object);
            if (!string8.isEmpty()) {
                ((PostalAddress6CH)object).setCtry(string8);
            }
            if (string9 != null && !string9.isEmpty()) {
                ((PostalAddress6CH)object).getAdrLine().add(string9);
            }
            if (string10 != null && !string10.isEmpty()) {
                ((PostalAddress6CH)object).getAdrLine().add(string10);
            }
        }
        directDebitTransactionInformation9CH.setDbtr((PartyIdentification32CHNameAddressId)object2);
        object = new CashAccount16CHIdAndCurrency();
        AccountIdentification4ChoiceCH accountIdentification4ChoiceCH = new AccountIdentification4ChoiceCH();
        accountIdentification4ChoiceCH.setIBAN(string3);
        ((CashAccount16CHIdAndCurrency)object).setId(accountIdentification4ChoiceCH);
        directDebitTransactionInformation9CH.setDbtrAcct((CashAccount16CHIdAndCurrency)object);
        RemittanceInformation5CH remittanceInformation5CH = new RemittanceInformation5CH();
        remittanceInformation5CH.setUstrd(string5);
        directDebitTransactionInformation9CH.setRmtInf(remittanceInformation5CH);
        return directDebitTransactionInformation9CH;
    }
}

