/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.pain008_001_02_austrian_003.ATCustomerDirectDebitInitiationV02;
import com.codecamp.sepa.pain008_001_02_austrian_003.AccountIdentification4Choice;
import com.codecamp.sepa.pain008_001_02_austrian_003.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.pain008_001_02_austrian_003.BranchAndFinancialInstitutionIdentification4;
import com.codecamp.sepa.pain008_001_02_austrian_003.CashAccount16;
import com.codecamp.sepa.pain008_001_02_austrian_003.CategoryPurpose1Choice;
import com.codecamp.sepa.pain008_001_02_austrian_003.ChargeBearerType1Code;
import com.codecamp.sepa.pain008_001_02_austrian_003.ContactDetails2;
import com.codecamp.sepa.pain008_001_02_austrian_003.DirectDebitTransaction6;
import com.codecamp.sepa.pain008_001_02_austrian_003.DirectDebitTransactionInformation9;
import com.codecamp.sepa.pain008_001_02_austrian_003.Document;
import com.codecamp.sepa.pain008_001_02_austrian_003.FinancialInstitutionIdentification7;
import com.codecamp.sepa.pain008_001_02_austrian_003.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain008_001_02_austrian_003.GenericPersonIdentification1;
import com.codecamp.sepa.pain008_001_02_austrian_003.GroupHeader39;
import com.codecamp.sepa.pain008_001_02_austrian_003.LocalInstrument2Choice;
import com.codecamp.sepa.pain008_001_02_austrian_003.MandateRelatedInformation6;
import com.codecamp.sepa.pain008_001_02_austrian_003.OrganisationIdentification4;
import com.codecamp.sepa.pain008_001_02_austrian_003.Party6Choice;
import com.codecamp.sepa.pain008_001_02_austrian_003.PartyIdentification32;
import com.codecamp.sepa.pain008_001_02_austrian_003.PaymentIdentification1;
import com.codecamp.sepa.pain008_001_02_austrian_003.PaymentInstructionInformation4;
import com.codecamp.sepa.pain008_001_02_austrian_003.PaymentMethod2Code;
import com.codecamp.sepa.pain008_001_02_austrian_003.PaymentTypeInformation20;
import com.codecamp.sepa.pain008_001_02_austrian_003.PersonIdentification5;
import com.codecamp.sepa.pain008_001_02_austrian_003.PersonIdentificationSchemeName1Choice;
import com.codecamp.sepa.pain008_001_02_austrian_003.PostalAddress6;
import com.codecamp.sepa.pain008_001_02_austrian_003.RemittanceInformation5;
import com.codecamp.sepa.pain008_001_02_austrian_003.ServiceLevel8Choice;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLDirectDebitBuilder001AT {
    private final Logger logger = Logger.getLogger(SEPAXMLDirectDebitBuilder001AT.class.getName());

    protected Document getDirectDebit(SEPADirectDebit sEPADirectDebit) {
        Party6Choice party6Choice;
        Object object;
        Object object2;
        Document document = new Document();
        ATCustomerDirectDebitInitiationV02 aTCustomerDirectDebitInitiationV02 = new ATCustomerDirectDebitInitiationV02();
        document.setCstmrDrctDbtInitn(aTCustomerDirectDebitInitiationV02);
        GroupHeader39 groupHeader39 = new GroupHeader39();
        aTCustomerDirectDebitInitiationV02.setGrpHdr(groupHeader39);
        groupHeader39.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader39.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPADirectDebit.getTransactionList().size());
        groupHeader39.setNbOfTxs(string);
        PartyIdentification32 partyIdentification32 = new PartyIdentification32();
        groupHeader39.setInitgPty(partyIdentification32);
        if (sEPADirectDebit.isAddSoftwareNameAndVendor()) {
            object2 = new ContactDetails2();
            partyIdentification32.setCtctDtls((ContactDetails2)object2);
            object = new SEPAPreferences();
            ((ContactDetails2)object2).setNm(((SEPAPreferences)object).loadPreference(FieldType.SOFTWARE_NAME_AND_VENDOR.name(), "SEPAApp/Janus Software Solutions"));
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
            object2 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object2).setId(sEPADirectDebit.getIdentificationID());
            object = new OrganisationIdentification4();
            ((OrganisationIdentification4)object).getOthr().add((GenericOrganisationIdentification1)object2);
            party6Choice = new Party6Choice();
            party6Choice.setOrgId((OrganisationIdentification4)object);
            partyIdentification32.setId(party6Choice);
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
            object2 = new GenericPersonIdentification1();
            ((GenericPersonIdentification1)object2).setId(sEPADirectDebit.getIdentificationID());
            object = new PersonIdentification5();
            ((PersonIdentification5)object).getOthr().add((GenericPersonIdentification1)object2);
            party6Choice = new Party6Choice();
            party6Choice.setPrvtId((PersonIdentification5)object);
            partyIdentification32.setId(party6Choice);
        }
        partyIdentification32.setNm(sEPADirectDebit.getKontoinhaber());
        object2 = aTCustomerDirectDebitInitiationV02.getPmtInf();
        object = new BigDecimal(0).setScale(2);
        object = sEPADirectDebit.getUsePIIforEachTrx() || sEPADirectDebit.isCollectionDateFromFile() || sEPADirectDebit.isDirectDebitTypeFromFile() ? this.addPIIForEachTrx(sEPADirectDebit, (List<PaymentInstructionInformation4>)object2) : this.addSinglePII(sEPADirectDebit, (List<PaymentInstructionInformation4>)object2, string);
        groupHeader39.setCtrlSum(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation4> list) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            PaymentInstructionInformation4 paymentInstructionInformation4 = new PaymentInstructionInformation4();
            list.add(paymentInstructionInformation4);
            paymentInstructionInformation4.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation4.setPmtMtd(PaymentMethod2Code.DD);
            paymentInstructionInformation4.setNbOfTxs("1");
            if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformation4.setBtchBookg(Boolean.TRUE);
            } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformation4.setBtchBookg(Boolean.FALSE);
            }
            PaymentTypeInformation20 paymentTypeInformation20 = new PaymentTypeInformation20();
            ServiceLevel8Choice serviceLevel8Choice = new ServiceLevel8Choice();
            serviceLevel8Choice.setCd("SEPA");
            paymentTypeInformation20.setSvcLvl(serviceLevel8Choice);
            LocalInstrument2Choice localInstrument2Choice = new LocalInstrument2Choice();
            if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
                localInstrument2Choice.setCd("B2B");
            } else if (DirectDebitKind.COR1.equals((Object)sEPADirectDebit.getKind())) {
                localInstrument2Choice.setCd("COR1");
            } else {
                localInstrument2Choice.setCd("CORE");
            }
            paymentTypeInformation20.setLclInstrm(localInstrument2Choice);
            paymentTypeInformation20.setSeqTp(sEPADirectDebit.isDirectDebitTypeFromFile() ? DirectDebitType.getSequenceType001AT(sEPADirectDebitTransaction.getDirectDebitType()) : DirectDebitType.getSequenceType001AT(sEPADirectDebit.getType()));
            paymentInstructionInformation4.setPmtTpInf(paymentTypeInformation20);
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.isCollectionDateFromFile() ? sEPADirectDebitTransaction.getCollectionDate() : sEPADirectDebit.getCollectionDate());
                paymentInstructionInformation4.setReqdColltnDt(xMLGregorianCalendar);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
            }
            PartyIdentification32 partyIdentification32 = new PartyIdentification32();
            partyIdentification32.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformation4.setCdtr(partyIdentification32);
            CashAccount16 cashAccount16 = new CashAccount16();
            AccountIdentification4Choice accountIdentification4Choice = new AccountIdentification4Choice();
            accountIdentification4Choice.setIBAN(sEPADirectDebit.getIBAN());
            cashAccount16.setId(accountIdentification4Choice);
            paymentInstructionInformation4.setCdtrAcct(cashAccount16);
            BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = new BranchAndFinancialInstitutionIdentification4();
            FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
            financialInstitutionIdentification7.setBIC(sEPADirectDebit.getBIC());
            branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
            paymentInstructionInformation4.setCdtrAgt(branchAndFinancialInstitutionIdentification4);
            if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation4.setChrgBr(ChargeBearerType1Code.fromValue(sEPADirectDebit.getChargeBearer().name()));
            }
            PartyIdentification32 partyIdentification322 = new PartyIdentification32();
            Party6Choice party6Choice = new Party6Choice();
            PersonIdentification5 personIdentification5 = new PersonIdentification5();
            GenericPersonIdentification1 genericPersonIdentification1 = new GenericPersonIdentification1();
            genericPersonIdentification1.setId(sEPADirectDebit.getGlaeubigerId());
            PersonIdentificationSchemeName1Choice personIdentificationSchemeName1Choice = new PersonIdentificationSchemeName1Choice();
            personIdentificationSchemeName1Choice.setPrtry("SEPA");
            genericPersonIdentification1.setSchmeNm(personIdentificationSchemeName1Choice);
            personIdentification5.getOthr().add(genericPersonIdentification1);
            party6Choice.setPrvtId(personIdentification5);
            partyIdentification322.setId(party6Choice);
            paymentInstructionInformation4.setCdtrSchmeId(partyIdentification322);
            if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                CategoryPurpose1Choice categoryPurpose1Choice = new CategoryPurpose1Choice();
                categoryPurpose1Choice.setCd(sEPADirectDebit.getCategoryPurpose().name());
                paymentTypeInformation20.setCtgyPurp(categoryPurpose1Choice);
            }
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation4.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), 1, sEPADirectDebit.isSetTxNo(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
            paymentInstructionInformation4.setCtrlSum(sEPADirectDebitTransaction.getAmount().setScale(2));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation4> list, String string) {
        Object object;
        PaymentInstructionInformation4 paymentInstructionInformation4 = new PaymentInstructionInformation4();
        list.add(paymentInstructionInformation4);
        paymentInstructionInformation4.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation4.setPmtMtd(PaymentMethod2Code.DD);
        paymentInstructionInformation4.setNbOfTxs(string);
        if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformation4.setBtchBookg(Boolean.TRUE);
        } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformation4.setBtchBookg(Boolean.FALSE);
        }
        PaymentTypeInformation20 paymentTypeInformation20 = new PaymentTypeInformation20();
        ServiceLevel8Choice serviceLevel8Choice = new ServiceLevel8Choice();
        serviceLevel8Choice.setCd("SEPA");
        paymentTypeInformation20.setSvcLvl(serviceLevel8Choice);
        LocalInstrument2Choice localInstrument2Choice = new LocalInstrument2Choice();
        if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
            localInstrument2Choice.setCd("B2B");
        } else if (DirectDebitKind.COR1.equals((Object)sEPADirectDebit.getKind())) {
            localInstrument2Choice.setCd("COR1");
        } else {
            localInstrument2Choice.setCd("CORE");
        }
        paymentTypeInformation20.setLclInstrm(localInstrument2Choice);
        paymentTypeInformation20.setSeqTp(DirectDebitType.getSequenceType001AT(sEPADirectDebit.getType()));
        paymentInstructionInformation4.setPmtTpInf(paymentTypeInformation20);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.getCollectionDate());
            paymentInstructionInformation4.setReqdColltnDt(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
        }
        PartyIdentification32 partyIdentification32 = new PartyIdentification32();
        partyIdentification32.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformation4.setCdtr(partyIdentification32);
        CashAccount16 cashAccount16 = new CashAccount16();
        AccountIdentification4Choice accountIdentification4Choice = new AccountIdentification4Choice();
        accountIdentification4Choice.setIBAN(sEPADirectDebit.getIBAN());
        cashAccount16.setId(accountIdentification4Choice);
        paymentInstructionInformation4.setCdtrAcct(cashAccount16);
        BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = new BranchAndFinancialInstitutionIdentification4();
        FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
        financialInstitutionIdentification7.setBIC(sEPADirectDebit.getBIC());
        branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
        paymentInstructionInformation4.setCdtrAgt(branchAndFinancialInstitutionIdentification4);
        if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation4.setChrgBr(ChargeBearerType1Code.fromValue(sEPADirectDebit.getChargeBearer().name()));
        }
        PartyIdentification32 partyIdentification322 = new PartyIdentification32();
        Party6Choice party6Choice = new Party6Choice();
        PersonIdentification5 personIdentification5 = new PersonIdentification5();
        GenericPersonIdentification1 genericPersonIdentification1 = new GenericPersonIdentification1();
        genericPersonIdentification1.setId(sEPADirectDebit.getGlaeubigerId());
        PersonIdentificationSchemeName1Choice personIdentificationSchemeName1Choice = new PersonIdentificationSchemeName1Choice();
        personIdentificationSchemeName1Choice.setPrtry("SEPA");
        genericPersonIdentification1.setSchmeNm(personIdentificationSchemeName1Choice);
        personIdentification5.getOthr().add(genericPersonIdentification1);
        party6Choice.setPrvtId(personIdentification5);
        partyIdentification322.setId(party6Choice);
        paymentInstructionInformation4.setCdtrSchmeId(partyIdentification322);
        if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object = new CategoryPurpose1Choice();
            ((CategoryPurpose1Choice)object).setCd(sEPADirectDebit.getCategoryPurpose().name());
            paymentTypeInformation20.setCtgyPurp((CategoryPurpose1Choice)object);
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation4.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), ++n, sEPADirectDebit.isSetTxNo(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
        }
        paymentInstructionInformation4.setCtrlSum(((BigDecimal)object).setScale(2));
        return object;
    }

    private DirectDebitTransactionInformation9 getDirectDebitTransaction(BigDecimal bigDecimal, String string, String string2, String string3, String string4, String string5, GregorianCalendar gregorianCalendar, boolean bl, String string6, boolean bl2, String string7, int n, boolean bl3, String string8, String string9, String string10, String string11, String string12) {
        Object object;
        Object object2;
        DirectDebitTransactionInformation9 directDebitTransactionInformation9 = new DirectDebitTransactionInformation9();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (bl2 && StringUtils.trimToNull(string7) != null) {
            paymentIdentification1.setEndToEndId(string7);
        } else if (StringUtils.trimToNull(string6) != null) {
            paymentIdentification1.setEndToEndId(string6);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        if (bl3) {
            paymentIdentification1.setInstrId(String.valueOf(n));
        }
        directDebitTransactionInformation9.setPmtId(paymentIdentification1);
        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
        activeOrHistoricCurrencyAndAmount.setCcy(string9 != null ? string9 : string8);
        activeOrHistoricCurrencyAndAmount.setValue(bigDecimal);
        directDebitTransactionInformation9.setInstdAmt(activeOrHistoricCurrencyAndAmount);
        DirectDebitTransaction6 directDebitTransaction6 = new DirectDebitTransaction6();
        MandateRelatedInformation6 mandateRelatedInformation6 = new MandateRelatedInformation6();
        mandateRelatedInformation6.setMndtId(string4);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            mandateRelatedInformation6.setDtOfSgntr(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (dateOfSignature)!", datatypeConfigurationException);
        }
        directDebitTransaction6.setMndtRltdInf(mandateRelatedInformation6);
        directDebitTransactionInformation9.setDrctDbtTx(directDebitTransaction6);
        if (string2 != null && !string2.isEmpty()) {
            object2 = new BranchAndFinancialInstitutionIdentification4();
            object = new FinancialInstitutionIdentification7();
            ((FinancialInstitutionIdentification7)object).setBIC(string2);
            ((BranchAndFinancialInstitutionIdentification4)object2).setFinInstnId((FinancialInstitutionIdentification7)object);
            directDebitTransactionInformation9.setDbtrAgt((BranchAndFinancialInstitutionIdentification4)object2);
        }
        object2 = new PartyIdentification32();
        ((PartyIdentification32)object2).setNm(string);
        if (string10 != null || string11 != null || string12 != null) {
            object = new PostalAddress6();
            ((PartyIdentification32)object2).setPstlAdr((PostalAddress6)object);
            if (!string10.isEmpty()) {
                ((PostalAddress6)object).setCtry(string10);
            }
            if (string11 != null && !string11.isEmpty()) {
                ((PostalAddress6)object).getAdrLine().add(string11);
            }
            if (string12 != null && !string12.isEmpty()) {
                ((PostalAddress6)object).getAdrLine().add(string12);
            }
        }
        directDebitTransactionInformation9.setDbtr((PartyIdentification32)object2);
        object = new CashAccount16();
        AccountIdentification4Choice accountIdentification4Choice = new AccountIdentification4Choice();
        accountIdentification4Choice.setIBAN(string3);
        ((CashAccount16)object).setId(accountIdentification4Choice);
        directDebitTransactionInformation9.setDbtrAcct((CashAccount16)object);
        RemittanceInformation5 remittanceInformation5 = new RemittanceInformation5();
        remittanceInformation5.getUstrd().add(string5);
        directDebitTransactionInformation9.setRmtInf(remittanceInformation5);
        return directDebitTransactionInformation9;
    }
}

