/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.pain001_002_03.AccountIdentificationSEPA;
import com.codecamp.sepa.pain001_002_03.ActiveOrHistoricCurrencyAndAmountSEPA;
import com.codecamp.sepa.pain001_002_03.ActiveOrHistoricCurrencyCodeEUR;
import com.codecamp.sepa.pain001_002_03.AmountTypeSEPA;
import com.codecamp.sepa.pain001_002_03.BranchAndFinancialInstitutionIdentificationSEPA1;
import com.codecamp.sepa.pain001_002_03.CashAccountSEPA1;
import com.codecamp.sepa.pain001_002_03.CashAccountSEPA2;
import com.codecamp.sepa.pain001_002_03.CategoryPurposeSEPA;
import com.codecamp.sepa.pain001_002_03.ChargeBearerTypeSEPACode;
import com.codecamp.sepa.pain001_002_03.CreditTransferTransactionInformationSCT;
import com.codecamp.sepa.pain001_002_03.CustomerCreditTransferInitiationV03;
import com.codecamp.sepa.pain001_002_03.Document;
import com.codecamp.sepa.pain001_002_03.FinancialInstitutionIdentificationSEPA1;
import com.codecamp.sepa.pain001_002_03.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain001_002_03.GenericPersonIdentification1;
import com.codecamp.sepa.pain001_002_03.GroupHeaderSCT;
import com.codecamp.sepa.pain001_002_03.OrganisationIdentificationSEPAChoice;
import com.codecamp.sepa.pain001_002_03.PartyIdentificationSEPA1;
import com.codecamp.sepa.pain001_002_03.PartyIdentificationSEPA2;
import com.codecamp.sepa.pain001_002_03.PartySEPAChoice;
import com.codecamp.sepa.pain001_002_03.PaymentIdentificationSEPA;
import com.codecamp.sepa.pain001_002_03.PaymentInstructionInformationSCT;
import com.codecamp.sepa.pain001_002_03.PaymentMethodSCTCode;
import com.codecamp.sepa.pain001_002_03.PaymentTypeInformationSCT1;
import com.codecamp.sepa.pain001_002_03.PersonIdentificationSEPA1Choice;
import com.codecamp.sepa.pain001_002_03.PostalAddressSEPA;
import com.codecamp.sepa.pain001_002_03.Priority2Code;
import com.codecamp.sepa.pain001_002_03.RemittanceInformationSEPA1Choice;
import com.codecamp.sepa.pain001_002_03.ServiceLevelSEPA;
import com.codecamp.sepa.pain001_002_03.ServiceLevelSEPACode;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLCreditTransferBuilder002 {
    private final Logger logger = Logger.getLogger(SEPAXMLCreditTransferBuilder002.class.getName());

    public Document getCreditTransfer(SEPACreditTransfer sEPACreditTransfer) {
        Object object;
        Document document = new Document();
        CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03 = new CustomerCreditTransferInitiationV03();
        document.setCstmrCdtTrfInitn(customerCreditTransferInitiationV03);
        GroupHeaderSCT groupHeaderSCT = new GroupHeaderSCT();
        customerCreditTransferInitiationV03.setGrpHdr(groupHeaderSCT);
        groupHeaderSCT.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeaderSCT.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPACreditTransfer.getTransactionList().size());
        groupHeaderSCT.setNbOfTxs(string);
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() || sEPACreditTransfer.isNameInInitParty()) {
            object = new PartyIdentificationSEPA1();
            groupHeaderSCT.setInitgPty((PartyIdentificationSEPA1)object);
            if (sEPACreditTransfer.isNameInInitParty()) {
                ((PartyIdentificationSEPA1)object).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty()) {
                PartySEPAChoice partySEPAChoice;
                Object object2;
                Object object3;
                if (sEPACreditTransfer.isIdentIdOrg()) {
                    object3 = new GenericOrganisationIdentification1();
                    ((GenericOrganisationIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new OrganisationIdentificationSEPAChoice();
                    ((OrganisationIdentificationSEPAChoice)object2).setOthr((GenericOrganisationIdentification1)object3);
                    partySEPAChoice = new PartySEPAChoice();
                    partySEPAChoice.setOrgId((OrganisationIdentificationSEPAChoice)object2);
                    ((PartyIdentificationSEPA1)object).setId(partySEPAChoice);
                }
                if (sEPACreditTransfer.isIdentIdPrv()) {
                    object3 = new GenericPersonIdentification1();
                    ((GenericPersonIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new PersonIdentificationSEPA1Choice();
                    ((PersonIdentificationSEPA1Choice)object2).setOthr((GenericPersonIdentification1)object3);
                    partySEPAChoice = new PartySEPAChoice();
                    partySEPAChoice.setPrvtId((PersonIdentificationSEPA1Choice)object2);
                    ((PartyIdentificationSEPA1)object).setId(partySEPAChoice);
                }
            }
        }
        object = new BigDecimal(0).setScale(2);
        object = sEPACreditTransfer.getUsePIIforEachTrx() || sEPACreditTransfer.isExecutionDateFromFile() || sEPACreditTransfer.isPayerFromFile() ? this.addPIIForEachTrx(sEPACreditTransfer, customerCreditTransferInitiationV03) : this.addSinglePII(sEPACreditTransfer, customerCreditTransferInitiationV03, string);
        groupHeaderSCT.setCtrlSum(((BigDecimal)object).setScale(2));
        sEPACreditTransfer.setSumOfTx(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            Object object;
            Object object2;
            PaymentInstructionInformationSCT paymentInstructionInformationSCT = new PaymentInstructionInformationSCT();
            customerCreditTransferInitiationV03.getPmtInf().add(paymentInstructionInformationSCT);
            paymentInstructionInformationSCT.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformationSCT.setPmtMtd(PaymentMethodSCTCode.TRF);
            if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformationSCT.setBtchBookg(Boolean.TRUE);
            } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformationSCT.setBtchBookg(Boolean.FALSE);
            }
            PaymentTypeInformationSCT1 paymentTypeInformationSCT1 = new PaymentTypeInformationSCT1();
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                object2 = new CategoryPurposeSEPA();
                ((CategoryPurposeSEPA)object2).setCd(sEPACreditTransfer.getCategoryPurpose().name());
                paymentTypeInformationSCT1.setCtgyPurp((CategoryPurposeSEPA)object2);
            }
            if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                paymentTypeInformationSCT1.setInstrPrty(Priority2Code.HIGH);
            }
            if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() == ServiceLevel.SEPA) {
                object2 = new ServiceLevelSEPA();
                ((ServiceLevelSEPA)object2).setCd(ServiceLevelSEPACode.SEPA);
                paymentTypeInformationSCT1.setSvcLvl((ServiceLevelSEPA)object2);
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() == ServiceLevel.SEPA) {
                paymentInstructionInformationSCT.setPmtTpInf(paymentTypeInformationSCT1);
            }
            try {
                object2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.isExecutionDateFromFile() ? sEPACreditTransferTransaction.getExecutionDate() : sEPACreditTransfer.getExecutionDate());
                paymentInstructionInformationSCT.setReqdExctnDt((XMLGregorianCalendar)object2);
                ((XMLGregorianCalendar)object2).setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
            }
            PartyIdentificationSEPA2 partyIdentificationSEPA2 = new PartyIdentificationSEPA2();
            paymentInstructionInformationSCT.setDbtr(partyIdentificationSEPA2);
            if (sEPACreditTransfer.isPayerFromFile()) {
                partyIdentificationSEPA2.setNm(sEPACreditTransferTransaction.getKontoinhaberPayerTrx());
            } else {
                partyIdentificationSEPA2.setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                object = new PostalAddressSEPA();
                partyIdentificationSEPA2.setPstlAdr((PostalAddressSEPA)object);
                if (sEPACreditTransfer.getCountryCode() != null) {
                    ((PostalAddressSEPA)object).setCtry(sEPACreditTransfer.getCountryCode());
                }
                if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                    ((PostalAddressSEPA)object).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                }
                if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                    ((PostalAddressSEPA)object).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                }
            }
            object = new CashAccountSEPA1();
            paymentInstructionInformationSCT.setDbtrAcct((CashAccountSEPA1)object);
            AccountIdentificationSEPA accountIdentificationSEPA = new AccountIdentificationSEPA();
            ((CashAccountSEPA1)object).setId(accountIdentificationSEPA);
            if (sEPACreditTransfer.isSetDebitorCurrency()) {
                ((CashAccountSEPA1)object).setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR.name());
            }
            if (sEPACreditTransfer.isPayerFromFile()) {
                accountIdentificationSEPA.setIBAN(sEPACreditTransferTransaction.getIBANPayerTrx());
            } else {
                accountIdentificationSEPA.setIBAN(sEPACreditTransfer.getIBAN());
            }
            BranchAndFinancialInstitutionIdentificationSEPA1 branchAndFinancialInstitutionIdentificationSEPA1 = new BranchAndFinancialInstitutionIdentificationSEPA1();
            paymentInstructionInformationSCT.setDbtrAgt(branchAndFinancialInstitutionIdentificationSEPA1);
            FinancialInstitutionIdentificationSEPA1 financialInstitutionIdentificationSEPA1 = new FinancialInstitutionIdentificationSEPA1();
            branchAndFinancialInstitutionIdentificationSEPA1.setFinInstnId(financialInstitutionIdentificationSEPA1);
            if (sEPACreditTransfer.isPayerFromFile()) {
                financialInstitutionIdentificationSEPA1.setBIC(sEPACreditTransferTransaction.getBICPayerTrx());
            } else {
                financialInstitutionIdentificationSEPA1.setBIC(sEPACreditTransfer.getBIC());
            }
            if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformationSCT.setChrgBr(ChargeBearerTypeSEPACode.fromValue(sEPACreditTransfer.getChargeBearer().name()));
            }
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformationSCT.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), sEPACreditTransfer.getEnd2EndId(), 1, sEPACreditTransfer.isSetTxNo()));
            paymentInstructionInformationSCT.setCtrlSum(sEPACreditTransferTransaction.getAmount().setScale(2));
            paymentInstructionInformationSCT.setNbOfTxs("1");
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03, String string) {
        Object object;
        Object object2;
        PaymentInstructionInformationSCT paymentInstructionInformationSCT = new PaymentInstructionInformationSCT();
        customerCreditTransferInitiationV03.getPmtInf().add(paymentInstructionInformationSCT);
        paymentInstructionInformationSCT.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformationSCT.setPmtMtd(PaymentMethodSCTCode.TRF);
        sEPACreditTransfer.setPmtInfId(paymentInstructionInformationSCT.getPmtInfId());
        if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformationSCT.setBtchBookg(Boolean.TRUE);
        } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformationSCT.setBtchBookg(Boolean.FALSE);
        }
        PaymentTypeInformationSCT1 paymentTypeInformationSCT1 = new PaymentTypeInformationSCT1();
        if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object2 = new CategoryPurposeSEPA();
            ((CategoryPurposeSEPA)object2).setCd(sEPACreditTransfer.getCategoryPurpose().name());
            paymentTypeInformationSCT1.setCtgyPurp((CategoryPurposeSEPA)object2);
        }
        if (sEPACreditTransfer.isUseFastCreditTransfer()) {
            paymentTypeInformationSCT1.setInstrPrty(Priority2Code.HIGH);
        }
        if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() == ServiceLevel.SEPA) {
            object2 = new ServiceLevelSEPA();
            ((ServiceLevelSEPA)object2).setCd(ServiceLevelSEPACode.SEPA);
            paymentTypeInformationSCT1.setSvcLvl((ServiceLevelSEPA)object2);
        }
        if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() == ServiceLevel.SEPA) {
            paymentInstructionInformationSCT.setPmtTpInf(paymentTypeInformationSCT1);
        }
        try {
            object2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.getExecutionDate());
            paymentInstructionInformationSCT.setReqdExctnDt((XMLGregorianCalendar)object2);
            ((XMLGregorianCalendar)object2).setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
        }
        PartyIdentificationSEPA2 partyIdentificationSEPA2 = new PartyIdentificationSEPA2();
        paymentInstructionInformationSCT.setDbtr(partyIdentificationSEPA2);
        partyIdentificationSEPA2.setNm(sEPACreditTransfer.getKontoinhaber());
        if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
            object = new PostalAddressSEPA();
            partyIdentificationSEPA2.setPstlAdr((PostalAddressSEPA)object);
            if (sEPACreditTransfer.getCountryCode() != null) {
                ((PostalAddressSEPA)object).setCtry(sEPACreditTransfer.getCountryCode());
            }
            if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                ((PostalAddressSEPA)object).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
            }
            if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                ((PostalAddressSEPA)object).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
            }
        }
        object = new CashAccountSEPA1();
        paymentInstructionInformationSCT.setDbtrAcct((CashAccountSEPA1)object);
        AccountIdentificationSEPA accountIdentificationSEPA = new AccountIdentificationSEPA();
        ((CashAccountSEPA1)object).setId(accountIdentificationSEPA);
        if (sEPACreditTransfer.isSetDebitorCurrency()) {
            ((CashAccountSEPA1)object).setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR.name());
        }
        accountIdentificationSEPA.setIBAN(sEPACreditTransfer.getIBAN());
        BranchAndFinancialInstitutionIdentificationSEPA1 branchAndFinancialInstitutionIdentificationSEPA1 = new BranchAndFinancialInstitutionIdentificationSEPA1();
        paymentInstructionInformationSCT.setDbtrAgt(branchAndFinancialInstitutionIdentificationSEPA1);
        FinancialInstitutionIdentificationSEPA1 financialInstitutionIdentificationSEPA1 = new FinancialInstitutionIdentificationSEPA1();
        branchAndFinancialInstitutionIdentificationSEPA1.setFinInstnId(financialInstitutionIdentificationSEPA1);
        financialInstitutionIdentificationSEPA1.setBIC(sEPACreditTransfer.getBIC());
        if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformationSCT.setChrgBr(ChargeBearerTypeSEPACode.fromValue(sEPACreditTransfer.getChargeBearer().name()));
        }
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformationSCT.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), sEPACreditTransfer.getEnd2EndId(), ++n, sEPACreditTransfer.isSetTxNo()));
        }
        paymentInstructionInformationSCT.setCtrlSum(bigDecimal.setScale(2));
        paymentInstructionInformationSCT.setNbOfTxs(string);
        return bigDecimal;
    }

    private CreditTransferTransactionInformationSCT getCreditTransferTransaction(SEPACreditTransferTransaction sEPACreditTransferTransaction, SEPACreditTransfer sEPACreditTransfer, boolean bl, String string, int n, boolean bl2) {
        Object object;
        Object object2;
        CreditTransferTransactionInformationSCT creditTransferTransactionInformationSCT = new CreditTransferTransactionInformationSCT();
        PaymentIdentificationSEPA paymentIdentificationSEPA = new PaymentIdentificationSEPA();
        creditTransferTransactionInformationSCT.setPmtId(paymentIdentificationSEPA);
        if (bl) {
            paymentIdentificationSEPA.setEndToEndId(IDGenerator.generateId());
        } else if (sEPACreditTransfer.isEnd2EndIdFromFile() && StringUtils.trimToNull(sEPACreditTransferTransaction.getEnd2EndId()) != null) {
            paymentIdentificationSEPA.setEndToEndId(sEPACreditTransferTransaction.getEnd2EndId());
        } else if (StringUtils.trimToNull(string) != null) {
            paymentIdentificationSEPA.setEndToEndId(string);
        } else {
            paymentIdentificationSEPA.setEndToEndId("NOTPROVIDED");
        }
        sEPACreditTransferTransaction.setEnd2EndId(paymentIdentificationSEPA.getEndToEndId());
        if (bl2) {
            paymentIdentificationSEPA.setInstrId(String.valueOf(n));
        }
        AmountTypeSEPA amountTypeSEPA = new AmountTypeSEPA();
        creditTransferTransactionInformationSCT.setAmt(amountTypeSEPA);
        ActiveOrHistoricCurrencyAndAmountSEPA activeOrHistoricCurrencyAndAmountSEPA = new ActiveOrHistoricCurrencyAndAmountSEPA();
        amountTypeSEPA.setInstdAmt(activeOrHistoricCurrencyAndAmountSEPA);
        activeOrHistoricCurrencyAndAmountSEPA.setValue(sEPACreditTransferTransaction.getAmount());
        activeOrHistoricCurrencyAndAmountSEPA.setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR);
        if (sEPACreditTransferTransaction.getBIC() != null && !sEPACreditTransferTransaction.getBIC().isEmpty()) {
            object2 = new BranchAndFinancialInstitutionIdentificationSEPA1();
            creditTransferTransactionInformationSCT.setCdtrAgt((BranchAndFinancialInstitutionIdentificationSEPA1)object2);
            object = new FinancialInstitutionIdentificationSEPA1();
            ((BranchAndFinancialInstitutionIdentificationSEPA1)object2).setFinInstnId((FinancialInstitutionIdentificationSEPA1)object);
            ((FinancialInstitutionIdentificationSEPA1)object).setBIC(sEPACreditTransferTransaction.getBIC());
        }
        object2 = new PartyIdentificationSEPA2();
        creditTransferTransactionInformationSCT.setCdtr((PartyIdentificationSEPA2)object2);
        ((PartyIdentificationSEPA2)object2).setNm(sEPACreditTransferTransaction.getKontoinhaber());
        if (sEPACreditTransferTransaction.getCountryCode() != null || sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty() || sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
            object = new PostalAddressSEPA();
            ((PartyIdentificationSEPA2)object2).setPstlAdr((PostalAddressSEPA)object);
            if (!sEPACreditTransferTransaction.getCountryCode().isEmpty()) {
                ((PostalAddressSEPA)object).setCtry(sEPACreditTransferTransaction.getCountryCode());
            }
            if (sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty()) {
                ((PostalAddressSEPA)object).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine1());
            }
            if (sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
                ((PostalAddressSEPA)object).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine2());
            }
        }
        object = new CashAccountSEPA2();
        creditTransferTransactionInformationSCT.setCdtrAcct((CashAccountSEPA2)object);
        AccountIdentificationSEPA accountIdentificationSEPA = new AccountIdentificationSEPA();
        ((CashAccountSEPA2)object).setId(accountIdentificationSEPA);
        accountIdentificationSEPA.setIBAN(sEPACreditTransferTransaction.getIBAN());
        RemittanceInformationSEPA1Choice remittanceInformationSEPA1Choice = new RemittanceInformationSEPA1Choice();
        creditTransferTransactionInformationSCT.setRmtInf(remittanceInformationSEPA1Choice);
        remittanceInformationSEPA1Choice.setUstrd(sEPACreditTransferTransaction.getVerwendungszweck());
        return creditTransferTransactionInformationSCT;
    }
}

