/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.pain001_001_02.AccountIdentification2;
import com.codecamp.sepa.pain001_001_02.AmountType3;
import com.codecamp.sepa.pain001_001_02.CashAccount8;
import com.codecamp.sepa.pain001_001_02.ChargeBearerType2Code;
import com.codecamp.sepa.pain001_001_02.CreditTransferTransactionInformation2;
import com.codecamp.sepa.pain001_001_02.Document;
import com.codecamp.sepa.pain001_001_02.EuroMax9Amount;
import com.codecamp.sepa.pain001_001_02.FinancialInstitution2;
import com.codecamp.sepa.pain001_001_02.FinancialInstitutionIdentification4;
import com.codecamp.sepa.pain001_001_02.GenericIdentification3;
import com.codecamp.sepa.pain001_001_02.GenericIdentification4;
import com.codecamp.sepa.pain001_001_02.GroupHeader20;
import com.codecamp.sepa.pain001_001_02.Grouping2Code;
import com.codecamp.sepa.pain001_001_02.OrganisationIdentification2;
import com.codecamp.sepa.pain001_001_02.Pain00100102;
import com.codecamp.sepa.pain001_001_02.Party5Choice;
import com.codecamp.sepa.pain001_001_02.PartyIdentification20;
import com.codecamp.sepa.pain001_001_02.PartyIdentification21;
import com.codecamp.sepa.pain001_001_02.PartyIdentification23;
import com.codecamp.sepa.pain001_001_02.PaymentIdentification1;
import com.codecamp.sepa.pain001_001_02.PaymentInstructionInformation4;
import com.codecamp.sepa.pain001_001_02.PaymentMethod5Code;
import com.codecamp.sepa.pain001_001_02.PaymentTypeInformation7;
import com.codecamp.sepa.pain001_001_02.PersonIdentification3;
import com.codecamp.sepa.pain001_001_02.PostalAddress5;
import com.codecamp.sepa.pain001_001_02.RemittanceInformation3;
import com.codecamp.sepa.pain001_001_02.ServiceLevel3Code;
import com.codecamp.sepa.pain001_001_02.ServiceLevel4;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLCreditTransferBuilder001Old {
    private final Logger logger = Logger.getLogger(SEPAXMLCreditTransferBuilder001Old.class.getName());

    public Document getCreditTransfer(SEPACreditTransfer sEPACreditTransfer) {
        Object object;
        Document document = new Document();
        Pain00100102 pain00100102 = new Pain00100102();
        document.setPain00100102(pain00100102);
        GroupHeader20 groupHeader20 = new GroupHeader20();
        pain00100102.setGrpHdr(groupHeader20);
        groupHeader20.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader20.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPACreditTransfer.getTransactionList().size());
        groupHeader20.setNbOfTxs(string);
        groupHeader20.setGrpg(Grouping2Code.GRPD);
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() || sEPACreditTransfer.isNameInInitParty()) {
            object = new PartyIdentification20();
            groupHeader20.setInitgPty((PartyIdentification20)object);
            if (sEPACreditTransfer.isNameInInitParty()) {
                ((PartyIdentification20)object).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty()) {
                Party5Choice party5Choice;
                Object object2;
                Object object3;
                if (sEPACreditTransfer.isIdentIdOrg()) {
                    object3 = new GenericIdentification3();
                    ((GenericIdentification3)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new OrganisationIdentification2();
                    ((OrganisationIdentification2)object2).setPrtryId((GenericIdentification3)object3);
                    party5Choice = new Party5Choice();
                    party5Choice.setOrgId((OrganisationIdentification2)object2);
                    ((PartyIdentification20)object).setId(party5Choice);
                }
                if (sEPACreditTransfer.isIdentIdPrv()) {
                    object3 = new GenericIdentification4();
                    ((GenericIdentification4)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new PersonIdentification3();
                    ((PersonIdentification3)object2).setOthrId((GenericIdentification4)object3);
                    party5Choice = new Party5Choice();
                    party5Choice.setPrvtId((PersonIdentification3)object2);
                    ((PartyIdentification20)object).setId(party5Choice);
                }
            }
        }
        object = new BigDecimal(0).setScale(2);
        object = sEPACreditTransfer.getUsePIIforEachTrx() || sEPACreditTransfer.isExecutionDateFromFile() || sEPACreditTransfer.isPayerFromFile() ? this.addPIIForEachTrx(sEPACreditTransfer, pain00100102) : this.addSinglePII(sEPACreditTransfer, pain00100102, string);
        groupHeader20.setCtrlSum(((BigDecimal)object).setScale(2));
        sEPACreditTransfer.setSumOfTx(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPACreditTransfer sEPACreditTransfer, Pain00100102 pain00100102) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            Object object;
            Object object2;
            Object object3;
            PaymentInstructionInformation4 paymentInstructionInformation4 = new PaymentInstructionInformation4();
            pain00100102.setPmtInf(paymentInstructionInformation4);
            paymentInstructionInformation4.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation4.setPmtMtd(PaymentMethod5Code.TRF);
            if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                object3 = new PaymentTypeInformation7();
                paymentInstructionInformation4.setPmtTpInf((PaymentTypeInformation7)object3);
                object2 = new ServiceLevel4();
                ((ServiceLevel4)object2).setCd(ServiceLevel3Code.SEPA);
                ((PaymentTypeInformation7)object3).setSvcLvl((ServiceLevel4)object2);
            }
            try {
                object3 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.isExecutionDateFromFile() ? sEPACreditTransferTransaction.getExecutionDate() : sEPACreditTransfer.getExecutionDate());
                paymentInstructionInformation4.setReqdExctnDt((XMLGregorianCalendar)object3);
                ((XMLGregorianCalendar)object3).setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
            }
            object2 = new PartyIdentification23();
            paymentInstructionInformation4.setDbtr((PartyIdentification23)object2);
            if (sEPACreditTransfer.isPayerFromFile()) {
                ((PartyIdentification23)object2).setNm(sEPACreditTransferTransaction.getKontoinhaberPayerTrx());
            } else {
                ((PartyIdentification23)object2).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                object = new PostalAddress5();
                ((PartyIdentification23)object2).setPstlAdr((PostalAddress5)object);
                if (sEPACreditTransfer.getCountryCode() != null) {
                    ((PostalAddress5)object).setCtry(sEPACreditTransfer.getCountryCode());
                }
                if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                    ((PostalAddress5)object).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                }
                if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                    ((PostalAddress5)object).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                }
            }
            object = new CashAccount8();
            paymentInstructionInformation4.setDbtrAcct((CashAccount8)object);
            AccountIdentification2 accountIdentification2 = new AccountIdentification2();
            ((CashAccount8)object).setId(accountIdentification2);
            if (sEPACreditTransfer.isPayerFromFile()) {
                accountIdentification2.setIBAN(sEPACreditTransferTransaction.getIBANPayerTrx());
            } else {
                accountIdentification2.setIBAN(sEPACreditTransfer.getIBAN());
            }
            FinancialInstitution2 financialInstitution2 = new FinancialInstitution2();
            paymentInstructionInformation4.setDbtrAgt(financialInstitution2);
            FinancialInstitutionIdentification4 financialInstitutionIdentification4 = new FinancialInstitutionIdentification4();
            financialInstitution2.setFinInstnId(financialInstitutionIdentification4);
            if (sEPACreditTransfer.isPayerFromFile()) {
                financialInstitutionIdentification4.setBIC(sEPACreditTransferTransaction.getBICPayerTrx());
            } else {
                financialInstitutionIdentification4.setBIC(sEPACreditTransfer.getBIC());
            }
            if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation4.setChrgBr(ChargeBearerType2Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
            }
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation4.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), 1, sEPACreditTransfer.getEnd2EndId()));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPACreditTransfer sEPACreditTransfer, Pain00100102 pain00100102, String string) {
        Object object;
        Object object2;
        Object object3;
        PaymentInstructionInformation4 paymentInstructionInformation4 = new PaymentInstructionInformation4();
        pain00100102.setPmtInf(paymentInstructionInformation4);
        paymentInstructionInformation4.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation4.setPmtMtd(PaymentMethod5Code.TRF);
        sEPACreditTransfer.setPmtInfId(paymentInstructionInformation4.getPmtInfId());
        if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
            object3 = new PaymentTypeInformation7();
            paymentInstructionInformation4.setPmtTpInf((PaymentTypeInformation7)object3);
            object2 = new ServiceLevel4();
            ((ServiceLevel4)object2).setCd(ServiceLevel3Code.SEPA);
            ((PaymentTypeInformation7)object3).setSvcLvl((ServiceLevel4)object2);
        }
        try {
            object3 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.getExecutionDate());
            paymentInstructionInformation4.setReqdExctnDt((XMLGregorianCalendar)object3);
            ((XMLGregorianCalendar)object3).setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
        }
        object2 = new PartyIdentification23();
        paymentInstructionInformation4.setDbtr((PartyIdentification23)object2);
        ((PartyIdentification23)object2).setNm(sEPACreditTransfer.getKontoinhaber());
        if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
            object = new PostalAddress5();
            ((PartyIdentification23)object2).setPstlAdr((PostalAddress5)object);
            if (sEPACreditTransfer.getCountryCode() != null) {
                ((PostalAddress5)object).setCtry(sEPACreditTransfer.getCountryCode());
            }
            if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                ((PostalAddress5)object).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
            }
            if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                ((PostalAddress5)object).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
            }
        }
        object = new CashAccount8();
        paymentInstructionInformation4.setDbtrAcct((CashAccount8)object);
        AccountIdentification2 accountIdentification2 = new AccountIdentification2();
        ((CashAccount8)object).setId(accountIdentification2);
        accountIdentification2.setIBAN(sEPACreditTransfer.getIBAN());
        FinancialInstitution2 financialInstitution2 = new FinancialInstitution2();
        paymentInstructionInformation4.setDbtrAgt(financialInstitution2);
        FinancialInstitutionIdentification4 financialInstitutionIdentification4 = new FinancialInstitutionIdentification4();
        financialInstitution2.setFinInstnId(financialInstitutionIdentification4);
        financialInstitutionIdentification4.setBIC(sEPACreditTransfer.getBIC());
        if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation4.setChrgBr(ChargeBearerType2Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
        }
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation4.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), ++n, sEPACreditTransfer.getEnd2EndId()));
        }
        return bigDecimal;
    }

    private CreditTransferTransactionInformation2 getCreditTransferTransaction(SEPACreditTransferTransaction sEPACreditTransferTransaction, SEPACreditTransfer sEPACreditTransfer, boolean bl, int n, String string) {
        Object object;
        Object object2;
        CreditTransferTransactionInformation2 creditTransferTransactionInformation2 = new CreditTransferTransactionInformation2();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        creditTransferTransactionInformation2.setPmtId(paymentIdentification1);
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (sEPACreditTransfer.isEnd2EndIdFromFile() && StringUtils.trimToNull(sEPACreditTransferTransaction.getEnd2EndId()) != null) {
            paymentIdentification1.setEndToEndId(sEPACreditTransferTransaction.getEnd2EndId());
        } else if (StringUtils.trimToNull(string) != null) {
            paymentIdentification1.setEndToEndId(string);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        sEPACreditTransferTransaction.setEnd2EndId(paymentIdentification1.getEndToEndId());
        paymentIdentification1.setInstrId(String.valueOf(n));
        AmountType3 amountType3 = new AmountType3();
        creditTransferTransactionInformation2.setAmt(amountType3);
        EuroMax9Amount euroMax9Amount = new EuroMax9Amount();
        amountType3.setInstdAmt(euroMax9Amount);
        String string2 = sEPACreditTransfer.getCurrency();
        if (sEPACreditTransferTransaction.getCurrency() != null) {
            string2 = sEPACreditTransferTransaction.getCurrency();
        }
        euroMax9Amount.setValue(sEPACreditTransferTransaction.getAmount());
        euroMax9Amount.setCcy(string2);
        if (sEPACreditTransferTransaction.getBIC() != null && !sEPACreditTransferTransaction.getBIC().isEmpty()) {
            object2 = new FinancialInstitution2();
            creditTransferTransactionInformation2.setCdtrAgt((FinancialInstitution2)object2);
            object = new FinancialInstitutionIdentification4();
            ((FinancialInstitution2)object2).setFinInstnId((FinancialInstitutionIdentification4)object);
            ((FinancialInstitutionIdentification4)object).setBIC(sEPACreditTransferTransaction.getBIC());
        }
        object2 = new PartyIdentification21();
        creditTransferTransactionInformation2.setCdtr((PartyIdentification21)object2);
        ((PartyIdentification21)object2).setNm(sEPACreditTransferTransaction.getKontoinhaber());
        if (sEPACreditTransferTransaction.getCountryCode() != null || sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty() || sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
            object = new PostalAddress5();
            ((PartyIdentification21)object2).setPstlAdr((PostalAddress5)object);
            if (!sEPACreditTransferTransaction.getCountryCode().isEmpty()) {
                ((PostalAddress5)object).setCtry(sEPACreditTransferTransaction.getCountryCode());
            }
            if (sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty()) {
                ((PostalAddress5)object).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine1());
            }
            if (sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
                ((PostalAddress5)object).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine2());
            }
        }
        object = new CashAccount8();
        creditTransferTransactionInformation2.setCdtrAcct((CashAccount8)object);
        AccountIdentification2 accountIdentification2 = new AccountIdentification2();
        ((CashAccount8)object).setId(accountIdentification2);
        accountIdentification2.setIBAN(sEPACreditTransferTransaction.getIBAN());
        RemittanceInformation3 remittanceInformation3 = new RemittanceInformation3();
        creditTransferTransactionInformation2.setRmtInf(remittanceInformation3);
        remittanceInformation3.setUstrd(sEPACreditTransferTransaction.getVerwendungszweck());
        return creditTransferTransactionInformation2;
    }
}

