/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.pain001_001_03_austrian_004.AccountIdentification4Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.pain001_001_03_austrian_004.AmountType3Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.BranchAndFinancialInstitutionIdentification4;
import com.codecamp.sepa.pain001_001_03_austrian_004.CashAccount16;
import com.codecamp.sepa.pain001_001_03_austrian_004.CategoryPurpose1Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.ChargeBearerType1Code;
import com.codecamp.sepa.pain001_001_03_austrian_004.ContactDetails2;
import com.codecamp.sepa.pain001_001_03_austrian_004.CreditTransferTransactionInformation10;
import com.codecamp.sepa.pain001_001_03_austrian_004.CustomerCreditTransferInitiationV03;
import com.codecamp.sepa.pain001_001_03_austrian_004.Document;
import com.codecamp.sepa.pain001_001_03_austrian_004.FinancialInstitutionIdentification7;
import com.codecamp.sepa.pain001_001_03_austrian_004.GenericAccountIdentification1;
import com.codecamp.sepa.pain001_001_03_austrian_004.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain001_001_03_austrian_004.GenericPersonIdentification1;
import com.codecamp.sepa.pain001_001_03_austrian_004.GroupHeader32;
import com.codecamp.sepa.pain001_001_03_austrian_004.LocalInstrument2Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.OrganisationIdentification4;
import com.codecamp.sepa.pain001_001_03_austrian_004.OriginalCategoryPurpose1Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.OriginalLocalInstrument2Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.OriginalPostalAddress6;
import com.codecamp.sepa.pain001_001_03_austrian_004.OriginalRemittanceInformation5;
import com.codecamp.sepa.pain001_001_03_austrian_004.OriginalServiceLevel8Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.Party6Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.PartyIdentification32;
import com.codecamp.sepa.pain001_001_03_austrian_004.PaymentIdentification1;
import com.codecamp.sepa.pain001_001_03_austrian_004.PaymentInstructionInformation3;
import com.codecamp.sepa.pain001_001_03_austrian_004.PaymentMethod3Code;
import com.codecamp.sepa.pain001_001_03_austrian_004.PaymentTypeInformation19;
import com.codecamp.sepa.pain001_001_03_austrian_004.PersonIdentification5;
import com.codecamp.sepa.pain001_001_03_austrian_004.PostalAddress6;
import com.codecamp.sepa.pain001_001_03_austrian_004.Priority2Code;
import com.codecamp.sepa.pain001_001_03_austrian_004.RegulatoryReporting3;
import com.codecamp.sepa.pain001_001_03_austrian_004.RemittanceInformation5;
import com.codecamp.sepa.pain001_001_03_austrian_004.ServiceLevel8Choice;
import com.codecamp.sepa.pain001_001_03_austrian_004.StructuredRegulatoryReporting3;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLCreditTransferBuilder001AT2 {
    private final Logger logger = Logger.getLogger(SEPAXMLCreditTransferBuilder001AT2.class.getName());

    public Document getCreditTransfer(SEPACreditTransfer sEPACreditTransfer) {
        Object object;
        Document document = new Document();
        CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03 = new CustomerCreditTransferInitiationV03();
        document.setCstmrCdtTrfInitn(customerCreditTransferInitiationV03);
        GroupHeader32 groupHeader32 = new GroupHeader32();
        customerCreditTransferInitiationV03.setGrpHdr(groupHeader32);
        groupHeader32.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader32.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPACreditTransfer.getTransactionList().size());
        groupHeader32.setNbOfTxs(string);
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() || sEPACreditTransfer.isNameInInitParty() || sEPACreditTransfer.isAddSoftwareNameAndVendor()) {
            Object object2;
            Object object3;
            object = new PartyIdentification32();
            groupHeader32.setInitgPty((PartyIdentification32)object);
            if (sEPACreditTransfer.isNameInInitParty()) {
                ((PartyIdentification32)object).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.isAddSoftwareNameAndVendor()) {
                object3 = new ContactDetails2();
                ((PartyIdentification32)object).setCtctDtls((ContactDetails2)object3);
                object2 = new SEPAPreferences();
                ((ContactDetails2)object3).setNm(((SEPAPreferences)object2).loadPreference(FieldType.SOFTWARE_NAME_AND_VENDOR.name(), "SEPAApp/Janus Software Solutions"));
            }
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty()) {
                Party6Choice party6Choice;
                if (sEPACreditTransfer.isIdentIdOrg()) {
                    object3 = new GenericOrganisationIdentification1();
                    ((GenericOrganisationIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new OrganisationIdentification4();
                    ((OrganisationIdentification4)object2).getOthr().add((GenericOrganisationIdentification1)object3);
                    party6Choice = new Party6Choice();
                    party6Choice.setOrgId((OrganisationIdentification4)object2);
                    ((PartyIdentification32)object).setId(party6Choice);
                }
                if (sEPACreditTransfer.isIdentIdPrv()) {
                    object3 = new GenericPersonIdentification1();
                    ((GenericPersonIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new PersonIdentification5();
                    ((PersonIdentification5)object2).getOthr().add((GenericPersonIdentification1)object3);
                    party6Choice = new Party6Choice();
                    party6Choice.setPrvtId((PersonIdentification5)object2);
                    ((PartyIdentification32)object).setId(party6Choice);
                }
            }
        }
        object = new BigDecimal(0).setScale(2);
        object = sEPACreditTransfer.getUsePIIforEachTrx() || sEPACreditTransfer.isExecutionDateFromFile() || sEPACreditTransfer.isPayerFromFile() ? this.addPIIForEachTrx(sEPACreditTransfer, customerCreditTransferInitiationV03) : this.addSinglePII(sEPACreditTransfer, customerCreditTransferInitiationV03, string);
        groupHeader32.setCtrlSum(((BigDecimal)object).setScale(2));
        sEPACreditTransfer.setSumOfTx(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            Object object;
            Object object2;
            String[] stringArray;
            Object object3;
            Object object4;
            PaymentInstructionInformation3 paymentInstructionInformation3 = new PaymentInstructionInformation3();
            customerCreditTransferInitiationV03.getPmtInf().add(paymentInstructionInformation3);
            paymentInstructionInformation3.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation3.setPmtMtd(PaymentMethod3Code.TRF);
            if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformation3.setBtchBookg(Boolean.TRUE);
            } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformation3.setBtchBookg(Boolean.FALSE);
            }
            paymentInstructionInformation3.setNbOfTxs("1");
            PaymentTypeInformation19 paymentTypeInformation19 = new PaymentTypeInformation19();
            if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                paymentTypeInformation19.setInstrPrty(Priority2Code.HIGH);
            }
            if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                object4 = new ServiceLevel8Choice();
                ((OriginalServiceLevel8Choice)object4).setCd(sEPACreditTransfer.getServiceLevel().name());
                paymentTypeInformation19.setSvcLvl((ServiceLevel8Choice)object4);
            }
            if (sEPACreditTransfer.isInstantCT()) {
                object4 = new LocalInstrument2Choice();
                ((OriginalLocalInstrument2Choice)object4).setCd("INST");
                paymentTypeInformation19.setLclInstrm((LocalInstrument2Choice)object4);
            }
            if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
                object4 = new LocalInstrument2Choice();
                ((OriginalLocalInstrument2Choice)object4).setCd("CORE");
                paymentTypeInformation19.setLclInstrm((LocalInstrument2Choice)object4);
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                object4 = new CategoryPurpose1Choice();
                ((OriginalCategoryPurpose1Choice)object4).setCd(sEPACreditTransfer.getCategoryPurpose().name());
                paymentTypeInformation19.setCtgyPurp((CategoryPurpose1Choice)object4);
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore()) {
                paymentInstructionInformation3.setPmtTpInf(paymentTypeInformation19);
            }
            try {
                object4 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.isExecutionDateFromFile() ? sEPACreditTransferTransaction.getExecutionDate() : sEPACreditTransfer.getExecutionDate());
                paymentInstructionInformation3.setReqdExctnDt((XMLGregorianCalendar)object4);
                ((XMLGregorianCalendar)object4).setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
            }
            PartyIdentification32 partyIdentification32 = new PartyIdentification32();
            paymentInstructionInformation3.setDbtr(partyIdentification32);
            if (sEPACreditTransfer.isPayerFromFile()) {
                partyIdentification32.setNm(sEPACreditTransferTransaction.getKontoinhaberPayerTrx());
            } else {
                partyIdentification32.setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                object3 = new PostalAddress6();
                partyIdentification32.setPstlAdr((PostalAddress6)object3);
                if (sEPACreditTransfer.getCountryCode() != null) {
                    ((OriginalPostalAddress6)object3).setCtry(sEPACreditTransfer.getCountryCode());
                }
                if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                    if (sEPACreditTransfer.isUseStructuredAddress()) {
                        ((OriginalPostalAddress6)object3).setStrtNm(sEPACreditTransfer.getAddressLine1());
                    } else {
                        ((OriginalPostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                    }
                }
                if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                    if (sEPACreditTransfer.isUseStructuredAddress()) {
                        stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                        ((OriginalPostalAddress6)object3).setPstCd(stringArray[0]);
                        if (stringArray.length > 1) {
                            object2 = "";
                            for (int i = 1; i < stringArray.length; ++i) {
                                object = stringArray[i];
                                object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                            }
                            ((OriginalPostalAddress6)object3).setTwnNm((String)object2);
                        }
                    } else {
                        ((OriginalPostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                    }
                }
            }
            object3 = new CashAccount16();
            paymentInstructionInformation3.setDbtrAcct((CashAccount16)object3);
            if (sEPACreditTransfer.isSetDebitorCurrency()) {
                ((CashAccount16)object3).setCcy(sEPACreditTransfer.getCurrency());
            }
            stringArray = new AccountIdentification4Choice();
            ((CashAccount16)object3).setId((AccountIdentification4Choice)stringArray);
            if (sEPACreditTransfer.isPayerFromFile()) {
                stringArray.setIBAN(sEPACreditTransferTransaction.getIBANPayerTrx());
            } else {
                stringArray.setIBAN(sEPACreditTransfer.getIBAN());
            }
            object2 = new BranchAndFinancialInstitutionIdentification4();
            paymentInstructionInformation3.setDbtrAgt((BranchAndFinancialInstitutionIdentification4)object2);
            FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
            ((BranchAndFinancialInstitutionIdentification4)object2).setFinInstnId(financialInstitutionIdentification7);
            if (sEPACreditTransfer.isPayerFromFile()) {
                financialInstitutionIdentification7.setBIC(sEPACreditTransferTransaction.getBICPayerTrx());
                if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                    object = new PostalAddress6();
                    financialInstitutionIdentification7.setPstlAdr((PostalAddress6)object);
                    ((OriginalPostalAddress6)object).setCtry(sEPACreditTransferTransaction.getIBANPayerTrx().substring(0, 2));
                }
            } else {
                financialInstitutionIdentification7.setBIC(sEPACreditTransfer.getBIC());
                if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                    object = new PostalAddress6();
                    financialInstitutionIdentification7.setPstlAdr((PostalAddress6)object);
                    ((OriginalPostalAddress6)object).setCtry(sEPACreditTransfer.getIBAN().substring(0, 2));
                }
            }
            if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation3.setChrgBr(ChargeBearerType1Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
            }
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation3.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), sEPACreditTransfer.getEnd2EndId(), 1, sEPACreditTransfer.isSetTxNo()));
            paymentInstructionInformation3.setCtrlSum(sEPACreditTransferTransaction.getAmount().setScale(2));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03, String string) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        PaymentInstructionInformation3 paymentInstructionInformation3 = new PaymentInstructionInformation3();
        customerCreditTransferInitiationV03.getPmtInf().add(paymentInstructionInformation3);
        paymentInstructionInformation3.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation3.setPmtMtd(PaymentMethod3Code.TRF);
        sEPACreditTransfer.setPmtInfId(paymentInstructionInformation3.getPmtInfId());
        if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformation3.setBtchBookg(Boolean.TRUE);
        } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformation3.setBtchBookg(Boolean.FALSE);
        }
        paymentInstructionInformation3.setNbOfTxs(string);
        PaymentTypeInformation19 paymentTypeInformation19 = new PaymentTypeInformation19();
        if (sEPACreditTransfer.isUseFastCreditTransfer()) {
            paymentTypeInformation19.setInstrPrty(Priority2Code.HIGH);
        }
        if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
            object4 = new ServiceLevel8Choice();
            ((OriginalServiceLevel8Choice)object4).setCd(sEPACreditTransfer.getServiceLevel().name());
            paymentTypeInformation19.setSvcLvl((ServiceLevel8Choice)object4);
        }
        if (sEPACreditTransfer.isInstantCT()) {
            object4 = new LocalInstrument2Choice();
            ((OriginalLocalInstrument2Choice)object4).setCd("INST");
            paymentTypeInformation19.setLclInstrm((LocalInstrument2Choice)object4);
        }
        if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
            object4 = new LocalInstrument2Choice();
            ((OriginalLocalInstrument2Choice)object4).setCd("CORE");
            paymentTypeInformation19.setLclInstrm((LocalInstrument2Choice)object4);
        }
        if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object4 = new CategoryPurpose1Choice();
            ((OriginalCategoryPurpose1Choice)object4).setCd(sEPACreditTransfer.getCategoryPurpose().name());
            paymentTypeInformation19.setCtgyPurp((CategoryPurpose1Choice)object4);
        }
        if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore()) {
            paymentInstructionInformation3.setPmtTpInf(paymentTypeInformation19);
        }
        try {
            object4 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.getExecutionDate());
            paymentInstructionInformation3.setReqdExctnDt((XMLGregorianCalendar)object4);
            ((XMLGregorianCalendar)object4).setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
        }
        PartyIdentification32 partyIdentification32 = new PartyIdentification32();
        paymentInstructionInformation3.setDbtr(partyIdentification32);
        partyIdentification32.setNm(sEPACreditTransfer.getKontoinhaber());
        if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
            object3 = new PostalAddress6();
            partyIdentification32.setPstlAdr((PostalAddress6)object3);
            if (sEPACreditTransfer.getCountryCode() != null) {
                ((OriginalPostalAddress6)object3).setCtry(sEPACreditTransfer.getCountryCode());
            }
            if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((OriginalPostalAddress6)object3).setStrtNm(sEPACreditTransfer.getAddressLine1());
                } else {
                    ((OriginalPostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                }
            }
            if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                    ((OriginalPostalAddress6)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((OriginalPostalAddress6)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((OriginalPostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                }
            }
        }
        object3 = new CashAccount16();
        paymentInstructionInformation3.setDbtrAcct((CashAccount16)object3);
        if (sEPACreditTransfer.isSetDebitorCurrency()) {
            ((CashAccount16)object3).setCcy(sEPACreditTransfer.getCurrency());
        }
        stringArray = new AccountIdentification4Choice();
        ((CashAccount16)object3).setId((AccountIdentification4Choice)stringArray);
        stringArray.setIBAN(sEPACreditTransfer.getIBAN());
        object2 = new BranchAndFinancialInstitutionIdentification4();
        paymentInstructionInformation3.setDbtrAgt((BranchAndFinancialInstitutionIdentification4)object2);
        FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
        ((BranchAndFinancialInstitutionIdentification4)object2).setFinInstnId(financialInstitutionIdentification7);
        financialInstitutionIdentification7.setBIC(sEPACreditTransfer.getBIC());
        if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
            object = new PostalAddress6();
            financialInstitutionIdentification7.setPstlAdr((PostalAddress6)object);
            ((OriginalPostalAddress6)object).setCtry(sEPACreditTransfer.getIBAN().substring(0, 2));
        }
        if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation3.setChrgBr(ChargeBearerType1Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation3.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), sEPACreditTransfer.getEnd2EndId(), ++n, sEPACreditTransfer.isSetTxNo()));
        }
        paymentInstructionInformation3.setCtrlSum(((BigDecimal)object).setScale(2));
        return object;
    }

    private CreditTransferTransactionInformation10 getCreditTransferTransaction(SEPACreditTransferTransaction sEPACreditTransferTransaction, SEPACreditTransfer sEPACreditTransfer, boolean bl, String string, int n, boolean bl2) {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        CreditTransferTransactionInformation10 creditTransferTransactionInformation10 = new CreditTransferTransactionInformation10();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        creditTransferTransactionInformation10.setPmtId(paymentIdentification1);
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (sEPACreditTransfer.isEnd2EndIdFromFile() && StringUtils.trimToNull(sEPACreditTransferTransaction.getEnd2EndId()) != null) {
            paymentIdentification1.setEndToEndId(sEPACreditTransferTransaction.getEnd2EndId());
        } else if (StringUtils.trimToNull(string) != null) {
            paymentIdentification1.setEndToEndId(string);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        sEPACreditTransferTransaction.setEnd2EndId(paymentIdentification1.getEndToEndId());
        if (bl2) {
            paymentIdentification1.setInstrId(String.valueOf(n));
        }
        AmountType3Choice amountType3Choice = new AmountType3Choice();
        creditTransferTransactionInformation10.setAmt(amountType3Choice);
        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
        amountType3Choice.setInstdAmt(activeOrHistoricCurrencyAndAmount);
        String string2 = sEPACreditTransfer.getCurrency();
        if (sEPACreditTransferTransaction.getCurrency() != null) {
            string2 = sEPACreditTransferTransaction.getCurrency();
        }
        activeOrHistoricCurrencyAndAmount.setValue(sEPACreditTransferTransaction.getAmount());
        activeOrHistoricCurrencyAndAmount.setCcy(string2);
        if (sEPACreditTransferTransaction.getBIC() != null && !sEPACreditTransferTransaction.getBIC().isEmpty()) {
            object3 = new BranchAndFinancialInstitutionIdentification4();
            creditTransferTransactionInformation10.setCdtrAgt((BranchAndFinancialInstitutionIdentification4)object3);
            object2 = new FinancialInstitutionIdentification7();
            ((BranchAndFinancialInstitutionIdentification4)object3).setFinInstnId((FinancialInstitutionIdentification7)object2);
            ((FinancialInstitutionIdentification7)object2).setBIC(sEPACreditTransferTransaction.getBIC());
            if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                stringArray = new PostalAddress6();
                ((FinancialInstitutionIdentification7)object2).setPstlAdr((PostalAddress6)stringArray);
                stringArray.setCtry(sEPACreditTransferTransaction.getIBAN().substring(0, 2));
            }
        }
        object3 = new PartyIdentification32();
        creditTransferTransactionInformation10.setCdtr((PartyIdentification32)object3);
        ((PartyIdentification32)object3).setNm(sEPACreditTransferTransaction.getKontoinhaber());
        if (sEPACreditTransferTransaction.getCountryCode() != null || sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty() || sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
            object2 = new PostalAddress6();
            ((PartyIdentification32)object3).setPstlAdr((PostalAddress6)object2);
            if (!sEPACreditTransferTransaction.getCountryCode().isEmpty()) {
                ((OriginalPostalAddress6)object2).setCtry(sEPACreditTransferTransaction.getCountryCode());
            }
            if (sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((OriginalPostalAddress6)object2).setStrtNm(sEPACreditTransferTransaction.getAddressLine1());
                } else {
                    ((OriginalPostalAddress6)object2).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine1());
                }
            }
            if (sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransferTransaction.getAddressLine2().split(" ");
                    ((OriginalPostalAddress6)object2).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            String string3 = stringArray[i];
                            object = i > 1 ? (String)object + " " + string3 : (String)object + string3;
                        }
                        ((OriginalPostalAddress6)object2).setTwnNm((String)object);
                    }
                } else {
                    ((OriginalPostalAddress6)object2).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine2());
                }
            }
        }
        object2 = new CashAccount16();
        creditTransferTransactionInformation10.setCdtrAcct((CashAccount16)object2);
        stringArray = new AccountIdentification4Choice();
        ((CashAccount16)object2).setId((AccountIdentification4Choice)stringArray);
        if (sEPACreditTransfer.isAccountNoInsteadOfIBAN()) {
            object = new GenericAccountIdentification1();
            ((GenericAccountIdentification1)object).setId(sEPACreditTransferTransaction.getIBAN());
            stringArray.setOthr((GenericAccountIdentification1)object);
        } else {
            stringArray.setIBAN(sEPACreditTransferTransaction.getIBAN());
        }
        if (sEPACreditTransfer.getRegulatoryReportingCode() != null && !sEPACreditTransfer.getRegulatoryReportingCode().isEmpty() && !sEPACreditTransfer.isRegulatoryReportingCodeFromFile() || sEPACreditTransferTransaction.getRegulatoryReportingCode() != null && !sEPACreditTransferTransaction.getRegulatoryReportingCode().isEmpty() && sEPACreditTransfer.isRegulatoryReportingCodeFromFile()) {
            object = new RegulatoryReporting3();
            StructuredRegulatoryReporting3 structuredRegulatoryReporting3 = new StructuredRegulatoryReporting3();
            structuredRegulatoryReporting3.setCd(sEPACreditTransfer.isRegulatoryReportingCodeFromFile() ? sEPACreditTransferTransaction.getRegulatoryReportingCode() : sEPACreditTransfer.getRegulatoryReportingCode());
            ((RegulatoryReporting3)object).getDtls().add(structuredRegulatoryReporting3);
            creditTransferTransactionInformation10.getRgltryRptg().add((RegulatoryReporting3)object);
        }
        object = new RemittanceInformation5();
        creditTransferTransactionInformation10.setRmtInf((RemittanceInformation5)object);
        ((OriginalRemittanceInformation5)object).getUstrd().add(sEPACreditTransferTransaction.getVerwendungszweck());
        return creditTransferTransactionInformation10;
    }
}

