/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPaymentRequest000400;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBISDDReqLogMsg000100;
import com.codecamp.sepa.core.CreditTransferSubformat;
import com.codecamp.sepa.core.DirectDebitSubformat;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001AT;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001AT2;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001CBI;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001CH;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001Namespace;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder001Old;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder002;
import com.codecamp.sepa.core.SEPAXMLCreditTransferBuilder003;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001AT;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001AT2;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001CBI;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001CH;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001CH2;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001CH3;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001Namespace;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder001_01;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder002;
import com.codecamp.sepa.core.SEPAXMLDirectDebitBuilder003;
import com.codecamp.sepa.pain001_002_03.Document;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class SEPAWriter {
    private final Logger logger = Logger.getLogger(SEPAWriter.class.getName());

    public void createSEPADirectDebitXMLFile(SEPADirectDebit sEPADirectDebit, File file) throws JAXBException {
        if (DirectDebitSubformat.PAIN_008_003_02.equals((Object)sEPADirectDebit.getSubformat())) {
            this.logger.log(Level.INFO, "Format: pain008.003.02");
            try {
                SEPAXMLDirectDebitBuilder003 sEPAXMLDirectDebitBuilder003 = new SEPAXMLDirectDebitBuilder003();
                JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_003_02.Document.class);
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                marshaller.marshal((Object)sEPAXMLDirectDebitBuilder003.getDirectDebit(sEPADirectDebit), file);
            }
            catch (JAXBException jAXBException) {
                this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                throw jAXBException;
            }
        }
        if (DirectDebitSubformat.PAIN_008_001_02.equals((Object)sEPADirectDebit.getSubformat())) {
            this.logger.log(Level.INFO, "Format: pain008.001.02");
            try {
                if (sEPADirectDebit.isXmlHeaderWithSchemaLocation()) {
                    SEPAXMLDirectDebitBuilder001Namespace sEPAXMLDirectDebitBuilder001Namespace = new SEPAXMLDirectDebitBuilder001Namespace();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02.namespace.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", Boolean.FALSE);
                    marshaller.setProperty("com.sun.xml.bind.xmlHeaders", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.setProperty("jaxb.schemaLocation", "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02 pain.008.001.02.xsd");
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001Namespace.getDirectDebit(sEPADirectDebit), file);
                }
                SEPAXMLDirectDebitBuilder001 sEPAXMLDirectDebitBuilder001 = new SEPAXMLDirectDebitBuilder001();
                JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02.Document.class);
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001.getDirectDebit(sEPADirectDebit), file);
            }
            catch (JAXBException jAXBException) {
                this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                throw jAXBException;
            }
        } else {
            if (DirectDebitSubformat.CBISDDReqLogMsg.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: CBI SDDReqLogMsg");
                try {
                    SEPAXMLDirectDebitBuilder001CBI sEPAXMLDirectDebitBuilder001CBI = new SEPAXMLDirectDebitBuilder001CBI();
                    JAXBContext jAXBContext = JAXBContext.newInstance(CBISDDReqLogMsg000100.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001CBI.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_001_02_CH_01.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.001.02.ch.01");
                try {
                    SEPAXMLDirectDebitBuilder001CH sEPAXMLDirectDebitBuilder001CH = new SEPAXMLDirectDebitBuilder001CH();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02_ch_01.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001CH.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_001_02_CHSDD_02.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.001.02.chsdd.02");
                try {
                    SEPAXMLDirectDebitBuilder001CH2 sEPAXMLDirectDebitBuilder001CH2 = new SEPAXMLDirectDebitBuilder001CH2();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02_chsdd_02.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001CH2.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_001_02_CH_03.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.001.02.ch.03");
                try {
                    SEPAXMLDirectDebitBuilder001CH3 sEPAXMLDirectDebitBuilder001CH3 = new SEPAXMLDirectDebitBuilder001CH3();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02_ch_03.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001CH3.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_001_02_AUSTRIAN_003.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.001.02.austrian.003");
                try {
                    SEPAXMLDirectDebitBuilder001AT sEPAXMLDirectDebitBuilder001AT = new SEPAXMLDirectDebitBuilder001AT();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02_austrian_003.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001AT.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_001_02_AUSTRIAN_004.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.001.02.austrian.004");
                try {
                    SEPAXMLDirectDebitBuilder001AT2 sEPAXMLDirectDebitBuilder001AT2 = new SEPAXMLDirectDebitBuilder001AT2();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_02_austrian_004.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001AT2.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_002_02.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.002.02");
                try {
                    SEPAXMLDirectDebitBuilder002 sEPAXMLDirectDebitBuilder002 = new SEPAXMLDirectDebitBuilder002();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_002_02.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder002.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (DirectDebitSubformat.PAIN_008_001_01.equals((Object)sEPADirectDebit.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain008.001.01");
                try {
                    SEPAXMLDirectDebitBuilder001_01 sEPAXMLDirectDebitBuilder001_01 = new SEPAXMLDirectDebitBuilder001_01();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain008_001_01.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLDirectDebitBuilder001_01.getDirectDebit(sEPADirectDebit), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
        }
    }

    public void createSEPACreditTransferXMLFile(SEPACreditTransfer sEPACreditTransfer, File file) throws JAXBException {
        if (CreditTransferSubformat.PAIN_001_003_03.equals((Object)sEPACreditTransfer.getSubformat())) {
            this.logger.log(Level.INFO, "Format: pain001.003.03");
            try {
                SEPAXMLCreditTransferBuilder003 sEPAXMLCreditTransferBuilder003 = new SEPAXMLCreditTransferBuilder003();
                JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_003_03.Document.class);
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                marshaller.marshal((Object)sEPAXMLCreditTransferBuilder003.getCreditTransfer(sEPACreditTransfer), file);
            }
            catch (JAXBException jAXBException) {
                this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                throw jAXBException;
            }
        }
        if (CreditTransferSubformat.PAIN_001_001_03.equals((Object)sEPACreditTransfer.getSubformat())) {
            this.logger.log(Level.INFO, "Format: pain001.001.03");
            try {
                if (sEPACreditTransfer.isXmlHeaderWithSchemaLocation()) {
                    SEPAXMLCreditTransferBuilder001Namespace sEPAXMLCreditTransferBuilder001Namespace = new SEPAXMLCreditTransferBuilder001Namespace();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_001_03.namespace.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", Boolean.FALSE);
                    marshaller.setProperty("com.sun.xml.bind.xmlHeaders", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.setProperty("jaxb.schemaLocation", "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02 pain.008.001.02.xsd");
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001Namespace.getCreditTransfer(sEPACreditTransfer), file);
                }
                SEPAXMLCreditTransferBuilder001 sEPAXMLCreditTransferBuilder001 = new SEPAXMLCreditTransferBuilder001();
                JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_001_03.Document.class);
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001.getCreditTransfer(sEPACreditTransfer), file);
            }
            catch (JAXBException jAXBException) {
                this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                throw jAXBException;
            }
        } else {
            if (CreditTransferSubformat.CBIPaymentRequest.equals((Object)sEPACreditTransfer.getSubformat())) {
                this.logger.log(Level.INFO, "Format: CBI PaymentRequest");
                try {
                    SEPAXMLCreditTransferBuilder001CBI sEPAXMLCreditTransferBuilder001CBI = new SEPAXMLCreditTransferBuilder001CBI();
                    JAXBContext jAXBContext = JAXBContext.newInstance(CBIPaymentRequest000400.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001CBI.getCreditTransfer(sEPACreditTransfer), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (CreditTransferSubformat.PAIN_001_001_03_CH_02.equals((Object)sEPACreditTransfer.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain001.001.03.ch.02");
                try {
                    SEPAXMLCreditTransferBuilder001CH sEPAXMLCreditTransferBuilder001CH = new SEPAXMLCreditTransferBuilder001CH();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_001_03_ch_02.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001CH.getCreditTransfer(sEPACreditTransfer), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (CreditTransferSubformat.PAIN_001_001_03_AUSTRIAN_003.equals((Object)sEPACreditTransfer.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain001.001.03.austrian.003");
                try {
                    SEPAXMLCreditTransferBuilder001AT sEPAXMLCreditTransferBuilder001AT = new SEPAXMLCreditTransferBuilder001AT();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_001_03_austrian_003.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001AT.getCreditTransfer(sEPACreditTransfer), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (CreditTransferSubformat.PAIN_001_001_02.equals((Object)sEPACreditTransfer.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain001.001.02");
                try {
                    SEPAXMLCreditTransferBuilder001Old sEPAXMLCreditTransferBuilder001Old = new SEPAXMLCreditTransferBuilder001Old();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_001_02.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001Old.getCreditTransfer(sEPACreditTransfer), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (CreditTransferSubformat.PAIN_001_001_03_AUSTRIAN_004.equals((Object)sEPACreditTransfer.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain001.001.03.austrian.004");
                try {
                    SEPAXMLCreditTransferBuilder001AT2 sEPAXMLCreditTransferBuilder001AT2 = new SEPAXMLCreditTransferBuilder001AT2();
                    JAXBContext jAXBContext = JAXBContext.newInstance(com.codecamp.sepa.pain001_001_03_austrian_004.Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder001AT2.getCreditTransfer(sEPACreditTransfer), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
            if (CreditTransferSubformat.PAIN_001_002_03.equals((Object)sEPACreditTransfer.getSubformat())) {
                this.logger.log(Level.INFO, "Format: pain001.002.03");
                try {
                    SEPAXMLCreditTransferBuilder002 sEPAXMLCreditTransferBuilder002 = new SEPAXMLCreditTransferBuilder002();
                    JAXBContext jAXBContext = JAXBContext.newInstance(Document.class);
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)sEPAXMLCreditTransferBuilder002.getCreditTransfer(sEPACreditTransfer), file);
                }
                catch (JAXBException jAXBException) {
                    this.logger.log(Level.SEVERE, "Exception while saving SEPA XML file!", jAXBException);
                    throw jAXBException;
                }
            }
        }
    }
}

