/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.core.IBANValidator;
import com.codecamp.sepa.core.QRValidator;
import com.codecamp.sepa.core.SEPANormalizer;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.parser.ValidationException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SEPAValidator {
    private static final String SWIFT_REGEX = "([ \\-':?,+()/\\.a-zA-Z0-9])*";
    private static final String SWIFT_Z_REGEX = "([;!\u201c%&*<>{=@#_ \\-':?,+()/\\.a-zA-Z0-9])*";
    private static final String SWIFT_DE_REGEX = "([\u00e4\u00c4\u00f6\u00d6\u00fc\u00dc\u00df&*%$ \\-':?,+()/\\.a-zA-Z0-9])*";
    private static final String SWIFT_CH_REGEX = "([!\"#%&*;<>\u00f7=@_$\u00a3\\[\\]{}\\\\`\u00b4~\u00e0\u00e1\u00e2\u00e4\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f6\u00f9\u00fa\u00fb\u00fc\u00fd\u00df\u00c0\u00c1\u00c2\u00c4\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d2\u00d3\u00d4\u00d6\u00d9\u00da\u00db\u00dc\u00d1 \\-':?,+()/\\.a-zA-Z0-9])*";

    public static void validateGlaeubigerId(String string) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("[a-zA-Z]{2,2}[0-9]{2,2}([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|']){3,3}([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|']){1,28}")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.glaeubigerId.notvalid.user.msg"), string);
        }
    }

    public static void validateAmount(BigDecimal bigDecimal) throws ValidationException {
        if (bigDecimal == null) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.user.msg"), bigDecimal);
        }
        if (bigDecimal.compareTo(new BigDecimal(0)) != 1) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.greaterzero.user.msg"), bigDecimal);
        }
        if (bigDecimal.scale() > 2) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.scale.user.msg"), bigDecimal);
        }
    }

    public static void validateVerwendungszweck(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws ValidationException {
        if (bl4) {
            SEPAValidator.validateQrReferenz(string);
            return;
        }
        if (bl && string != null) {
            string = SEPANormalizer.normalize(string);
        }
        String string2 = bl2 ? SWIFT_DE_REGEX : (bl3 ? SWIFT_CH_REGEX : SWIFT_REGEX);
        if (string == null || string.replace(" ", "").isEmpty() || string.trim().length() > 140 || !string.matches(string2)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.verwendungszweck.user.msg"), string);
        }
        if (bl5) {
            SEPAValidator.validateSplitPaymentInformation(string, string2);
        }
    }

    protected static void validateQrReferenz(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").isEmpty() || string.trim().length() != 27 || !QRValidator.validateReferenz(string.replace(" ", ""))) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.qrReferenz.user.msg"), string);
        }
    }

    public static void validateBICPayerFromFile(String string) throws ValidationException {
        SEPAValidator.validateBICInternal(string, "validation.bic.payerfromfile.notvalid.user.msg");
    }

    public static void validateBIC(String string) throws ValidationException {
        SEPAValidator.validateBICInternal(string, "validation.bic.notvalid.user.msg");
    }

    private static void validateBICInternal(String string, String string2) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("([a-zA-Z]{6,6}[a-zA-Z2-9][a-nA-Np-zP-Z0-9]([a-zA-Z0-9]{3,3}){0,1})")) {
            throw new ValidationException(ApplicationContext.get().text().getString(string2), string);
        }
    }

    public static void validateClrSysIdAndMmbId(String string) throws ValidationException {
        if (string == null || !string.contains(" ")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.clrSysIdAndMmbId.notvalid.user.msg"), string);
        }
    }

    public static void validateIBANPayerFromFile(String string) throws ValidationException {
        SEPAValidator.validateIBANInternal(string, false, "validation.iban.payerfromfile.notvalid.user.msg");
    }

    public static void validateIBAN(String string, boolean bl) throws ValidationException {
        SEPAValidator.validateIBANInternal(string, bl, "validation.iban.notvalid.user.msg");
    }

    public static void validateIBANInternal(String string, boolean bl, String string2) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{11}([a-zA-Z0-9]?){0,19}") || !IBANValidator.validate(string.replace(" ", ""))) {
            throw new ValidationException(ApplicationContext.get().text().getString(string2), string);
        }
        if (bl && !QRValidator.validateIBAN(string)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.qriban.notvalid.user.msg"), string);
        }
    }

    public static void validateAddressLine(String string, boolean bl, boolean bl2, boolean bl3) throws ValidationException {
        if (StringUtils.trimToNull(string) != null) {
            if (bl && string != null) {
                string = SEPANormalizer.normalize(string);
            }
            String string2 = bl2 ? SWIFT_DE_REGEX : (bl3 ? SWIFT_CH_REGEX : SWIFT_REGEX);
            if (string == null || string.replace(" ", "").isEmpty() || string.length() > 70 || !string.matches(string2)) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.address.notvalid.user.msg"), string);
            }
        }
    }

    public static void validateKontoinhaberPayerFromFile(String string, boolean bl, boolean bl2, boolean bl3) throws ValidationException {
        SEPAValidator.validateKontoinhaberInternal(string, bl, bl2, bl3, "validation.kontoinhaber.payerfromfile.notvalid.user.msg");
    }

    public static void validateKontoinhaber(String string, boolean bl, boolean bl2, boolean bl3) throws ValidationException {
        SEPAValidator.validateKontoinhaberInternal(string, bl, bl2, bl3, "validation.kontoinhaber.notvalid.user.msg");
    }

    public static void validateKontoinhaberInternal(String string, boolean bl, boolean bl2, boolean bl3, String string2) throws ValidationException {
        if (bl && string != null) {
            string = SEPANormalizer.normalize(string);
        }
        String string3 = bl2 ? SWIFT_DE_REGEX : (bl3 ? SWIFT_CH_REGEX : SWIFT_REGEX);
        if (string == null || string.replace(" ", "").isEmpty() || string.length() > 70 || !string.matches(string3)) {
            throw new ValidationException(ApplicationContext.get().text().getString(string2), string);
        }
    }

    public static void validateIdIfNotEmpty(String string) throws ValidationException {
        if (StringUtils.trimToNull(string) != null && !string.replace(" ", "").matches("([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|'| ]){1,35}")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.idText.notvalid.user.msg"), string);
        }
    }

    public static void validateIdText(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").isEmpty() || !string.replace(" ", "").matches("([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|'| ]){1,35}")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.idText.notvalid.user.msg"), string);
        }
    }

    public static void validateCurrency(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").length() != 3 || !SEPAValidator.isValidCurrency(string)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.currency.notvalid.user.msg"), string);
        }
    }

    protected static boolean isValidCurrency(String string) {
        Set<Currency> set = Currency.getAvailableCurrencies();
        try {
            return set.contains(Currency.getInstance(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void validateCountryCode(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").length() != 2 || !SEPAValidator.isValidCountryCode(string)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.countryCode.notvalid.user.msg"), string);
        }
    }

    protected static boolean isValidCountryCode(String string) {
        String[] stringArray;
        for (String string2 : stringArray = Locale.getISOCountries()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void validateText(String string, boolean bl, boolean bl2) throws ValidationException {
        String string2 = bl ? SWIFT_DE_REGEX : (bl2 ? SWIFT_CH_REGEX : SWIFT_REGEX);
        if (string == null || string.replace(" ", "").isEmpty() || string.trim().length() > 140 || !string.matches(string2)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.text.user.msg"), string);
        }
    }

    public static void validateExecutionsDate(GregorianCalendar gregorianCalendar) throws ValidationException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        calendar.set(11, 0);
        Date date2 = calendar.getTime();
        if (gregorianCalendar == null || gregorianCalendar.getTime() == null || !gregorianCalendar.getTime().after(date2) && !gregorianCalendar.getTime().equals(date2)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.datum.expired.user.msg"), gregorianCalendar);
        }
    }

    public static void validateAdditionalInformation(String string, boolean bl, boolean bl2, boolean bl3) throws ValidationException {
        if (bl && string != null) {
            string = SEPANormalizer.normalize(string);
        }
        String string2 = bl2 ? SWIFT_DE_REGEX : (bl3 ? SWIFT_CH_REGEX : SWIFT_REGEX);
        if (!(string == null || string.trim().length() <= 140 && string.matches(string2))) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.zusaetzlicheInformation.user.msg"), string);
        }
    }

    public static void validateSplitPaymentInformation(String string, String string2) throws ValidationException {
        String string3 = "\\/VAT\\/\\d+(.\\d{1,2})?\\/IDC\\/[a-zA-Z0-9]+\\/INV\\/.+\\/TXT\\/" + string2;
        if (!string.matches(string3)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.splitPaymentInformation.user.msg"), string);
        }
    }
}

