/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.net.URI;
import java.security.InvalidParameterException;
import java.util.Iterator;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.text.TextHyperlink;
import org.odftoolkit.simple.text.TextHyperlinkContainer;
import org.w3c.dom.Node;

class AbstractTextHyperlinkContainer
implements TextHyperlinkContainer {
    OdfElement linkContainer;

    public AbstractTextHyperlinkContainer(OdfElement parent) {
        if (!(parent instanceof TextPElement || parent instanceof TextHElement || parent instanceof TextSpanElement)) {
            throw new InvalidParameterException(parent.getClass() + "is not a valid element.");
        }
        this.linkContainer = parent;
    }

    public TextHyperlink applyHyperlink(URI linkto) {
        OdfElement parent = this.linkContainer;
        this.removeHyperlinks();
        TextAElement aElement = ((OdfContentDom)parent.getOwnerDocument()).newOdfElement(TextAElement.class);
        aElement.setXlinkTypeAttribute("simple");
        aElement.setXlinkHrefAttribute(linkto.toString());
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node thisNode = node;
            parent.removeChild(thisNode);
            aElement.appendChild(thisNode);
        }
        parent.appendChild(aElement);
        return TextHyperlink.getInstanceof(aElement);
    }

    public void removeHyperlinks() {
        OdfElement parent = this.linkContainer;
        TextAElement aElement = OdfElement.findFirstChildNode(TextAElement.class, parent);
        while (aElement != null) {
            for (Node node = aElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node thisNode = node;
                aElement.removeChild(thisNode);
                parent.insertBefore(thisNode, aElement);
            }
            TextAElement thisElement = aElement;
            aElement = OdfElement.findNextChildNode(TextAElement.class, aElement);
            parent.removeChild(thisElement);
        }
    }

    public SimpleHyperlinkIterator getHyperlinkIterator() {
        return new SimpleHyperlinkIterator(this.linkContainer);
    }

    public TextHyperlink appendHyperlink(String text, URI linkto) {
        OdfElement parent = this.linkContainer;
        TextAElement aElement = ((OdfContentDom)parent.getOwnerDocument()).newOdfElement(TextAElement.class);
        aElement.setXlinkTypeAttribute("simple");
        aElement.setXlinkHrefAttribute(linkto.toString());
        aElement.setTextContent(text);
        parent.appendChild(aElement);
        return TextHyperlink.getInstanceof(aElement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleHyperlinkIterator
    implements Iterator<TextHyperlink> {
        private OdfElement containerElement;
        private TextHyperlink nextElement = null;
        private TextHyperlink tempElement = null;

        private SimpleHyperlinkIterator(OdfElement container2) {
            this.containerElement = container2;
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public TextHyperlink next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild(this.nextElement.getOdfElement());
        }

        private TextHyperlink findNext(TextHyperlink thisLink) {
            TextAElement nextLink = null;
            nextLink = thisLink == null ? OdfElement.findFirstChildNode(TextAElement.class, this.containerElement) : OdfElement.findNextChildNode(TextAElement.class, thisLink.getOdfElement());
            if (nextLink != null) {
                return TextHyperlink.getInstanceof(nextLink);
            }
            return null;
        }
    }
}

