/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.dom.element.office.OfficeChartElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.simple.Document;

public class ChartDocument
extends Document {
    private static final String EMPTY_CHART_DOCUMENT_PATH = "/OdfChartDocument.odc";
    static final OdfPackageDocument.Resource EMPTY_CHART_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfChartDocument.odc");

    public static ChartDocument newChartDocument() throws Exception {
        return (ChartDocument)Document.loadTemplate(EMPTY_CHART_DOCUMENT_RESOURCE, Document.OdfMediaType.CHART);
    }

    public static ChartDocument newChartTemplateDocument() throws Exception {
        ChartDocument doc = (ChartDocument)Document.loadTemplate(EMPTY_CHART_DOCUMENT_RESOURCE, Document.OdfMediaType.CHART_TEMPLATE);
        doc.changeMode(OdfMediaType.CHART_TEMPLATE);
        return doc;
    }

    public static ChartDocument loadDocument(InputStream inputStream) throws Exception {
        return (ChartDocument)Document.loadDocument(inputStream);
    }

    public static ChartDocument loadDocument(String documentPath) throws Exception {
        return (ChartDocument)Document.loadDocument(documentPath);
    }

    public static ChartDocument loadDocument(File file) throws Exception {
        return (ChartDocument)Document.loadDocument(file);
    }

    protected ChartDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public OfficeChartElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeChartElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public OdfElement getTableContainerElement() {
        throw new UnsupportedOperationException("Chart document is not supported to hold table now.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        CHART(Document.OdfMediaType.CHART),
        CHART_TEMPLATE(Document.OdfMediaType.CHART_TEMPLATE);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

