/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.table.CellCoverInfo;
import org.odftoolkit.odfdom.doc.table.DomNodeList;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableRowProperties;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.PositiveLength;
import org.w3c.dom.Node;

public class OdfTableRow {
    TableTableRowElement maRowElement;
    int mnRepeatedIndex;
    int mRowsRepeatedNumber = -1;
    private static final String DEFAULT_HEIGHT = "0.30in";
    private OdfDocument mDocument;

    OdfTableRow(TableTableRowElement rowElement, int repeatedIndex) {
        this.maRowElement = rowElement;
        this.mnRepeatedIndex = repeatedIndex;
        this.mDocument = (OdfDocument)((OdfFileDom)this.maRowElement.getOwnerDocument()).getDocument();
    }

    public static OdfTableRow getInstance(TableTableRowElement rowElement) {
        TableTableElement tableElement = null;
        for (Node node = rowElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            tableElement = (TableTableElement)node;
        }
        OdfTable table = null;
        if (tableElement == null) {
            throw new IllegalArgumentException("the rowElement is not in the table dom tree");
        }
        table = OdfTable.getInstance(tableElement);
        OdfTableRow row = table.getRowInstance(rowElement, 0);
        if (row.getRowsRepeatedNumber() > 1) {
            Logger.getLogger(OdfTableRow.class.getName()).log(Level.WARNING, "the row has the repeated row number, and puzzled about get which repeated index of the row,here just return the first row of the repeated rows.");
        }
        return row;
    }

    private TableTableElement getTableElement() {
        for (Node node = this.maRowElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            return (TableTableElement)node;
        }
        return null;
    }

    public OdfTable getTable() {
        TableTableElement tableElement = this.getTableElement();
        if (tableElement != null) {
            return OdfTable.getInstance(tableElement);
        }
        return null;
    }

    public long getHeight() {
        String sHeight = this.maRowElement.getProperty(OdfTableRowProperties.RowHeight);
        if (sHeight == null) {
            sHeight = this.maRowElement.getProperty(OdfTableRowProperties.MinRowHeight);
        }
        if (sHeight == null) {
            sHeight = DEFAULT_HEIGHT;
        }
        return PositiveLength.parseLong(sHeight, Length.Unit.MILLIMETER);
    }

    public void setHeight(long height, boolean isMinHeight) {
        String sHeightMM = String.valueOf(height) + Length.Unit.MILLIMETER.abbr();
        String sHeightIN = PositiveLength.mapToUnit(sHeightMM, Length.Unit.INCH);
        this.splitRepeatedRows();
        this.maRowElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
        this.maRowElement.setProperty(OdfTableRowProperties.RowHeight, sHeightIN);
    }

    void splitRepeatedRows() {
        int repeateNum = this.getRowsRepeatedNumber();
        if (repeateNum > 1) {
            OdfTable table = this.getTable();
            TableTableElement tableEle = table.getOdfElement();
            TableTableRowElement ownerRowElement = null;
            int repeatedRowIndex = this.mnRepeatedIndex;
            TableTableRowElement refElement = this.maRowElement;
            TableTableRowElement oldRowElement = this.maRowElement;
            for (int i = repeateNum - 1; i >= 0; --i) {
                TableTableRowElement newRow = (TableTableRowElement)this.maRowElement.cloneNode(true);
                newRow.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated");
                tableEle.insertBefore(newRow, refElement);
                refElement = newRow;
                if (repeatedRowIndex == i) {
                    ownerRowElement = newRow;
                    continue;
                }
                table.updateRowRepository(this.maRowElement, i, newRow, 0);
            }
            if (ownerRowElement != null) {
                table.updateRowRepository(this.maRowElement, this.mnRepeatedIndex, ownerRowElement, 0);
            }
            tableEle.removeChild(oldRowElement);
            this.mRowsRepeatedNumber = -1;
        }
    }

    public boolean isOptimalHeight() {
        return Boolean.parseBoolean(this.maRowElement.getProperty(OdfTableRowProperties.UseOptimalRowHeight));
    }

    public void setUseOptimalHeight(boolean isUseOptimalHeight) {
        this.maRowElement.setProperty(OdfTableRowProperties.UseOptimalRowHeight, String.valueOf(isUseOptimalHeight));
    }

    public TableTableRowElement getOdfElement() {
        return this.maRowElement;
    }

    public OdfTableCell getCellByIndex(int index) {
        OdfTable table = this.getTable();
        if (index < 0) {
            throw new IllegalArgumentException("index should be nonnegative integer.");
        }
        int lastColumnIndex = table.getColumnCount() - 1;
        if (index > lastColumnIndex) {
            table.appendColumns(index - lastColumnIndex, true);
        }
        for (Node n : new DomNodeList(this.maRowElement.getChildNodes())) {
            if (!(n instanceof TableTableCellElementBase)) continue;
            if (index == 0) {
                return table.getCellInstance((TableTableCellElementBase)n, 0, this.mnRepeatedIndex);
            }
            int nextIndex = index - ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute();
            if (nextIndex < 0) {
                OdfTableCell cell = table.getCellInstance((TableTableCellElementBase)n, index, this.mnRepeatedIndex);
                return cell;
            }
            index = nextIndex;
        }
        return null;
    }

    public int getCellCount() {
        OdfTable table = this.getTable();
        HashSet<OdfTableCell> realCells = new HashSet<OdfTableCell>();
        List<CellCoverInfo> coverList = table.getCellCoverInfos(0, 0, table.getColumnCount() - 1, table.getRowCount() - 1);
        int rowIndex = this.getRowIndex();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            OdfTableCell cell = table.getOwnerCellByPosition(coverList, i, rowIndex);
            realCells.add(cell);
        }
        return realCells.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdfTableRow getPreviousRow() {
        OdfTable table = this.getTable();
        if (this.getRowsRepeatedNumber() > 1 && this.mnRepeatedIndex > 0) {
            return table.getRowInstance(this.maRowElement, this.mnRepeatedIndex - 1);
        }
        Node aPrevNode = this.maRowElement.getPreviousSibling();
        Node aCurNode = this.maRowElement;
        while (true) {
            if (aPrevNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aPrevNode = parentNode.getPreviousSibling();
            }
            if (aPrevNode == null) continue;
            try {
                if (aPrevNode instanceof TableTableRowElement) {
                    return table.getRowInstance((TableTableRowElement)aPrevNode, ((TableTableRowElement)aPrevNode).getTableNumberRowsRepeatedAttribute() - 1);
                }
                if (aPrevNode instanceof TableTableRowsElement || aPrevNode instanceof TableTableHeaderRowsElement || aPrevNode instanceof TableTableRowGroupElement) {
                    TableTableRowElement lastRow;
                    XPath xpath = ((OdfContentDom)aPrevNode.getOwnerDocument()).getXPath();
                    OdfDocument odfDocument = this.mDocument;
                    synchronized (odfDocument) {
                        lastRow = (TableTableRowElement)xpath.evaluate(".//table:table-row[last()]", aPrevNode, XPathConstants.NODE);
                    }
                    if (lastRow == null) continue;
                    return table.getRowInstance(lastRow, lastRow.getTableNumberRowsRepeatedAttribute() - 1);
                }
                aCurNode = aPrevNode;
                aPrevNode = aPrevNode.getPreviousSibling();
                continue;
            }
            catch (XPathExpressionException e2) {
                Logger.getLogger(OdfTableRow.class.getName()).log(Level.SEVERE, e2.getMessage(), e2);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdfTableRow getNextRow() {
        OdfTable table = this.getTable();
        if (this.getRowsRepeatedNumber() > 1 && this.mnRepeatedIndex < this.getRowsRepeatedNumber() - 1) {
            return table.getRowInstance(this.maRowElement, this.mnRepeatedIndex + 1);
        }
        Node aNextNode = this.maRowElement.getNextSibling();
        Node aCurNode = this.maRowElement;
        while (true) {
            if (aNextNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aNextNode = parentNode.getNextSibling();
            }
            if (aNextNode == null) continue;
            try {
                if (aNextNode instanceof TableTableRowElement) {
                    return table.getRowInstance((TableTableRowElement)aNextNode, 0);
                }
                if (aNextNode instanceof TableTableRowsElement || aNextNode instanceof TableTableHeaderRowsElement || aNextNode instanceof TableTableRowGroupElement) {
                    TableTableRowElement firstRow;
                    XPath xpath = ((OdfContentDom)aNextNode.getOwnerDocument()).getXPath();
                    OdfDocument odfDocument = this.mDocument;
                    synchronized (odfDocument) {
                        firstRow = (TableTableRowElement)xpath.evaluate(".//table:table-row[first()]", aNextNode, XPathConstants.NODE);
                    }
                    if (firstRow == null) continue;
                    return table.getRowInstance(firstRow, 0);
                }
                aCurNode = aNextNode;
                aNextNode = aNextNode.getNextSibling();
                continue;
            }
            catch (XPathExpressionException e2) {
                Logger.getLogger(OdfTableRow.class.getName()).log(Level.SEVERE, e2.getMessage(), e2);
                continue;
            }
            break;
        }
    }

    public void setDefaultCellStyle(OdfStyle style) {
        this.splitRepeatedRows();
        OdfStyle defaultStyle = this.getDefaultCellStyle();
        if (defaultStyle != null) {
            defaultStyle.removeStyleUser(this.maRowElement);
        }
        if (style != null) {
            style.addStyleUser(this.maRowElement);
            this.maRowElement.setTableDefaultCellStyleNameAttribute(style.getStyleNameAttribute());
        }
    }

    public OdfStyle getDefaultCellStyle() {
        String styleName = this.maRowElement.getTableDefaultCellStyleNameAttribute();
        OdfStyle style = this.maRowElement.getAutomaticStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        if (style == null) {
            style = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        return style;
    }

    public int getRowIndex() {
        int result = 0;
        TableTableElement mTableElement = this.getTableElement();
        TableTableRowElement rowEle = null;
        for (Node n : new DomNodeList(mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableRowElement)) continue;
                    rowEle = (TableTableRowElement)m;
                    if (rowEle == this.getOdfElement()) {
                        return result + this.mnRepeatedIndex;
                    }
                    result += rowEle.getTableNumberRowsRepeatedAttribute().intValue();
                }
            }
            if (!(n instanceof TableTableRowElement)) continue;
            rowEle = (TableTableRowElement)n;
            if (rowEle == this.getOdfElement()) break;
            result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
        }
        return result + this.mnRepeatedIndex;
    }

    void insertCellByIndex(int index, int count) {
        this.splitRepeatedRows();
        OdfTable table = this.getTable();
        List<CellCoverInfo> coverList = table.getCellCoverInfos(0, 0, table.getColumnCount() - 1, table.getRowCount() - 1);
        int rowIndex = this.getRowIndex();
        OdfTableCell preCell = index == 0 ? table.getOwnerCellByPosition(coverList, 0, rowIndex) : table.getOwnerCellByPosition(coverList, index - 1, rowIndex);
        OdfTableCell nextCell = this.getCellByIndex(index);
        if (nextCell == null) {
            nextCell = this.getCellByIndex(this.getCellCount() - 1);
        }
        for (int i = index + count; i > index; --i) {
            TableTableCellElement newCell = (TableTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.maRowElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
            newCell.setTableStyleNameAttribute(preCell.getStyleName());
            this.maRowElement.insertBefore(newCell, nextCell.getOdfElement());
        }
    }

    void setRowsRepeatedNumber(int num) {
        this.mRowsRepeatedNumber = num;
        this.maRowElement.setTableNumberRowsRepeatedAttribute(num);
    }

    int getRowsRepeatedNumber() {
        if (this.mRowsRepeatedNumber < 0) {
            Integer count = this.maRowElement.getTableNumberRowsRepeatedAttribute();
            this.mRowsRepeatedNumber = count == null ? 1 : count;
        }
        return this.mRowsRepeatedNumber;
    }

    private void insertCellElementBefore(OdfElement parentEle, TableTableCellElementBase positionEle, TableTableCellElementBase cellEle, int count) {
        if (positionEle == null) {
            parentEle.appendChild(cellEle);
            for (int i = 1; i < count; ++i) {
                parentEle.appendChild(cellEle.cloneNode(true));
            }
        } else {
            parentEle.insertBefore(cellEle, positionEle);
            for (int i = 1; i < count; ++i) {
                parentEle.insertBefore(cellEle.cloneNode(true), positionEle);
            }
        }
    }

    void insertCellBefore(OdfTableCell refCell, OdfTableCell positionCell, int count) {
        this.splitRepeatedRows();
        OdfTable ownerTable = this.getTable();
        if (positionCell == null) {
            if (refCell.isCoveredElement()) {
                TableTableCellElement coverCellEle = (TableTableCellElement)refCell.getCoverCell().getOdfElement();
                TableTableCellElement newCellEle = (TableTableCellElement)coverCellEle.cloneNode(true);
                this.cleanCell(newCellEle);
                this.insertCellElementBefore(this.getOdfElement(), null, newCellEle, count);
            } else {
                TableTableCellElement endCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(endCellEle);
                this.getOdfElement().appendChild(endCellEle);
                this.reviseStyleFromLastColumnToMedium(refCell);
                if (count > 1) {
                    TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                    this.cleanCell(newCellEle);
                    this.insertCellElementBefore(this.getOdfElement(), endCellEle, newCellEle, count - 1);
                }
            }
        } else {
            TableTableCellElement coverRefCellEle = null;
            TableTableCellElement coverPosCellEle = null;
            OdfTableCell coverRefCell = null;
            if (refCell.isCoveredElement()) {
                coverRefCell = refCell.getCoverCell();
                coverRefCellEle = (TableTableCellElement)coverRefCell.getOdfElement();
            }
            if (positionCell.isCoveredElement()) {
                coverPosCellEle = (TableTableCellElement)positionCell.getCoverCell().getOdfElement();
            }
            if (coverRefCellEle != null && coverRefCellEle == coverPosCellEle || coverPosCellEle != null && refCell.getOdfElement() == coverPosCellEle) {
                if (coverRefCellEle == null) {
                    coverRefCellEle = (TableTableCellElement)refCell.getOdfElement();
                    coverRefCell = refCell;
                }
                TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)ownerTable.getOdfElement().getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                this.insertCellElementBefore(this.getOdfElement(), positionCell.getOdfElement(), newCellEle, count);
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    coverRefCell.setColumnSpannedNumber(coverRefCell.getColumnSpannedNumber() + count);
                }
            } else if (coverRefCellEle != null) {
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    TableTableCellElement newCellEle = (TableTableCellElement)coverRefCellEle.cloneNode(true);
                    this.cleanCell(newCellEle);
                    this.insertCellElementBefore(this.getOdfElement(), positionCell.getOdfElement(), newCellEle, count);
                } else {
                    TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)refCell.getOdfElement().cloneNode(true);
                    newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                    this.insertCellElementBefore(this.getOdfElement(), positionCell.getOdfElement(), newCellEle, count);
                }
            } else if (refCell.getOdfElement() == positionCell.getOdfElement() && refCell.getColumnsRepeatedNumber() > 1) {
                int repeatNum = refCell.getColumnsRepeatedNumber();
                for (int i = repeatNum - 1; i > refCell.mnRepeatedColIndex; --i) {
                    ownerTable.updateCellRepository(refCell.getOdfElement(), i, refCell.mnRepeatedRowIndex, refCell.getOdfElement(), i + count, refCell.mnRepeatedRowIndex);
                }
                refCell.getOdfElement().setTableNumberColumnsRepeatedAttribute(repeatNum + count);
            } else {
                TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(newCellEle);
                this.insertCellElementBefore(this.getOdfElement(), positionCell.getOdfElement(), newCellEle, count);
            }
        }
    }

    OdfTableCell insertCellBefore(OdfTableCell refCell, OdfTableCell positionCell) {
        this.splitRepeatedRows();
        OdfTableCell newCell = null;
        OdfTable ownerTable = this.getTable();
        if (positionCell == null) {
            if (refCell.isCoveredElement()) {
                TableTableCellElement coverCellEle = (TableTableCellElement)refCell.getCoverCell().getOdfElement();
                TableTableCellElement newCellEle = (TableTableCellElement)coverCellEle.cloneNode(true);
                this.cleanCell(newCellEle);
                this.getOdfElement().appendChild(newCellEle);
                newCell = ownerTable.getCellInstance(newCellEle, 0, 0);
            } else {
                TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(newCellEle);
                this.getOdfElement().appendChild(newCellEle);
                newCell = ownerTable.getCellInstance(newCellEle, 0, 0);
                this.reviseStyleFromLastColumnToMedium(refCell);
            }
        } else {
            TableTableCellElement coverRefCellEle = null;
            TableTableCellElement coverPosCellEle = null;
            OdfTableCell coverRefCell = null;
            if (refCell.isCoveredElement()) {
                coverRefCell = refCell.getCoverCell();
                coverRefCellEle = (TableTableCellElement)coverRefCell.getOdfElement();
            }
            if (positionCell.isCoveredElement()) {
                coverPosCellEle = (TableTableCellElement)positionCell.getCoverCell().getOdfElement();
            }
            if (coverRefCellEle != null && coverRefCellEle == coverPosCellEle || coverPosCellEle != null && refCell.getOdfElement() == coverPosCellEle) {
                if (coverRefCellEle == null) {
                    coverRefCellEle = (TableTableCellElement)refCell.getOdfElement();
                    coverRefCell = refCell;
                }
                TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)ownerTable.getOdfElement().getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                this.getOdfElement().insertBefore(newCellEle, positionCell.getOdfElement());
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    coverRefCell.setColumnSpannedNumber(coverRefCell.getColumnSpannedNumber() + 1);
                }
                newCell = ownerTable.getCellInstance(newCellEle, 0, 0);
            } else if (coverRefCellEle != null) {
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    TableTableCellElement newCellEle = (TableTableCellElement)coverRefCellEle.cloneNode(true);
                    this.cleanCell(newCellEle);
                    this.getOdfElement().insertBefore(newCellEle, positionCell.getOdfElement());
                    newCell = ownerTable.getCellInstance(newCellEle, 0, 0);
                } else {
                    TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)refCell.getOdfElement().cloneNode(true);
                    newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                    this.getOdfElement().insertBefore(newCellEle, positionCell.getOdfElement());
                    newCell = ownerTable.getCellInstance(newCellEle, 0, 0);
                }
            } else if (refCell.getOdfElement() == positionCell.getOdfElement() && refCell.getColumnsRepeatedNumber() > 1) {
                int repeatNum = refCell.getColumnsRepeatedNumber();
                for (int i = repeatNum - 1; i > refCell.mnRepeatedColIndex; --i) {
                    ownerTable.updateCellRepository(refCell.getOdfElement(), i, refCell.mnRepeatedRowIndex, refCell.getOdfElement(), i + 1, refCell.mnRepeatedRowIndex);
                }
                refCell.getOdfElement().setTableNumberColumnsRepeatedAttribute(repeatNum + 1);
                newCell = ownerTable.getCellInstance(refCell.getOdfElement(), refCell.mnRepeatedColIndex + 1, refCell.mnRepeatedRowIndex);
            } else {
                TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(newCellEle);
                this.getOdfElement().insertBefore(newCellEle, positionCell.getOdfElement());
                newCell = ownerTable.getCellInstance(newCellEle, 0, 0);
            }
        }
        return newCell;
    }

    private void cleanCell(TableTableCellElement newCellEle) {
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "date-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "time-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "boolean-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "string-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "formula");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
        if (!this.getTable().isCellStyleInheritance()) {
            newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
        }
        Node n = newCellEle.getFirstChild();
        while (n != null) {
            Node m = n.getNextSibling();
            if (n instanceof TextPElement || n instanceof TextHElement || n instanceof TextListElement) {
                newCellEle.removeChild(n);
            }
            n = m;
        }
    }

    private void reviseStyleFromLastColumnToMedium(OdfTableCell oldLastCell) {
        if (this.getTable().mIsSpreadsheet) {
            return;
        }
        OdfStyle styleEle = oldLastCell.getCellStyleElementForWrite();
        if (styleEle != null) {
            if (oldLastCell.getRowIndex() == 0) {
                OdfTable.setLeftTopBorderStyleProperties(styleEle);
            } else {
                OdfTable.setLeftBottomBorderStylesProperties(styleEle);
            }
        }
    }

    private void reviseStyleFromMediumColumnToLast(OdfTableCell newLastCell) {
        if (this.getTable().mIsSpreadsheet) {
            return;
        }
        OdfStyle styleEle = newLastCell.getCellStyleElementForWrite();
        if (styleEle != null) {
            if (newLastCell.getRowIndex() == 0) {
                OdfTable.setRightTopBorderStyleProperties(styleEle);
            } else {
                OdfTable.setRightBottomBorderStylesProperties(styleEle);
            }
        }
    }

    void removeCellByIndex(int nStart, int nCount) {
        OdfTableCell cell;
        this.splitRepeatedRows();
        OdfTableCell startCell = this.getCellByIndex(nStart);
        OdfTableCell coverCell = null;
        if (startCell.isCoveredElement()) {
            coverCell = startCell.getCoverCellInSameRow();
        }
        int index = nStart;
        for (int i = 0; i < nCount; ++i) {
            cell = this.getCellByIndex(index);
            cell.splitRepeatedCells();
            if (cell.isCoveredElement() && coverCell != null) {
                coverCell.setColumnSpannedNumber(coverCell.getColumnSpannedNumber() - cell.getColumnsRepeatedNumber());
                this.maRowElement.removeChild(cell.getOdfElement());
                i += cell.getColumnsRepeatedNumber() - 1;
                continue;
            }
            if (cell.isCoveredElement()) {
                this.maRowElement.removeChild(cell.getOdfElement());
                i += cell.getColumnsRepeatedNumber() - 1;
                continue;
            }
            if (cell.isCoveredElement()) continue;
            if (i + cell.getColumnSpannedNumber() <= nCount) {
                this.maRowElement.removeChild(cell.getOdfElement());
                i += cell.getColumnSpannedNumber() - 1;
                continue;
            }
            this.removeCellByIndex(index + 1, nCount - i);
        }
        int clmnum = this.getTable().getColumnCount();
        if (nStart + nCount >= clmnum) {
            cell = this.getCellByIndex(nStart - 1);
            this.reviseStyleFromMediumColumnToLast(cell);
        }
    }

    void removeAllCellsRelationship() {
        OdfTableCell cell;
        OdfTable table = this.getTable();
        for (int i = 0; i < table.getColumnCount(); i += cell.getColumnSpannedNumber()) {
            OdfTableCell coveredCell;
            cell = this.getCellByIndex(i);
            if (cell.isCoveredElement()) {
                OdfTableCell coverCell = cell.getCoverCellInSameColumn();
                if (coverCell != null) {
                    coverCell.setRowSpannedNumber(coverCell.getRowSpannedNumber() - this.getRowsRepeatedNumber());
                }
                this.getOdfElement().removeChild(cell.getOdfElement());
                continue;
            }
            if (cell.getRowSpannedNumber() <= 1) continue;
            OdfTableRow nextRow = table.getRowByIndex(this.getRowIndex() + 1);
            if (nextRow.getRowsRepeatedNumber() > 1) {
                nextRow.splitRepeatedRows();
            }
            if ((coveredCell = table.getCellByPosition(cell.getColumnIndex(), this.getRowIndex() + 1)).getColumnsRepeatedNumber() > 1) {
                coveredCell.splitRepeatedCells();
                coveredCell = table.getCellByPosition(cell.getColumnIndex(), this.getRowIndex() + 1);
            }
            TableTableCellElement newCellEle = (TableTableCellElement)cell.getOdfElement().cloneNode(true);
            newCellEle.setTableNumberRowsSpannedAttribute(cell.getRowSpannedNumber() - this.getRowsRepeatedNumber());
            int startRow = coveredCell.getRowIndex();
            int endRow = coveredCell.getRowIndex() + newCellEle.getTableNumberRowsSpannedAttribute();
            int startClm = coveredCell.getColumnIndex();
            int endClm = coveredCell.getColumnIndex() + newCellEle.getTableNumberColumnsSpannedAttribute() * newCellEle.getTableNumberColumnsRepeatedAttribute();
            coveredCell.getOdfElement().getParentNode().replaceChild(newCellEle, coveredCell.getOdfElement());
            table.updateRepositoryWhenCellElementChanged(startRow, endRow, startClm, endClm, newCellEle);
        }
    }
}

