/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.util.XsTypeConverter;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.XmlObjectBase;

public abstract class JavaFloatHolder
extends XmlObjectBase {
    private float _value;

    public SchemaType schemaType() {
        return BuiltinSchemaTypeSystem.ST_FLOAT;
    }

    protected String compute_text(NamespaceManager nsm) {
        return JavaFloatHolder.serialize(this._value);
    }

    public static String serialize(float f) {
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f == Float.NaN) {
            return "NaN";
        }
        return Float.toString(f);
    }

    protected void set_text(String s) {
        this.set_float(JavaFloatHolder.validateLexical(s, _voorVc));
    }

    public static float validateLexical(String v, ValidationContext context) {
        try {
            return XsTypeConverter.lexFloat(v);
        }
        catch (NumberFormatException e2) {
            context.invalid("float", new Object[]{v});
            return Float.NaN;
        }
    }

    protected void set_nil() {
        this._value = 0.0f;
    }

    public BigDecimal bigDecimalValue() {
        this.check_dated();
        return new BigDecimal(this._value);
    }

    public double doubleValue() {
        this.check_dated();
        return this._value;
    }

    public float floatValue() {
        this.check_dated();
        return this._value;
    }

    protected void set_double(double v) {
        this.set_float((float)v);
    }

    protected void set_float(float v) {
        this._value = v;
    }

    protected void set_long(long v) {
        this.set_float(v);
    }

    protected void set_BigDecimal(BigDecimal v) {
        this.set_float(v.floatValue());
    }

    protected void set_BigInteger(BigInteger v) {
        this.set_float(v.floatValue());
    }

    protected int compare_to(XmlObject f) {
        return JavaFloatHolder.compare(this._value, ((XmlObjectBase)f).floatValue());
    }

    static int compare(float thisValue, float thatValue) {
        int thatBits;
        if (thisValue < thatValue) {
            return -1;
        }
        if (thisValue > thatValue) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(thisValue);
        return thisBits == (thatBits = Float.floatToIntBits(thatValue)) ? 0 : (thisBits < thatBits ? -1 : 1);
    }

    protected boolean equal_to(XmlObject f) {
        return JavaFloatHolder.compare(this._value, ((XmlObjectBase)f).floatValue()) == 0;
    }

    protected int value_hash_code() {
        return Float.floatToIntBits(this._value);
    }
}

