/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;

public class CopyCompare {
    public static void main(String[] args) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        String originalFileName = null;
        String copyFileName = null;
        if (args.length == 1) {
            originalFileName = args[0];
            File f = TempFile.createTempFile("CopyOfPOIFileSystem-", ".ole2");
            f.deleteOnExit();
            copyFileName = f.getAbsolutePath();
        } else if (args.length == 2) {
            originalFileName = args[0];
            copyFileName = args[1];
        } else {
            System.err.println("Usage: " + CopyCompare.class.getName() + "originPOIFS [copyPOIFS]");
            System.exit(1);
        }
        POIFSReader r = new POIFSReader();
        CopyFile cf = new CopyFile(copyFileName);
        r.registerListener(cf);
        r.read(new FileInputStream(originalFileName));
        cf.close();
        POIFSFileSystem opfs = new POIFSFileSystem(new FileInputStream(originalFileName));
        POIFSFileSystem cpfs = new POIFSFileSystem(new FileInputStream(copyFileName));
        DirectoryNode oRoot = opfs.getRoot();
        DirectoryNode cRoot = cpfs.getRoot();
        StringBuffer messages = new StringBuffer();
        if (CopyCompare.equal(oRoot, cRoot, messages)) {
            System.out.println("Equal");
        } else {
            System.out.println("Not equal: " + messages.toString());
        }
    }

    private static boolean equal(DirectoryEntry d1, DirectoryEntry d2, StringBuffer msg) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        boolean equal = true;
        Iterator<Entry> i = d1.getEntries();
        while (equal && i.hasNext()) {
            Entry e1 = i.next();
            String n1 = e1.getName();
            Entry e2 = null;
            try {
                e2 = d2.getEntry(n1);
            }
            catch (FileNotFoundException ex) {
                msg.append("Document \"" + e1 + "\" exists, document \"" + e2 + "\" does not.\n");
                equal = false;
                break;
            }
            if (e1.isDirectoryEntry() && e2.isDirectoryEntry()) {
                equal = CopyCompare.equal((DirectoryEntry)e1, (DirectoryEntry)e2, msg);
                continue;
            }
            if (e1.isDocumentEntry() && e2.isDocumentEntry()) {
                equal = CopyCompare.equal((DocumentEntry)e1, (DocumentEntry)e2, msg);
                continue;
            }
            msg.append("One of \"" + e1 + "\" and \"" + e2 + "\" is a " + "document while the other one is a directory.\n");
            equal = false;
        }
        i = d2.getEntries();
        while (equal && i.hasNext()) {
            Entry e2 = i.next();
            String n2 = e2.getName();
            Entry e1 = null;
            try {
                e1 = d1.getEntry(n2);
            }
            catch (FileNotFoundException ex) {
                msg.append("Document \"" + e2 + "\" exitsts, document \"" + e1 + "\" does not.\n");
                equal = false;
                break;
            }
        }
        return equal;
    }

    private static boolean equal(DocumentEntry d1, DocumentEntry d2, StringBuffer msg) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        boolean equal = true;
        DocumentInputStream dis1 = new DocumentInputStream(d1);
        DocumentInputStream dis2 = new DocumentInputStream(d2);
        if (PropertySet.isPropertySetStream(dis1) && PropertySet.isPropertySetStream(dis2)) {
            PropertySet ps2;
            PropertySet ps1 = PropertySetFactory.create(dis1);
            equal = ps1.equals(ps2 = PropertySetFactory.create(dis2));
            if (!equal) {
                msg.append("Property sets are not equal.\n");
                return equal;
            }
        } else {
            int i1;
            do {
                int i2;
                if ((i1 = dis1.read()) == (i2 = dis2.read())) continue;
                equal = false;
                msg.append("Documents are not equal.\n");
                break;
            } while (equal && i1 == -1);
        }
        return true;
    }

    static class CopyFile
    implements POIFSReaderListener {
        String dstName;
        OutputStream out;
        POIFSFileSystem poiFs;
        private final Map paths = new HashMap();

        public CopyFile(String dstName) {
            this.dstName = dstName;
            this.poiFs = new POIFSFileSystem();
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            Exception t;
            String name;
            POIFSDocumentPath path;
            block8: {
                path = event.getPath();
                name = event.getName();
                DocumentInputStream stream = event.getStream();
                t = null;
                try {
                    if (PropertySet.isPropertySetStream(stream)) {
                        PropertySet ps = null;
                        try {
                            ps = PropertySetFactory.create(stream);
                        }
                        catch (NoPropertySetStreamException ex) {
                            // empty catch block
                        }
                        this.copy(this.poiFs, path, name, ps);
                        break block8;
                    }
                    this.copy(this.poiFs, event.getPath(), event.getName(), stream);
                }
                catch (MarkUnsupportedException ex) {
                    t = ex;
                }
                catch (IOException ex) {
                    t = ex;
                }
                catch (WritingNotSupportedException ex) {
                    t = ex;
                }
            }
            if (t != null) {
                throw new HPSFRuntimeException("Could not read file \"" + path + "/" + name + "\". Reason: " + Util.toString(t));
            }
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, PropertySet ps) throws WritingNotSupportedException, IOException {
            DirectoryEntry de = this.getPath(poiFs, path);
            MutablePropertySet mps = new MutablePropertySet(ps);
            de.createDocument(name, mps.toInputStream());
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, DocumentInputStream stream) throws IOException {
            int c;
            DirectoryEntry de = this.getPath(poiFs, path);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = stream.read()) != -1) {
                out.write(c);
            }
            stream.close();
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            de.createDocument(name, in);
        }

        public void close() throws FileNotFoundException, IOException {
            this.out = new FileOutputStream(this.dstName);
            this.poiFs.writeFilesystem(this.out);
            this.out.close();
        }

        public DirectoryEntry getPath(POIFSFileSystem poiFs, POIFSDocumentPath path) {
            try {
                String s = path.toString();
                DirectoryEntry de = (DirectoryEntry)this.paths.get(s);
                if (de != null) {
                    return de;
                }
                int l = path.length();
                if (l == 0) {
                    de = poiFs.getRoot();
                } else {
                    de = this.getPath(poiFs, path.getParent());
                    de = de.createDirectory(path.getComponent(path.length() - 1));
                }
                this.paths.put(s, de);
                return de;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                throw new RuntimeException(ex.toString());
            }
        }
    }
}

