/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.gui;

import com.janus.qrinvoice.QRInvoiceLogInitializer;
import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.gui.MainPanel;
import com.janus.qrinvoice.gui.QRInvoicePreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class QRInvoice {
    public static final String LAST_SAVE_DIR = "last.save.dir";
    private static Logger logger;
    private JFrame frame;
    private JPanel northPanel;
    private JPanel southPanel;
    private final ImageIcon logo = new ImageIcon(this.getClass().getResource("logo_app.png"));
    private JLabel logoContainer;
    private JPanel logoPanel;
    private JPanel centerWestPanel;
    private JPanel centerEastPanel;
    private MainPanel mainPanel;
    protected JButton downloadBtn;
    protected JButton licenseBtn;
    protected JScrollPane centerScrollPanel;
    protected JTextPane centerTextPanel;
    private JPanel centerPanel;

    public static void main(String[] stringArray) throws SecurityException, IOException {
        QRInvoiceLogInitializer qRInvoiceLogInitializer = new QRInvoiceLogInitializer();
        qRInvoiceLogInitializer.initializeJavaLogging();
        Logger.getGlobal().info("Starting QRInvoice...");
        Logger.getGlobal().info("Version: " + ApplicationContext.get().getCurrentVersion());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    QRInvoice qRInvoice = new QRInvoice();
                    qRInvoice.frame.setVisible(true);
                    QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
                    if (!qRInvoicePreferences.hasValidLicense()) {
                        if (qRInvoicePreferences.hasEvaluationPeriodExpired()) {
                            JLabel jLabel = new JLabel();
                            JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body>" + ApplicationContext.get().text().getString("exceededTestPhase") + "<br><span style=\"text-align: center;\">(<a href=\"" + ApplicationContext.get().text().getString("buyURL") + "\">" + ApplicationContext.get().text().getString("buyHint") + "</a>)</span></body></html>");
                            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                                @Override
                                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                                    if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                        try {
                                            QRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("buyURL")).toURI());
                                        }
                                        catch (MalformedURLException | URISyntaxException exception) {
                                            logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("buyURL"), exception);
                                        }
                                    }
                                }
                            });
                            jEditorPane.setEditable(false);
                            jEditorPane.setBackground(jLabel.getBackground());
                            String string = ApplicationContext.get().text().getString("enterLicenceKeyHeadline");
                            String string2 = QRInvoice.showInputDialog(qRInvoice.frame, jEditorPane, string);
                            if (string2 != null) {
                                if (qRInvoicePreferences.isValidLicense(string2)) {
                                    qRInvoicePreferences.saveLicense(string2);
                                    qRInvoice.licenseBtn.setEnabled(Boolean.FALSE);
                                } else {
                                    JOptionPane.showMessageDialog(null, ApplicationContext.get().text().getString("licenceInvalid"));
                                    System.exit(0);
                                }
                            } else {
                                System.exit(0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(qRInvoice.frame, MessageFormat.format(ApplicationContext.get().text().getString("exceededTestPhaseInXDays"), qRInvoicePreferences.daysLeftUntilEvaluationPeriodExceeds()));
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getGlobal().log(Level.SEVERE, "Exception while initializing QRInvoice GUI.", exception);
                    System.exit(0);
                }
            }
        });
    }

    private void isUpdateAvailable() {
        try {
            URL uRL = new URL("https://www.easyqrbill.ch/easyqrbill_version");
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            try (Object object = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
                int n = 0;
                while ((n = ((Reader)object).read()) != -1) {
                    stringBuilder.append((char)n);
                }
            }
            object = stringBuilder.toString().replaceAll("\n", "");
            inputStream.close();
            ApplicationContext.get().setAvailableVersion((String)object);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "No Internet Connection available. Can't look for updates.", exception);
        }
    }

    public QRInvoice() {
        logger = Logger.getLogger(QRInvoice.class.getName());
        this.isUpdateAvailable();
        this.initialize();
    }

    private void initialize() {
        this.frame = new JFrame("Easy QR-bill");
        this.frame.setBounds(100, 100, 1024, 768);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout(0, 0));
        Image image = new ImageIcon(this.getClass().getResource("logo_favicon.png")).getImage();
        this.frame.setIconImage(image);
        this.frame.setLocation(0, 0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < 1152 || dimension.height < 803) {
            this.frame.setExtendedState(6);
        }
        this.initNorthPanel();
        this.initSouthPanel();
        this.initCenterPanel();
        this.centerWestPanel = new JPanel();
        this.frame.getContentPane().add((Component)this.centerWestPanel, "West");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{10, 0};
        gridBagLayout.rowHeights = new int[]{39, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.centerWestPanel.setLayout(gridBagLayout);
        this.centerEastPanel = new JPanel();
        this.frame.getContentPane().add((Component)this.centerEastPanel, "East");
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{10, 0};
        gridBagLayout2.rowHeights = new int[]{39, 0};
        gridBagLayout2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.centerEastPanel.setLayout(gridBagLayout2);
    }

    public static void openWebpage(URI uRI) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uRI);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Could not open webpage.", exception);
            }
        }
    }

    public static void openWebpage(URL uRL) {
        try {
            QRInvoice.openWebpage(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.log(Level.WARNING, "Could not open webpage with uri.", uRISyntaxException);
        }
    }

    protected void initSouthPanel() {
        this.southPanel = new JPanel(){
            private static final long serialVersionUID = 1293846392876457645L;

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int n = this.getWidth();
                int n2 = this.getHeight();
                Color color = new Color(18, 113, 179);
                Color color2 = new Color(18, 113, 179);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, 0.0f, n2, color);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
            }
        };
        this.frame.getContentPane().add((Component)this.southPanel, "South");
        this.downloadBtn = new JButton(ApplicationContext.get().text().getString("createQRInvoiceFiles"));
        this.downloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QRInvoice.this.doSaveDialog(((QRInvoice)QRInvoice.this).mainPanel.singlePDF.isSelected());
            }
        });
        this.downloadBtn.setEnabled(Boolean.FALSE);
        this.downloadBtn.setToolTipText(ApplicationContext.get().text().getString("buttonHint"));
        this.southPanel.add(this.downloadBtn);
        QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
        this.licenseBtn = new JButton(ApplicationContext.get().text().getString("enterLicenceKey"));
        this.licenseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (QRInvoice.this.licenseBtn.isEnabled()) {
                    QRInvoice.this.doLicenseDialog();
                }
            }
        });
        this.southPanel.add(this.licenseBtn);
        this.licenseBtn.setEnabled(!qRInvoicePreferences.hasValidLicense());
        String string = ApplicationContext.get().text().getString("qrinvoiceVersion") + " " + ApplicationContext.get().getCurrentVersion();
        JLabel jLabel = new JLabel(string);
        this.southPanel.add(jLabel);
        if (ApplicationContext.get().getAvailableVersion() != null && !ApplicationContext.get().getCurrentVersion().equals(ApplicationContext.get().getAvailableVersion())) {
            logger.info("Version local: '" + ApplicationContext.get().getCurrentVersion() + "'");
            logger.info("Version remote: '" + ApplicationContext.get().getAvailableVersion() + "'");
            JButton jButton = new JButton(MessageFormat.format(ApplicationContext.get().text().getString("updateAvailabe"), ApplicationContext.get().getAvailableVersion()));
            jButton.setIcon(new ImageIcon(this.getClass().getResource("led_green.png")));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        QRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("downloadURL")).toURI());
                    }
                    catch (MalformedURLException | URISyntaxException exception) {
                        logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("downloadURL"), exception);
                    }
                }
            });
            this.southPanel.add(jButton);
        }
    }

    protected void initCenterPanel() {
        this.centerTextPanel = new JTextPane();
        this.centerTextPanel.setMargin(new Insets(4, 4, 4, 4));
        this.centerTextPanel.setEditable(false);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.frame.getContentPane().add((Component)this.centerPanel, "Center");
        this.mainPanel = new MainPanel(this.centerTextPanel.getStyledDocument(), this.downloadBtn);
        this.mainPanel.setMinimumSize(new Dimension(1000, 330));
        this.mainPanel.setMaximumSize(new Dimension(1000, 330));
        JScrollPane jScrollPane = new JScrollPane(this.mainPanel, 20, 30);
        this.centerPanel.add(jScrollPane);
        this.centerScrollPanel = new JScrollPane(this.centerTextPanel);
        this.centerPanel.add(this.centerScrollPanel);
        this.mainPanel.addFirstSteps();
    }

    protected void initNorthPanel() {
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new BoxLayout(this.northPanel, 3));
        this.logoPanel = new JPanel(){
            private static final long serialVersionUID = 917349812649216L;

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int n = this.getWidth();
                int n2 = this.getHeight();
                Color color = new Color(238, 238, 238);
                Color color2 = new Color(238, 238, 238);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
            }
        };
        this.northPanel.add(this.logoPanel);
        this.logoContainer = new JLabel(this.logo);
        this.logoContainer.setBackground(Color.WHITE);
        this.logoContainer.setCursor(new Cursor(12));
        this.logoContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                try {
                    QRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("defaultURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("defaultURL"), exception);
                }
            }
        });
        this.logoPanel.add(this.logoContainer);
        this.logoContainer.setText("");
        this.frame.getContentPane().add((Component)this.northPanel, "North");
    }

    protected void doLicenseDialog() {
        logger.finest("+doLicenseDialog");
        QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
        String string = ApplicationContext.get().text().getString("enterLicenceKeyHeadline");
        String string2 = QRInvoice.showInputDialog(null, string);
        if (string2 != null) {
            if (qRInvoicePreferences.isValidLicense(string2)) {
                qRInvoicePreferences.saveLicense(string2);
                this.licenseBtn.setEnabled(Boolean.FALSE);
            } else {
                JOptionPane.showMessageDialog(null, ApplicationContext.get().text().getString("licenceInvalid"));
            }
        }
        logger.finest("-doLicenseDialog");
    }

    protected void doSaveDialog(boolean bl) {
        File file;
        Object object;
        logger.finest("+doSaveDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("saveAs"));
        if (bl) {
            jFileChooser.setFileSelectionMode(0);
            object = new FileNameExtensionFilter("pdf", "pdf");
            jFileChooser.setFileFilter((FileFilter)object);
        } else {
            jFileChooser.setFileSelectionMode(1);
            object = new FileNameExtensionFilter("Nur Verzeichnisse", "*.*");
            jFileChooser.addChoosableFileFilter((FileFilter)object);
        }
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        object = new QRInvoicePreferences();
        String string = ((QRInvoicePreferences)object).loadPreference(LAST_SAVE_DIR);
        if (string != null && (file = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("saveFile"));
        switch (n) {
            case 0: {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                if (bl && !string2.toLowerCase().endsWith("pdf")) {
                    string2 = string2 + ".pdf";
                    logger.fine("adding file extension \".pdf\"");
                }
                ((QRInvoicePreferences)object).savePreference(LAST_SAVE_DIR, bl ? jFileChooser.getCurrentDirectory().getAbsolutePath() : jFileChooser.getSelectedFile().getAbsolutePath());
                this.mainPanel.doSave(Paths.get(string2, new String[0]));
                break;
            }
            case 1: {
                jFileChooser.setVisible(false);
                logger.fine("cancel pressed.");
                break;
            }
        }
        logger.finest("-doSaveDialog");
    }

    public static String showInputDialog(Component component, String string) {
        JTextField jTextField = new JTextField();
        jTextField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jTextField, gridBagConstraints);
        int n = JOptionPane.showConfirmDialog(component, jPanel, string, 2, -1);
        if (n == 0) {
            return jTextField.getText();
        }
        return null;
    }

    protected static String showInputDialog(Component component, JEditorPane jEditorPane, String string) {
        JTextField jTextField = new JTextField();
        jTextField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0);
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jTextField, gridBagConstraints);
        int n = JOptionPane.showConfirmDialog(component, jPanel, string, 2, -1);
        if (n == 0) {
            return jTextField.getText();
        }
        return null;
    }
}

