/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.navigation.CellSelection;
import org.odftoolkit.simple.common.navigation.Navigation;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.table.Cell;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextNavigation
extends Navigation {
    private String mMatchedElementName = "text:p,text:h";
    private Pattern mPattern;
    private Document mDocument;
    private OdfElement mElement;
    private TextSelection mNextSelectedItem;
    private TextSelection mTempSelectedItem;
    private TextSelection mReplacedItem;
    private boolean handlePageBreak;
    private String mNextText;
    private int mNextIndex;
    private boolean mbFinishFindInHeaderFooter;
    private IdentityHashMap<OdfElement, OdfElement> modifiedStyleList;

    public TextNavigation(String pattern, Document doc) {
        this.mPattern = Pattern.compile(pattern);
        this.mDocument = doc;
        this.mElement = null;
        this.mNextSelectedItem = null;
        this.mTempSelectedItem = null;
        this.mbFinishFindInHeaderFooter = false;
        this.setHandlePageBreak(false);
    }

    public TextNavigation(String pattern, OdfElement element) {
        this.mPattern = Pattern.compile(pattern);
        this.mDocument = null;
        this.mElement = element;
        this.mNextSelectedItem = null;
        this.mTempSelectedItem = null;
        this.mbFinishFindInHeaderFooter = false;
    }

    public boolean hasNext() {
        this.mTempSelectedItem = this.findNext(this.mNextSelectedItem);
        return this.mTempSelectedItem != null;
    }

    void setSelectedItem(TextSelection nextSelectedItem) {
        this.mNextSelectedItem = nextSelectedItem;
    }

    TextSelection getSelectedItem() {
        return this.mNextSelectedItem;
    }

    public Selection nextSelection() {
        if (this.mTempSelectedItem != null) {
            this.mNextSelectedItem = this.mTempSelectedItem;
            this.mTempSelectedItem = null;
        } else {
            this.mNextSelectedItem = this.findNext(this.mNextSelectedItem);
        }
        if (this.mNextSelectedItem == null) {
            return null;
        }
        Selection.SelectionManager.registerItem(this.mNextSelectedItem);
        return this.mNextSelectedItem;
    }

    public boolean match(Node element) {
        String content;
        Matcher matcher;
        if (element instanceof OdfElement && (matcher = this.mPattern.matcher(content = TextExtractor.getText((OdfElement)element))).find()) {
            for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                String childContent = this.getText(childNode);
                Matcher childMatcher = this.mPattern.matcher(childContent);
                if (!childMatcher.find()) continue;
                if (childNode.getNodeType() == 3 || "text:span".equalsIgnoreCase(childNode.getNodeName()) || "text:a".equalsIgnoreCase(childNode.getNodeName())) break;
                return false;
            }
            if (this.mMatchedElementName.indexOf(element.getNodeName()) != -1) {
                this.mNextIndex = matcher.start();
                int eIndex = matcher.end();
                this.mNextText = content.substring(this.mNextIndex, eIndex);
                return true;
            }
        }
        return false;
    }

    private String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node instanceof OdfElement) {
            return TextExtractor.getText((OdfElement)node);
        }
        return "";
    }

    private TextSelection findInHeaderFooter(TextSelection selected) {
        OdfStylesDom styledom = null;
        OdfOfficeMasterStyles masterpage = null;
        OdfElement element = null;
        if (selected != null) {
            OdfElement containerElement = selected.getContainerElement();
            int index = selected.getIndex();
            String content = TextExtractor.getText(containerElement);
            int nextIndex = -1;
            Matcher matcher = this.mPattern.matcher(content);
            if (matcher.find(index + selected.getText().length())) {
                nextIndex = matcher.start();
                int eIndex = matcher.end();
                this.mNextText = content.substring(nextIndex, eIndex);
            }
            if (nextIndex != -1) {
                return this.createSelection(selected.getContainerElement(), nextIndex);
            }
        }
        try {
            styledom = this.mDocument.getStylesDom();
            NodeList list = styledom.getElementsByTagName("office:master-styles");
            if (styledom == null) {
                return null;
            }
            if (list.getLength() <= 0) {
                return null;
            }
            masterpage = (OdfOfficeMasterStyles)list.item(0);
            element = selected == null ? (OdfElement)this.getNextMatchElementInTree(masterpage, masterpage) : (OdfElement)this.getNextMatchElementInTree(selected.getContainerElement(), masterpage);
            if (element != null) {
                return this.createSelection(element, this.mNextIndex);
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private TextSelection findNext(TextSelection selected) {
        int eIndex;
        if (!this.mbFinishFindInHeaderFooter) {
            TextSelection styleselected;
            if (this.mElement == null && (styleselected = this.findInHeaderFooter(selected)) != null) {
                return styleselected;
            }
            selected = null;
            this.mbFinishFindInHeaderFooter = true;
        }
        OdfElement rootElement = null;
        try {
            rootElement = this.mElement != null ? this.mElement : this.mDocument.getContentRoot();
        }
        catch (Exception ex) {
            Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (selected == null) {
            OdfElement element = (OdfElement)this.getNextMatchElementInTree(rootElement, rootElement);
            if (element != null) {
                return this.createSelection(element, this.mNextIndex);
            }
            return null;
        }
        OdfElement containerElement = selected.getContainerElement();
        int index = selected.getIndex();
        String content = TextExtractor.getText(containerElement);
        int nextIndex = -1;
        Matcher matcher = this.mPattern.matcher(content);
        if (!selected.isSelectionReplaced()) {
            if (content.length() > index + selected.getText().length() && matcher.find(index + selected.getText().length())) {
                nextIndex = matcher.start();
                eIndex = matcher.end();
                this.mNextText = content.substring(nextIndex, eIndex);
            }
        } else if (content.length() >= index + selected.getText().length() && matcher.find(index)) {
            nextIndex = matcher.start();
            eIndex = matcher.end();
            this.mNextText = content.substring(nextIndex, eIndex);
        }
        if (nextIndex != -1) {
            return this.createSelection(selected.getContainerElement(), nextIndex);
        }
        OdfElement element = (OdfElement)this.getNextMatchElementInTree(containerElement, rootElement);
        if (element != null) {
            return this.createSelection(element, this.mNextIndex);
        }
        return null;
    }

    private TextSelection createSelection(OdfElement containerElement, int nextIndex) {
        TextSelection item = null;
        for (Node parent = containerElement.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (TableTableCellElementBase.class.isInstance(parent)) {
                TableTableCellElementBase cellElement = (TableTableCellElementBase)parent;
                Cell cell = Cell.getInstance(cellElement);
                item = new CellSelection(this, this.mNextText, containerElement, nextIndex, cell);
                break;
            }
            OdfName odfName = ((OdfElement)parent).getOdfName();
            String ns = odfName.getPrefix();
            if (!"text".equals(ns)) break;
        }
        if (item == null) {
            item = new TextSelection(this, this.mNextText, containerElement, nextIndex);
        }
        return item;
    }

    OdfElement getModifiedStyleElement(OdfElement styleElement) {
        if (this.modifiedStyleList == null) {
            return null;
        }
        return this.modifiedStyleList.get(styleElement);
    }

    void addModifiedStyleElement(OdfElement styleElment, OdfElement modifiedStyleElement) {
        if (modifiedStyleElement != null) {
            if (this.modifiedStyleList == null) {
                this.modifiedStyleList = new IdentityHashMap();
            }
            this.modifiedStyleList.put(styleElment, modifiedStyleElement);
        }
    }

    boolean isHandlePageBreak() {
        return this.handlePageBreak;
    }

    void setHandlePageBreak(boolean handlePageBreak) {
        this.handlePageBreak = handlePageBreak;
    }

    void setReplacedItem(TextSelection replacedItem) {
        this.mReplacedItem = replacedItem;
    }

    TextSelection getReplacedItem() {
        return this.mReplacedItem;
    }
}

