/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.EvaluationTracker;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.ExternSheetReferenceToken;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.LazyAreaEval;
import org.apache.poi.ss.formula.LazyRefEval;
import org.apache.poi.ss.formula.SheetRefEvaluator;
import org.apache.poi.ss.formula.UserDefinedFunction;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NameXEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.NameXPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.util.CellReference;

public final class OperationEvaluationContext {
    public static final FreeRefFunction UDF = UserDefinedFunction.instance;
    private final EvaluationWorkbook _workbook;
    private final int _sheetIndex;
    private final int _rowIndex;
    private final int _columnIndex;
    private final EvaluationTracker _tracker;
    private final WorkbookEvaluator _bookEvaluator;

    public OperationEvaluationContext(WorkbookEvaluator bookEvaluator, EvaluationWorkbook workbook, int sheetIndex, int srcRowNum, int srcColNum, EvaluationTracker tracker) {
        this._bookEvaluator = bookEvaluator;
        this._workbook = workbook;
        this._sheetIndex = sheetIndex;
        this._rowIndex = srcRowNum;
        this._columnIndex = srcColNum;
        this._tracker = tracker;
    }

    public EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    SheetRefEvaluator createExternSheetRefEvaluator(ExternSheetReferenceToken ptg) {
        return this.createExternSheetRefEvaluator(ptg.getExternSheetIndex());
    }

    SheetRefEvaluator createExternSheetRefEvaluator(int externSheetIndex) {
        WorkbookEvaluator targetEvaluator;
        int otherSheetIndex;
        EvaluationWorkbook.ExternalSheet externalSheet = this._workbook.getExternalSheet(externSheetIndex);
        if (externalSheet == null) {
            otherSheetIndex = this._workbook.convertFromExternSheetIndex(externSheetIndex);
            targetEvaluator = this._bookEvaluator;
        } else {
            String workbookName = externalSheet.getWorkbookName();
            try {
                targetEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(workbookName);
            }
            catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            otherSheetIndex = targetEvaluator.getSheetIndex(externalSheet.getSheetName());
            if (otherSheetIndex < 0) {
                throw new RuntimeException("Invalid sheet name '" + externalSheet.getSheetName() + "' in bool '" + workbookName + "'.");
            }
        }
        return new SheetRefEvaluator(targetEvaluator, this._tracker, otherSheetIndex);
    }

    private SheetRefEvaluator createExternSheetRefEvaluator(String workbookName, String sheetName) {
        int otherSheetIndex;
        WorkbookEvaluator targetEvaluator;
        if (workbookName == null) {
            targetEvaluator = this._bookEvaluator;
        } else {
            if (sheetName == null) {
                throw new IllegalArgumentException("sheetName must not be null if workbookName is provided");
            }
            try {
                targetEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(workbookName);
            }
            catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException e2) {
                return null;
            }
        }
        int n = otherSheetIndex = sheetName == null ? this._sheetIndex : targetEvaluator.getSheetIndex(sheetName);
        if (otherSheetIndex < 0) {
            return null;
        }
        return new SheetRefEvaluator(targetEvaluator, this._tracker, otherSheetIndex);
    }

    public SheetRefEvaluator getRefEvaluatorForCurrentSheet() {
        return new SheetRefEvaluator(this._bookEvaluator, this._tracker, this._sheetIndex);
    }

    public ValueEval getDynamicReference(String workbookName, String sheetName, String refStrPart1, String refStrPart2, boolean isA1Style) {
        int lastCol;
        int firstCol;
        int lastRow;
        int firstRow;
        if (!isA1Style) {
            throw new RuntimeException("R1C1 style not supported yet");
        }
        SheetRefEvaluator sre = this.createExternSheetRefEvaluator(workbookName, sheetName);
        if (sre == null) {
            return ErrorEval.REF_INVALID;
        }
        SpreadsheetVersion ssVersion = ((FormulaParsingWorkbook)((Object)this._workbook)).getSpreadsheetVersion();
        CellReference.NameType part1refType = OperationEvaluationContext.classifyCellReference(refStrPart1, ssVersion);
        switch (part1refType) {
            case BAD_CELL_OR_NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
            case NAMED_RANGE: {
                EvaluationName nm = ((FormulaParsingWorkbook)((Object)this._workbook)).getName(refStrPart1, this._sheetIndex);
                if (!nm.isRange()) {
                    throw new RuntimeException("Specified name '" + refStrPart1 + "' is not a range as expected.");
                }
                return this._bookEvaluator.evaluateNameFormula(nm.getNameDefinition(), this);
            }
        }
        if (refStrPart2 == null) {
            switch (part1refType) {
                case COLUMN: 
                case ROW: {
                    return ErrorEval.REF_INVALID;
                }
                case CELL: {
                    CellReference cr = new CellReference(refStrPart1);
                    return new LazyRefEval(cr.getRow(), cr.getCol(), sre);
                }
            }
            throw new IllegalStateException("Unexpected reference classification of '" + refStrPart1 + "'.");
        }
        CellReference.NameType part2refType = OperationEvaluationContext.classifyCellReference(refStrPart1, ssVersion);
        switch (part2refType) {
            case BAD_CELL_OR_NAMED_RANGE: {
                return ErrorEval.REF_INVALID;
            }
            case NAMED_RANGE: {
                throw new RuntimeException("Cannot evaluate '" + refStrPart1 + "'. Indirect evaluation of defined names not supported yet");
            }
        }
        if (part2refType != part1refType) {
            return ErrorEval.REF_INVALID;
        }
        switch (part1refType) {
            case COLUMN: {
                firstRow = 0;
                if (part2refType.equals((Object)CellReference.NameType.COLUMN)) {
                    lastRow = ssVersion.getLastRowIndex();
                    firstCol = OperationEvaluationContext.parseRowRef(refStrPart1);
                    lastCol = OperationEvaluationContext.parseRowRef(refStrPart2);
                    break;
                }
                lastRow = ssVersion.getLastRowIndex();
                firstCol = OperationEvaluationContext.parseColRef(refStrPart1);
                lastCol = OperationEvaluationContext.parseColRef(refStrPart2);
                break;
            }
            case ROW: {
                firstCol = 0;
                if (part2refType.equals((Object)CellReference.NameType.ROW)) {
                    firstRow = OperationEvaluationContext.parseColRef(refStrPart1);
                    lastRow = OperationEvaluationContext.parseColRef(refStrPart2);
                    lastCol = ssVersion.getLastColumnIndex();
                    break;
                }
                lastCol = ssVersion.getLastColumnIndex();
                firstRow = OperationEvaluationContext.parseRowRef(refStrPart1);
                lastRow = OperationEvaluationContext.parseRowRef(refStrPart2);
                break;
            }
            case CELL: {
                CellReference cr = new CellReference(refStrPart1);
                firstRow = cr.getRow();
                firstCol = cr.getCol();
                cr = new CellReference(refStrPart2);
                lastRow = cr.getRow();
                lastCol = cr.getCol();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected reference classification of '" + refStrPart1 + "'.");
            }
        }
        return new LazyAreaEval(firstRow, firstCol, lastRow, lastCol, sre);
    }

    private static int parseRowRef(String refStrPart) {
        return CellReference.convertColStringToIndex(refStrPart);
    }

    private static int parseColRef(String refStrPart) {
        return Integer.parseInt(refStrPart) - 1;
    }

    private static CellReference.NameType classifyCellReference(String str2, SpreadsheetVersion ssVersion) {
        int len = str2.length();
        if (len < 1) {
            return CellReference.NameType.BAD_CELL_OR_NAMED_RANGE;
        }
        return CellReference.classifyCellReference(str2, ssVersion);
    }

    public FreeRefFunction findUserDefinedFunction(String functionName) {
        return this._bookEvaluator.findUserDefinedFunction(functionName);
    }

    public ValueEval getRefEval(int rowIndex, int columnIndex) {
        SheetRefEvaluator sre = this.getRefEvaluatorForCurrentSheet();
        return new LazyRefEval(rowIndex, columnIndex, sre);
    }

    public ValueEval getRef3DEval(int rowIndex, int columnIndex, int extSheetIndex) {
        SheetRefEvaluator sre = this.createExternSheetRefEvaluator(extSheetIndex);
        return new LazyRefEval(rowIndex, columnIndex, sre);
    }

    public ValueEval getAreaEval(int firstRowIndex, int firstColumnIndex, int lastRowIndex, int lastColumnIndex) {
        SheetRefEvaluator sre = this.getRefEvaluatorForCurrentSheet();
        return new LazyAreaEval(firstRowIndex, firstColumnIndex, lastRowIndex, lastColumnIndex, sre);
    }

    public ValueEval getArea3DEval(int firstRowIndex, int firstColumnIndex, int lastRowIndex, int lastColumnIndex, int extSheetIndex) {
        SheetRefEvaluator sre = this.createExternSheetRefEvaluator(extSheetIndex);
        return new LazyAreaEval(firstRowIndex, firstColumnIndex, lastRowIndex, lastColumnIndex, sre);
    }

    public ValueEval getNameXEval(NameXPtg nameXPtg) {
        EvaluationWorkbook.ExternalSheet externSheet = this._workbook.getExternalSheet(nameXPtg.getSheetRefIndex());
        if (externSheet == null) {
            return new NameXEval(nameXPtg);
        }
        String workbookName = externSheet.getWorkbookName();
        EvaluationWorkbook.ExternalName externName = this._workbook.getExternalName(nameXPtg.getSheetRefIndex(), nameXPtg.getNameIndex());
        try {
            WorkbookEvaluator refWorkbookEvaluator = this._bookEvaluator.getOtherWorkbookEvaluator(workbookName);
            EvaluationName evaluationName = refWorkbookEvaluator.getName(externName.getName(), externName.getIx() - 1);
            if (evaluationName != null && evaluationName.hasFormula()) {
                if (evaluationName.getNameDefinition().length > 1) {
                    throw new RuntimeException("Complex name formulas not supported yet");
                }
                Ptg ptg = evaluationName.getNameDefinition()[0];
                if (ptg instanceof Ref3DPtg) {
                    Ref3DPtg ref3D = (Ref3DPtg)ptg;
                    int sheetIndex = refWorkbookEvaluator.getSheetIndexByExternIndex(ref3D.getExternSheetIndex());
                    String sheetName = refWorkbookEvaluator.getSheetName(sheetIndex);
                    SheetRefEvaluator sre = this.createExternSheetRefEvaluator(workbookName, sheetName);
                    return new LazyRefEval(ref3D.getRow(), ref3D.getColumn(), sre);
                }
                if (ptg instanceof Area3DPtg) {
                    Area3DPtg area3D = (Area3DPtg)ptg;
                    int sheetIndex = refWorkbookEvaluator.getSheetIndexByExternIndex(area3D.getExternSheetIndex());
                    String sheetName = refWorkbookEvaluator.getSheetName(sheetIndex);
                    SheetRefEvaluator sre = this.createExternSheetRefEvaluator(workbookName, sheetName);
                    return new LazyAreaEval(area3D.getFirstRow(), area3D.getFirstColumn(), area3D.getLastRow(), area3D.getLastColumn(), sre);
                }
            }
            return ErrorEval.REF_INVALID;
        }
        catch (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException wnfe) {
            return ErrorEval.REF_INVALID;
        }
    }
}

