/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples;

import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimesheetDemo {
    private static final String[] titles = new String[]{"Person", "ID", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", "Total\nHrs", "Overtime\nHrs", "Regular\nHrs"};
    private static Object[][] sample_data = new Object[][]{{"Yegor Kozlov", "YK", 5.0, 8.0, 10.0, 5.0, 5.0, 7.0, 6.0}, {"Gisella Bronzetti", "GB", 4.0, 3.0, 1.0, 3.5, null, null, 4.0}};

    public static void main(String[] args) throws Exception {
        int i;
        int j;
        Workbook wb = args.length > 0 && args[0].equals("-xls") ? new HSSFWorkbook() : new XSSFWorkbook();
        Map<String, CellStyle> styles = TimesheetDemo.createStyles(wb);
        Sheet sheet = wb.createSheet("Timesheet");
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        sheet.setFitToPage(true);
        sheet.setHorizontallyCenter(true);
        Row titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(45.0f);
        Cell titleCell = titleRow.createCell(0);
        titleCell.setCellValue("Weekly Timesheet");
        titleCell.setCellStyle(styles.get("title"));
        sheet.addMergedRegion(CellRangeAddress.valueOf("$A$1:$L$1"));
        Row headerRow = sheet.createRow(1);
        headerRow.setHeightInPoints(40.0f);
        for (int i2 = 0; i2 < titles.length; ++i2) {
            Cell headerCell = headerRow.createCell(i2);
            headerCell.setCellValue(titles[i2]);
            headerCell.setCellStyle(styles.get("header"));
        }
        int rownum = 2;
        for (int i3 = 0; i3 < 10; ++i3) {
            Row row = sheet.createRow(rownum++);
            for (j = 0; j < titles.length; ++j) {
                Cell cell = row.createCell(j);
                if (j == 9) {
                    String ref = "C" + rownum + ":I" + rownum;
                    cell.setCellFormula("SUM(" + ref + ")");
                    cell.setCellStyle(styles.get("formula"));
                    continue;
                }
                if (j == 11) {
                    cell.setCellFormula("J" + rownum + "-K" + rownum);
                    cell.setCellStyle(styles.get("formula"));
                    continue;
                }
                cell.setCellStyle(styles.get("cell"));
            }
        }
        Row sumRow = sheet.createRow(rownum++);
        sumRow.setHeightInPoints(35.0f);
        Cell cell = sumRow.createCell(0);
        cell.setCellStyle(styles.get("formula"));
        cell = sumRow.createCell(1);
        cell.setCellValue("Total Hrs:");
        cell.setCellStyle(styles.get("formula"));
        for (j = 2; j < 12; ++j) {
            cell = sumRow.createCell(j);
            String ref = (char)(65 + j) + "3:" + (char)(65 + j) + "12";
            cell.setCellFormula("SUM(" + ref + ")");
            if (j >= 9) {
                cell.setCellStyle(styles.get("formula_2"));
                continue;
            }
            cell.setCellStyle(styles.get("formula"));
        }
        int n = ++rownum;
        sumRow = sheet.createRow(n);
        sumRow.setHeightInPoints(25.0f);
        cell = sumRow.createCell(0);
        cell.setCellValue("Total Regular Hours");
        cell.setCellStyle(styles.get("formula"));
        cell = sumRow.createCell(1);
        cell.setCellFormula("L13");
        cell.setCellStyle(styles.get("formula_2"));
        int n2 = ++rownum;
        ++rownum;
        sumRow = sheet.createRow(n2);
        sumRow.setHeightInPoints(25.0f);
        cell = sumRow.createCell(0);
        cell.setCellValue("Total Overtime Hours");
        cell.setCellStyle(styles.get("formula"));
        cell = sumRow.createCell(1);
        cell.setCellFormula("K13");
        cell.setCellStyle(styles.get("formula_2"));
        for (i = 0; i < sample_data.length; ++i) {
            Row row = sheet.getRow(2 + i);
            for (int j2 = 0; j2 < sample_data[i].length; ++j2) {
                if (sample_data[i][j2] == null) continue;
                if (sample_data[i][j2] instanceof String) {
                    row.getCell(j2).setCellValue((String)sample_data[i][j2]);
                    continue;
                }
                row.getCell(j2).setCellValue((Double)sample_data[i][j2]);
            }
        }
        sheet.setColumnWidth(0, 7680);
        for (i = 2; i < 9; ++i) {
            sheet.setColumnWidth(i, 1536);
        }
        sheet.setColumnWidth(10, 2560);
        String file = "timesheet.xls";
        if (wb instanceof XSSFWorkbook) {
            file = file + "x";
        }
        FileOutputStream out = new FileOutputStream(file);
        wb.write(out);
        out.close();
    }

    private static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        Font titleFont = wb.createFont();
        titleFont.setFontHeightInPoints((short)18);
        titleFont.setBoldweight((short)700);
        CellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFont(titleFont);
        styles.put("title", style);
        Font monthFont = wb.createFont();
        monthFont.setFontHeightInPoints((short)11);
        monthFont.setColor(IndexedColors.WHITE.getIndex());
        style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern((short)1);
        style.setFont(monthFont);
        style.setWrapText(true);
        styles.put("header", style);
        style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setWrapText(true);
        style.setBorderRight((short)1);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft((short)1);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop((short)1);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styles.put("cell", style);
        style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern((short)1);
        style.setDataFormat(wb.createDataFormat().getFormat("0.00"));
        styles.put("formula", style);
        style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        style.setFillPattern((short)1);
        style.setDataFormat(wb.createDataFormat().getFormat("0.00"));
        styles.put("formula_2", style);
        return styles;
    }
}

