/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view.brush;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class PendingPaintings {
    public static final String PENDING_PAINTINGS = PendingPaintings.class.getSimpleName();
    private final List<Painting> paintings = new ArrayList<Painting>();

    public PendingPaintings(JComponent parent) {
        parent.putClientProperty(PENDING_PAINTINGS, this);
    }

    public void clear() {
        this.paintings.clear();
    }

    public void paint(Graphics2D g) {
        g.setBackground(Color.CYAN);
        AffineTransform origTransform = g.getTransform();
        for (Painting c : this.paintings) {
            c.draw(g);
        }
        g.setTransform(origTransform);
        this.clear();
    }

    public static void add(JComponent c, Graphics2D g, Stroke stroke, Color color, Shape shape) {
        PendingPaintings.add(c, new Painting(stroke, color, shape, g.getTransform()));
    }

    public static void add(JComponent c, Painting newPainting) {
        PendingPaintings pending = PendingPaintings.pendingPaintingsFor(c);
        if (pending != null) {
            pending.paintings.add(newPainting);
        }
    }

    public static PendingPaintings pendingPaintingsFor(JComponent c) {
        for (Container parent = c; parent != null; parent = parent.getParent()) {
            JComponent jc;
            Object pd;
            if (!(parent instanceof JComponent) || (pd = (jc = parent).getClientProperty(PENDING_PAINTINGS)) == null) continue;
            return (PendingPaintings)pd;
        }
        return null;
    }

    public static class Painting {
        final Stroke stroke;
        final Color color;
        final Shape shape;
        final AffineTransform transform;

        public Painting(Stroke stroke, Color color, Shape shape, AffineTransform transform) {
            this.color = color;
            this.shape = shape;
            this.stroke = stroke;
            this.transform = transform;
        }

        public void draw(Graphics2D g) {
            g.setTransform(this.transform);
            g.setStroke(this.stroke);
            g.setColor(this.color);
            g.draw(this.shape);
        }
    }
}

