/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.AbsIRIImpl;
import org.apache.jena.iri.impl.IRIExamples;
import org.apache.jena.iri.impl.IRIFactoryImpl;
import org.apache.jena.iri.impl.Specification;

public class ViolationCodeInfo
extends IRIExamples
implements ViolationCodes {
    private final int force;
    private final String name;
    private final int code;
    private final String description;
    private final String descriptionHtml;
    private final boolean unimplemented;
    private final InSpec[] specifications;
    public static final ViolationCodeInfo[] all = new ViolationCodeInfo[64];

    public ViolationCodeInfo(int code, String name, String desc, String descHtml, int force, InSpec[] specs, String[] badExamples, String[] goodExamples, boolean unimplemented) {
        super(badExamples, goodExamples);
        if (force == 0) {
            force = 16;
        }
        this.force = force;
        this.name = name;
        this.code = code;
        this.description = desc;
        this.descriptionHtml = descHtml;
        this.unimplemented = unimplemented;
        this.specifications = specs;
        this.init();
    }

    public ViolationCodeInfo(int code, String name, String[] badExamples, String[] goodExamples, boolean internal) {
        super(badExamples, goodExamples);
        this.force = 0;
        this.name = name;
        this.code = code;
        this.description = name;
        this.descriptionHtml = "<p>name</p>";
        this.unimplemented = !internal;
        this.specifications = new InSpec[0];
        this.init();
    }

    private void init() {
        if (all[this.code] != null) {
            throw new IllegalArgumentException("Duplicate code: " + this.code + " (" + this.name + ", " + ViolationCodeInfo.all[this.code].name + ")");
        }
        ViolationCodeInfo.all[this.code] = this;
        for (int i = 0; i < this.specifications.length; ++i) {
            this.specifications[i].add(this);
        }
    }

    public int getCode() {
        return this.code;
    }

    public int getForce() {
        return this.force;
    }

    public String getCodeName() {
        return this.name;
    }

    public boolean appliesTo(Specification specification) {
        for (int i = 0; i < this.specifications.length; ++i) {
            if (this.specifications[i].spec != specification) continue;
            return true;
        }
        return false;
    }

    public boolean isImplemented() {
        return !this.unimplemented;
    }

    public String description(int slot, AbsIRIImpl iri2) {
        switch (this.code) {
            case 34: 
            case 35: {
                return this.description + " " + iri2.getIDNAException().getMessage();
            }
        }
        return this.description;
    }

    public String specs(int slot, IRIFactoryImpl factory, String scheme) {
        InSpec inSpec;
        int i;
        String result = "";
        boolean iriSpecApplies = false;
        for (i = 0; i < this.specifications.length; ++i) {
            inSpec = this.specifications[i];
            if (!inSpec.isIRISpec() || !inSpec.applies(factory)) continue;
            iriSpecApplies = true;
        }
        for (i = 0; i < this.specifications.length; ++i) {
            inSpec = this.specifications[i];
            if (inSpec.isSeeAlso() || inSpec.isIRISpec() && !iriSpecApplies || !inSpec.applies(slot, scheme)) continue;
            Specification spec = inSpec.spec;
            String uri = inSpec.uri;
            if (uri == null) {
                uri = spec.getUri();
            }
            result = result + spec.name() + " <" + uri + "> " + inSpec.definition();
        }
        return result;
    }

    public static class FromAlso
    extends InSpec {
        public FromAlso(String spec, String uri) {
            super(spec, uri);
        }

        @Override
        public boolean isSeeAlso() {
            return true;
        }

        @Override
        public boolean applies(int slot, String scheme) {
            return false;
        }
    }

    public static class FromSpec_iri
    extends FromSpec {
        public FromSpec_iri(String name, int component, String uri, String defn, String defnHtml) {
            super(name, component, uri, defn, defnHtml);
        }
    }

    public static class FromSpec_scheme
    extends FromSpec {
        public FromSpec_scheme(String name, int component, String uri, String defn, String defnHtml) {
            super(name, component, uri, defn, defnHtml);
        }

        public FromSpec_scheme(String name, int component, String uri) {
            this(name, component, uri, null, null);
        }

        @Override
        public boolean isIRISpec() {
            return false;
        }
    }

    public static class FromSpec_other
    extends FromSpec {
        public FromSpec_other(String name, int component, String uri, String defn, String defnHtml) {
            super(name, component, uri, defn, defnHtml);
        }
    }

    public static abstract class FromSpec
    extends InSpec {
        private final int component;
        private final String definition;
        private final String definitionHtml;

        @Override
        public boolean applies(int slot, String scheme) {
            if (this.component != -1 && this.component != slot) {
                return false;
            }
            return this.spec.applies(scheme);
        }

        public FromSpec(String name, int component, String uri, String defn, String defnHtml) {
            super(name, uri);
            this.component = component;
            this.definition = defn;
            this.definitionHtml = defnHtml;
        }

        @Override
        public String definition() {
            return "[[ " + this.definition + " ]]";
        }
    }

    public static abstract class InSpec {
        protected final Specification spec;
        private final String uri;

        public InSpec(String name, String uri) {
            this.spec = Specification.get(name);
            this.uri = uri.equals(this.spec.getUri()) ? null : uri;
        }

        public void add(ViolationCodeInfo info) {
            this.spec.add(this, info);
        }

        public boolean isSeeAlso() {
            return false;
        }

        public String definition() {
            return "";
        }

        public boolean applies(IRIFactoryImpl factory) {
            return factory.specs.contains(this.spec);
        }

        public boolean applies(int slot, String scheme) {
            return false;
        }

        public boolean isIRISpec() {
            return true;
        }
    }
}

