/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.QRBillValidationError;
import net.codecrete.qrbill.generator.ValidationMessage;
import net.codecrete.qrbill.generator.ValidationResult;

public class QRCodeText {
    private Bill bill;
    private StringBuilder textBuilder;
    private static final DecimalFormat amountFieldFormat = new DecimalFormat("0.00");
    private static final Pattern VALID_VERSION;

    private QRCodeText(Bill bill) {
        this.bill = bill;
    }

    public static String create(Bill bill) {
        QRCodeText qrCodeText = new QRCodeText(bill);
        return qrCodeText.createText();
    }

    private String createText() {
        this.textBuilder = new StringBuilder();
        this.textBuilder.append("SPC\n");
        this.textBuilder.append("0200\n");
        this.textBuilder.append("1");
        this.appendDataField(this.bill.getAccount());
        this.appendPerson(this.bill.getCreditor());
        this.textBuilder.append("\n\n\n\n\n\n\n");
        this.appendDataField(this.bill.getAmount() == null ? "" : QRCodeText.formatAmountForCode(this.bill.getAmount()));
        this.appendDataField(this.bill.getCurrency());
        this.appendPerson(this.bill.getDebtor());
        this.appendDataField(this.bill.getReferenceType());
        this.appendDataField(this.bill.getReference());
        this.appendDataField(this.bill.getUnstructuredMessage());
        this.appendDataField("EPD");
        this.appendDataField(this.bill.getBillInformation());
        if (this.bill.getAlternativeSchemes() != null && this.bill.getAlternativeSchemes().length > 0) {
            this.appendDataField(this.bill.getAlternativeSchemes()[0].getInstruction());
            if (this.bill.getAlternativeSchemes().length > 1) {
                this.appendDataField(this.bill.getAlternativeSchemes()[1].getInstruction());
            }
        }
        return this.textBuilder.toString();
    }

    private void appendPerson(Address address) {
        if (address != null) {
            this.appendDataField(address.getType() == Address.Type.STRUCTURED ? "S" : "K");
            this.appendDataField(address.getName());
            this.appendDataField(address.getType() == Address.Type.STRUCTURED ? address.getStreet() : address.getAddressLine1());
            this.appendDataField(address.getType() == Address.Type.STRUCTURED ? address.getHouseNo() : address.getAddressLine2());
            this.appendDataField(address.getPostalCode());
            this.appendDataField(address.getTown());
            this.appendDataField(address.getCountryCode());
        } else {
            this.textBuilder.append("\n\n\n\n\n\n\n");
        }
    }

    private void appendDataField(String value) {
        if (value == null) {
            value = "";
        }
        this.textBuilder.append('\n').append(value);
    }

    private static String formatAmountForCode(BigDecimal amount) {
        return amountFieldFormat.format(amount);
    }

    public static Bill decode(String text) {
        String[] lines = QRCodeText.splitLines(text);
        if (!(lines.length >= 31 && lines.length <= 34 || lines.length == 35 && lines[34].isEmpty())) {
            QRCodeText.throwSingleValidationError("qrText", "valid_data_structure");
        }
        if (!"SPC".equals(lines[0])) {
            QRCodeText.throwSingleValidationError("qrText", "valid_data_structure");
        }
        if (!VALID_VERSION.matcher(lines[1]).matches()) {
            QRCodeText.throwSingleValidationError("version", "supported_version");
        }
        if (!"1".equals(lines[2])) {
            QRCodeText.throwSingleValidationError("codingType", "supported_coding_type");
        }
        Bill bill = new Bill();
        bill.setVersion(Bill.Version.V2_0);
        bill.setAccount(lines[3]);
        bill.setCreditor(QRCodeText.decodeAddress(lines, 4, false));
        if (lines[18].length() > 0) {
            ParsePosition position = new ParsePosition(0);
            BigDecimal amount = (BigDecimal)amountFieldFormat.parse(lines[18], position);
            if (position.getIndex() == lines[18].length()) {
                bill.setAmount(amount);
            } else {
                QRCodeText.throwSingleValidationError("amount", "valid_number");
            }
        } else {
            bill.setAmount(null);
        }
        bill.setCurrency(lines[19]);
        bill.setDebtor(QRCodeText.decodeAddress(lines, 20, true));
        bill.setReference(lines[28]);
        bill.setReferenceType(lines[27]);
        bill.setUnstructuredMessage(lines[29]);
        if (!"EPD".equals(lines[30])) {
            QRCodeText.throwSingleValidationError("trailer", "valid_data_structure");
        }
        bill.setBillInformation(lines.length > 31 ? lines[31] : "");
        AlternativeScheme[] alternativeSchemes = null;
        int numSchemes = lines.length - 32;
        if (numSchemes > 0 && lines[32 + numSchemes - 1].isEmpty()) {
            --numSchemes;
        }
        if (numSchemes > 0) {
            alternativeSchemes = new AlternativeScheme[numSchemes];
            for (int i = 0; i < numSchemes; ++i) {
                AlternativeScheme scheme = new AlternativeScheme();
                scheme.setInstruction(lines[32 + i]);
                alternativeSchemes[i] = scheme;
            }
        }
        bill.setAlternativeSchemes(alternativeSchemes);
        return bill;
    }

    private static Address decodeAddress(String[] lines, int startLine, boolean isOptional) {
        boolean isEmpty;
        boolean bl = isEmpty = lines[startLine].length() == 0 && lines[startLine + 1].length() == 0 && lines[startLine + 2].length() == 0 && lines[startLine + 3].length() == 0 && lines[startLine + 4].length() == 0 && lines[startLine + 5].length() == 0 && lines[startLine + 6].length() == 0;
        if (isEmpty && isOptional) {
            return null;
        }
        Address address = new Address();
        boolean isStructuredAddress = "S".equals(lines[startLine]);
        address.setName(lines[startLine + 1]);
        if (isStructuredAddress) {
            address.setStreet(lines[startLine + 2]);
            address.setHouseNo(lines[startLine + 3]);
        } else {
            address.setAddressLine1(lines[startLine + 2]);
            address.setAddressLine2(lines[startLine + 3]);
        }
        if (lines[startLine + 4].length() > 0) {
            address.setPostalCode(lines[startLine + 4]);
        }
        if (lines[startLine + 5].length() > 0) {
            address.setTown(lines[startLine + 5]);
        }
        address.setCountryCode(lines[startLine + 6]);
        return address;
    }

    private static String[] splitLines(String text) {
        int pos;
        ArrayList<String> lines = new ArrayList<String>(32);
        int lastPos = 0;
        while ((pos = text.indexOf(10, lastPos)) >= 0) {
            int pos2 = pos;
            if (pos2 > lastPos && text.charAt(pos2 - 1) == '\r') {
                --pos2;
            }
            lines.add(text.substring(lastPos, pos2));
            lastPos = pos + 1;
        }
        lines.add(text.substring(lastPos, text.length()));
        return lines.toArray(new String[0]);
    }

    private static void throwSingleValidationError(String field, String messageKey) {
        ValidationResult result = new ValidationResult();
        result.addMessage(ValidationMessage.Type.ERROR, field, messageKey);
        throw new QRBillValidationError(result);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        amountFieldFormat.setDecimalFormatSymbols(symbols);
        amountFieldFormat.setParseBigDecimal(true);
        VALID_VERSION = Pattern.compile("^02[0-9][0-9]$");
    }
}

