/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.gui.verifier;

import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.gui.ErrorMessages;
import com.janus.qrinvoice.gui.FieldType;
import com.janus.qrinvoice.gui.VerificationStateCallback;
import com.janus.qrinvoice.gui.verifier.NotNullVerifier;
import com.janus.qrinvoice.parser.ValidationException;
import com.janus.qrinvoice.validator.QRInvoiceValidator;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class NotNullIBANVerifier
extends NotNullVerifier {
    private boolean conditionalNotStrict;

    public NotNullIBANVerifier(JComponent jComponent, FieldType fieldType, VerificationStateCallback verificationStateCallback, ErrorMessages errorMessages, boolean bl) {
        super(jComponent, fieldType, verificationStateCallback, errorMessages);
        this.conditionalNotStrict = bl;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl = super.verify(jComponent);
        if (bl) {
            try {
                if (this.conditionalNotStrict) {
                    if (StringUtils.trimToNull(this.txt) == null) {
                        throw new ValidationException(ApplicationContext.get().text().getString("pleaseFillIn"), this.txt);
                    }
                } else {
                    QRInvoiceValidator.validateIBAN(this.txt);
                }
                this.resetMessage();
            }
            catch (ValidationException validationException) {
                this.setErrorMessage(validationException.getMessage());
                bl = false;
            }
        }
        this.callback.toggleVerificationState(this.fieldType, bl);
        return bl;
    }

    public boolean isConditionalNotStrict() {
        return this.conditionalNotStrict;
    }

    public void setConditionalNotStrict(boolean bl) {
        this.conditionalNotStrict = bl;
    }
}

