/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableDeclElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableDeclsElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.common.field.Fields;
import org.odftoolkit.simple.common.field.VariableContainer;
import org.odftoolkit.simple.common.field.VariableField;
import org.w3c.dom.Node;

public abstract class AbstractVariableContainer
implements VariableContainer {
    public VariableField declareVariable(String name, VariableField.VariableType type) {
        VariableField variableField = null;
        switch (type) {
            case SIMPLE: {
                variableField = Fields.createSimpleVariableField(this, name);
                break;
            }
            case USER: {
                variableField = Fields.createUserVariableField(this, name, "0");
                break;
            }
            case SEQUENCE: {
                throw new IllegalArgumentException("Simple Java API for ODF doesn't support this type now.");
            }
        }
        return variableField;
    }

    public VariableField getVariableFieldByName(String name) {
        TextUserFieldDeclsElement userVariableElements;
        OdfElement containerElement = this.getVariableContainerElement();
        TextVariableDeclsElement simpleVariableElements = (TextVariableDeclsElement)OdfElement.findFirstChildNode(TextVariableDeclsElement.class, (Node)containerElement);
        if (simpleVariableElements != null) {
            for (TextVariableDeclElement simpleVariableElement = (TextVariableDeclElement)simpleVariableElements.getFirstChild(); simpleVariableElement != null; simpleVariableElement = (TextVariableDeclElement)simpleVariableElement.getNextSibling()) {
                if (!name.equals(simpleVariableElement.getTextNameAttribute())) continue;
                return Fields.createSimpleVariableField(this, name);
            }
        }
        if ((userVariableElements = (TextUserFieldDeclsElement)OdfElement.findFirstChildNode(TextUserFieldDeclsElement.class, (Node)containerElement)) != null) {
            for (TextUserFieldDeclElement userVariableElement = (TextUserFieldDeclElement)userVariableElements.getFirstChild(); userVariableElement != null; userVariableElement = (TextUserFieldDeclElement)userVariableElement.getNextSibling()) {
                if (!name.equals(userVariableElement.getTextNameAttribute())) continue;
                String type = userVariableElement.getOfficeValueTypeAttribute();
                if (type.equalsIgnoreCase("string")) {
                    String stringValue = userVariableElement.getOfficeStringValueAttribute();
                    return Fields.createUserVariableField(this, name, stringValue);
                }
                Double DoubleValue = userVariableElement.getOfficeValueAttribute();
                DoubleValue.toString();
                return Fields.createUserVariableField(this, name, DoubleValue.toString());
            }
        }
        return null;
    }
}

