/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.validator;

import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.parser.ValidationException;
import com.janus.qrinvoice.validator.IBANValidator;
import com.janus.qrinvoice.validator.QRValidator;
import java.math.BigDecimal;

public class QRInvoiceValidator {
    public static void validateIBAN(String string) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{11}([a-zA-Z0-9]?){0,19}") || !string.startsWith("CH") && !string.startsWith("LI") || !IBANValidator.validate(string.replace(" ", ""))) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.iban.notvalid.user.msg"), string);
        }
    }

    public static void validateKontoinhaber(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").isEmpty() || string.length() > 70) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.kontoinhaber.notvalid.user.msg"), string);
        }
    }

    public static void validateText(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").isEmpty() || string.length() > 140) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.text.notvalid.user.msg"), string);
        }
    }

    public static void validateAmount(BigDecimal bigDecimal) throws ValidationException {
        if (bigDecimal == null) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.user.msg"), bigDecimal);
        }
        if (bigDecimal.compareTo(new BigDecimal(0)) != 1) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.greaterzero.user.msg"), bigDecimal);
        }
        if (bigDecimal.scale() > 2) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.scale.user.msg"), bigDecimal);
        }
    }

    public static void validateReferenz(String string, boolean bl) throws ValidationException {
        if (bl) {
            if (string == null) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.qrReferenz.user.msg"), string);
            }
            if (!QRValidator.validateReferenz(string)) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.qrReferenz.user.msg"), string);
            }
        } else if (string != null && !string.startsWith("RF")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.referenz.user.msg"), string);
        }
    }

    public static void validateStrcuturedBillInformation(String string) throws ValidationException {
        if (string != null && !string.startsWith("//")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.strukturierteRechnungsInformation.user.msg"), string);
        }
    }
}

