/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.parser.csv;

import com.janus.qrinvoice.QRInvoiceDTO;
import com.janus.qrinvoice.QRInvoiceLine;
import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.gui.QRInvoiceParser;
import com.janus.qrinvoice.parser.ParserLineResult;
import com.janus.qrinvoice.parser.ParserResult;
import com.janus.qrinvoice.parser.ParserUtils;
import com.janus.qrinvoice.parser.ValidationException;
import com.janus.qrinvoice.parser.csv.CSVQRInvoiceValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSVQRInvoiceParser
implements QRInvoiceParser {
    private final Logger logger = Logger.getLogger(CSVQRInvoiceParser.class.getName());
    private final ParserResult parserResult = new ParserResult();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserResult parse(File file, boolean bl) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                this.logger.log(Level.INFO, "Reading line: " + (String)object);
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while reading CSV file!", exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "Exception while reading CSV file!", iOException);
                }
            }
        }
        object = new QRInvoiceDTO();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.csv.empty"), (Object)null);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ParserLineResult parserLineResult = new ParserLineResult();
                QRInvoiceLine qRInvoiceLine = this.parseLine((String)arrayList.get(i), parserLineResult, ";", bl);
                if (qRInvoiceLine != null) {
                    ((QRInvoiceDTO)object).addQRInvoiceLine(qRInvoiceLine);
                    this.parserResult.setSuccessfull(this.parserResult.getSuccessfull() + 1);
                } else {
                    this.parserResult.setNotSuccessfull(this.parserResult.getNotSuccessfull() + 1);
                }
                this.parserResult.getLineResults().add(parserLineResult);
            }
            this.parserResult.setHeaderSuccessfull(true);
        }
        catch (Exception exception) {
            this.parserResult.setHeaderSuccessfull(false);
            this.parserResult.setHeaderMessage(exception.getMessage());
            this.logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        this.parserResult.setQrinvoice((QRInvoiceDTO)object);
        return this.parserResult;
    }

    private QRInvoiceLine parseLine(String string, ParserLineResult parserLineResult, String string2, boolean bl) {
        QRInvoiceLine qRInvoiceLine = null;
        try {
            CSVQRInvoiceValidator.validateCSVLine(string, string2, bl);
            qRInvoiceLine = new QRInvoiceLine();
            string = string.replaceAll("\"", "");
            string = string.replaceAll("'", "");
            String[] stringArray = string.split(string2);
            String string3 = "";
            qRInvoiceLine.setKontoinhaber(ParserUtils.removeBOM(stringArray[0]));
            string3 = string3 + ParserUtils.removeBOM(stringArray[0]);
            qRInvoiceLine.setStrasseHausNr(stringArray[1]);
            string3 = string3 + ", " + stringArray[1];
            qRInvoiceLine.setPlzOrt(stringArray[2]);
            string3 = string3 + ", " + stringArray[2];
            if (stringArray.length > 3) {
                qRInvoiceLine.setAmount(new BigDecimal(stringArray[3]));
                string3 = string3 + ", " + stringArray[3];
            }
            if (stringArray.length > 4) {
                qRInvoiceLine.setReferenz(stringArray[4]);
                string3 = string3 + ", " + stringArray[4];
            }
            if (stringArray.length > 5) {
                qRInvoiceLine.setZusaetzlicheInformation(stringArray[5]);
                string3 = string3 + ", " + stringArray[5];
            }
            if (stringArray.length > 6) {
                qRInvoiceLine.setStrukturierteRechnungsInformation(stringArray[6]);
                string3 = string3 + ", " + stringArray[6];
            }
            parserLineResult.setSucessfull(true);
            parserLineResult.setLineMessage(string3);
        }
        catch (ValidationException validationException) {
            parserLineResult.setSucessfull(false);
            parserLineResult.setLineMessage(validationException.getMessage() + (validationException.getNotValidatingValue() != null ? " (" + validationException.getNotValidatingValue() + ")" : ""));
            this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), validationException);
        }
        catch (Exception exception) {
            parserLineResult.setSucessfull(false);
            parserLineResult.setLineMessage(exception.getMessage());
            this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), exception);
        }
        return qRInvoiceLine;
    }
}

