/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangNull;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.LangRDFXML;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.lang.PipedQuadsStream;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedTriplesStream;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;

public class RiotReader {
    public static void parse(String filename, StreamRDF dest) {
        RiotReader.parse(filename, null, null, dest);
    }

    public static void parse(String filename, Lang lang, StreamRDF dest) {
        RiotReader.parse(filename, lang, null, dest);
    }

    public static void parse(String filename, Lang lang, String baseIRI, StreamRDF dest) {
        if (lang == null) {
            lang = RDFLanguages.filenameToLang(filename, RDFLanguages.NTRIPLES);
        }
        InputStream in = IO.openFile(filename);
        String base = SysRIOT.chooseBaseIRI(baseIRI, filename);
        RiotReader.parse(in, lang, base, dest);
        IO.close(in);
    }

    public static void parse(InputStream in, Lang lang, StreamRDF dest) {
        RiotReader.parse(in, lang, null, dest);
    }

    public static void parse(InputStream in, Lang lang, String baseIRI, StreamRDF dest) {
        LangRIOT parser = RiotReader.createParser(in, lang, baseIRI, dest);
        parser.parse();
    }

    public static LangRIOT createParser(InputStream input, Lang lang, String baseIRI, StreamRDF dest) {
        if (lang == RDFLanguages.RDFXML) {
            if (baseIRI != null) {
                baseIRI = IRIResolver.resolveString(baseIRI);
            }
            return LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        }
        Tokenizer tokenizer = lang == RDFLanguages.RDFJSON ? new TokenizerJSON(PeekReader.makeUTF8(input)) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParser(tokenizer, lang, baseIRI, dest);
    }

    public static LangRIOT createParser(Reader input, Lang lang, String baseIRI, StreamRDF dest) {
        if (lang == RDFLanguages.RDFXML) {
            if (baseIRI != null) {
                baseIRI = IRIResolver.resolveString(baseIRI);
            }
            return LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        }
        Tokenizer tokenizer = lang == RDFLanguages.RDFJSON ? new TokenizerJSON(PeekReader.make(input)) : TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParser(tokenizer, lang, baseIRI, dest);
    }

    public static LangRIOT createParser(Tokenizer tokenizer, Lang lang, String baseIRI, StreamRDF dest) {
        if (RDFLanguages.sameLang(RDFLanguages.RDFXML, lang)) {
            throw new RiotException("Not possible - can't parse RDF/XML from a RIOT token stream");
        }
        if (RDFLanguages.sameLang(RDFLanguages.TURTLE, lang) || RDFLanguages.sameLang(RDFLanguages.N3, lang)) {
            return RiotReader.createParserTurtle(tokenizer, baseIRI, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return RiotReader.createParserNTriples(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            return RiotReader.createParserRdfJson(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotReader.createParserNQuads(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotReader.createParserTriG(tokenizer, baseIRI, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFNULL, lang)) {
            return new LangNull();
        }
        return null;
    }

    public static void parseTriples(String filename, Sink<Triple> sink) {
        RiotReader.parseTriples(filename, null, null, sink);
    }

    public static void parseTriples(String filename, Lang lang, String baseIRI, Sink<Triple> sink) {
        StreamRDF dest = StreamRDFLib.sinkTriples(sink);
        RiotReader.parse(filename, lang, baseIRI, dest);
    }

    public static void parseTriples(InputStream in, Lang lang, String baseIRI, Sink<Triple> sink) {
        StreamRDF dest = StreamRDFLib.sinkTriples(sink);
        RiotReader.parse(in, lang, baseIRI, dest);
    }

    public static void parseQuads(String filename, Sink<Quad> sink) {
        RiotReader.parseQuads(filename, null, null, sink);
    }

    public static void parseQuads(String filename, Lang lang, String baseIRI, Sink<Quad> sink) {
        StreamRDF dest = StreamRDFLib.sinkQuads(sink);
        RiotReader.parse(filename, lang, baseIRI, dest);
    }

    public static void parseQuads(InputStream in, Lang lang, String baseIRI, Sink<Quad> sink) {
        StreamRDF dest = StreamRDFLib.sinkQuads(sink);
        RiotReader.parse(in, lang, baseIRI, dest);
    }

    public static Iterator<Triple> createIteratorTriples(final InputStream input, final Lang lang, final String baseIRI) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return new IteratorResourceClosing<Triple>(RiotReader.createParserNTriples(input, null), input);
        }
        PipedRDFIterator<Triple> it = new PipedRDFIterator<Triple>();
        final PipedTriplesStream out = new PipedTriplesStream(it);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                RiotReader.parse(input, lang, baseIRI, (StreamRDF)out);
            }
        });
        t.start();
        return it;
    }

    public static Iterator<Quad> createIteratorQuads(final InputStream input, final Lang lang, final String baseIRI) {
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return new IteratorResourceClosing<Quad>(RiotReader.createParserNQuads(input, null), input);
        }
        PipedRDFIterator<Quad> it = new PipedRDFIterator<Quad>();
        final PipedQuadsStream out = new PipedQuadsStream(it);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                RiotReader.parse(input, lang, baseIRI, (StreamRDF)out);
            }
        });
        t.start();
        return it;
    }

    @Deprecated
    public static LangTurtle createParserTurtle(InputStream input, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTurtle(tokenizer, baseIRI, dest);
    }

    public static LangTurtle createParserTurtle(Tokenizer tokenizer, String baseIRI, StreamRDF dest) {
        LangTurtle parser = new LangTurtle(tokenizer, RiotLib.profile(RDFLanguages.TURTLE, baseIRI), dest);
        return parser;
    }

    @Deprecated
    public static LangRDFXML createParserRDFXML(InputStream input, String baseIRI, StreamRDF dest) {
        if (baseIRI == null) {
            baseIRI = SysRIOT.chooseBaseIRI();
        }
        LangRDFXML parser = LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        return parser;
    }

    public static LangRDFJSON createParserRdfJson(Tokenizer tokenizer, StreamRDF dest) {
        LangRDFJSON parser = new LangRDFJSON(tokenizer, RiotLib.profile(RDFLanguages.RDFJSON, null), dest);
        return parser;
    }

    @Deprecated
    public static LangRDFJSON createParserRdfJson(InputStream input, StreamRDF dest) {
        TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8(input));
        return RiotReader.createParserRdfJson(tokenizer, dest);
    }

    @Deprecated
    public static LangTriG createParserTriG(InputStream input, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTriG(tokenizer, baseIRI, dest);
    }

    public static LangTriG createParserTriG(Tokenizer tokenizer, String baseIRI, StreamRDF dest) {
        LangTriG parser = new LangTriG(tokenizer, RiotLib.profile(RDFLanguages.TRIG, baseIRI), dest);
        return parser;
    }

    @Deprecated
    public static LangNTriples createParserNTriples(InputStream input, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(input);
        return RiotReader.createParserNTriples(tokenizer, dest);
    }

    public static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest) {
        LangNTriples parser = new LangNTriples(tokenizer, RiotLib.profile(RDFLanguages.NTRIPLES, null), dest);
        return parser;
    }

    @Deprecated
    public static LangNQuads createParserNQuads(InputStream input, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(input);
        return RiotReader.createParserNQuads(tokenizer, dest);
    }

    public static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest) {
        LangNQuads parser = new LangNQuads(tokenizer, RiotLib.profile(RDFLanguages.NQUADS, null), dest);
        return parser;
    }
}

