/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterCommonParent;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.QC;
import org.apache.jena.atlas.logging.Log;

public class QueryIterService
extends QueryIterRepeatApply {
    OpService opService;

    public QueryIterService(QueryIterator input, OpService opService, ExecutionContext context) {
        super(input, context);
        this.opService = opService;
    }

    @Override
    protected QueryIterator nextStage(Binding outerBinding) {
        QueryIterator qIter;
        Op op = QC.substitute(this.opService, outerBinding);
        boolean silent = this.opService.getSilent();
        try {
            qIter = Service.exec((OpService)op, this.getExecContext().getContext());
            qIter = QueryIter.makeTracked(qIter, this.getExecContext());
        }
        catch (RuntimeException ex) {
            if (silent) {
                Log.warn(this, "SERVICE <" + this.opService.getService().toString() + ">: " + ex.getMessage());
                return QueryIterSingleton.create(outerBinding, this.getExecContext());
            }
            throw ex;
        }
        QueryIterCommonParent qIter2 = new QueryIterCommonParent(qIter, outerBinding, this.getExecContext());
        return qIter2;
    }
}

