/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpExtendAssign;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.atlas.lib.Lib;

public class OpExtend
extends OpExtendAssign {
    public static Op extend(Op op, Var var, Expr expr) {
        if (!(op instanceof OpExtend)) {
            return OpExtend.createExtend(op, var, expr);
        }
        OpExtend opExtend = (OpExtend)op;
        if (opExtend.assignments.contains(var)) {
            return OpExtend.createExtend(op, var, expr);
        }
        opExtend.assignments.add(var, expr);
        return opExtend;
    }

    public static Op extend(Op op, VarExprList exprs) {
        if (!(op instanceof OpExtend)) {
            return OpExtend.createExtend(op, exprs);
        }
        OpExtend opExtend = (OpExtend)op;
        for (Var var : exprs.getVars()) {
            if (!opExtend.assignments.contains(var)) continue;
            return OpExtend.createExtend(op, exprs);
        }
        opExtend.assignments.addAll(exprs);
        return opExtend;
    }

    public static OpExtend extendDirect(Op op, VarExprList exprs) {
        return new OpExtend(op, exprs);
    }

    private static Op createExtend(Op op, Var var, Expr expr) {
        VarExprList x = new VarExprList();
        x.add(var, expr);
        return new OpExtend(op, x);
    }

    private static Op createExtend(Op op, VarExprList exprs) {
        VarExprList x = new VarExprList();
        x.addAll(exprs);
        return new OpExtend(op, x);
    }

    private OpExtend(Op subOp) {
        super(subOp);
    }

    private OpExtend(Op subOp, VarExprList exprs) {
        super(subOp, exprs);
    }

    @Override
    public String getName() {
        return "extend";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        OpExtend op = new OpExtend(subOp, new VarExprList(this.getVarExprList()));
        return op;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpExtend)) {
            return false;
        }
        OpExtend assign2 = (OpExtend)other;
        if (!Lib.equal(this.assignments, assign2.assignments)) {
            return false;
        }
        return this.getSubOp().equalTo(assign2.getSubOp(), labelMap);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public OpExtendAssign copy(Op subOp, VarExprList varExprList) {
        return new OpExtend(subOp, varExprList);
    }
}

