/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import net.codecrete.qrbill.canvas.ByteArrayResult;
import net.codecrete.qrbill.canvas.Canvas;

public class SVGCanvas
extends AbstractCanvas
implements ByteArrayResult {
    private ByteArrayOutputStream buffer;
    private Writer stream;
    private boolean isInGroup;
    private boolean isFirstMoveInPath;
    private double lastPositionX;
    private double lastPositionY;
    private int approxPathLength;
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.UK));
    private static final DecimalFormat ANGLE_FORMAT = new DecimalFormat("#.#####", new DecimalFormatSymbols(Locale.UK));

    public SVGCanvas(double width, double height, String fontFamilyList) throws IOException {
        this.setupFontMetrics(fontFamilyList);
        this.buffer = new ByteArrayOutputStream();
        this.stream = new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8);
        this.stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg width=\"");
        this.stream.write(SVGCanvas.formatNumber(width));
        this.stream.write("mm\" height=\"");
        this.stream.write(SVGCanvas.formatNumber(height));
        this.stream.write("mm\" version=\"1.1\" viewBox=\"0 0 ");
        this.stream.write(SVGCanvas.formatCoordinate(width));
        this.stream.write(" ");
        this.stream.write(SVGCanvas.formatCoordinate(height));
        this.stream.write("\" xmlns=\"http://www.w3.org/2000/svg\">\n");
        this.stream.write("<g font-family=\"");
        this.stream.write(SVGCanvas.escapeXML(this.fontMetrics.getFontFamilyList()));
        this.stream.write("\" transform=\"translate(0 ");
        this.stream.write(SVGCanvas.formatCoordinate(height));
        this.stream.write(")\">\n");
        this.stream.write("<title>Swiss QR Bill</title>\n");
    }

    @Override
    public void close() throws IOException {
        if (this.isInGroup) {
            this.stream.write("</g>\n");
            this.isInGroup = false;
        }
        if (this.stream != null) {
            this.stream.write("</g>\n");
            this.stream.write("</svg>\n");
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    public void startPath() throws IOException {
        this.stream.write("<path d=\"");
        this.isFirstMoveInPath = true;
        this.approxPathLength = 0;
    }

    @Override
    public void moveTo(double x, double y) throws IOException {
        y = -y;
        if (this.isFirstMoveInPath) {
            this.stream.write("M");
            this.stream.write(SVGCanvas.formatCoordinate(x));
            this.stream.write(",");
            this.stream.write(SVGCanvas.formatCoordinate(y));
            this.isFirstMoveInPath = false;
        } else {
            this.addPathNewlines(16);
            this.stream.write("m");
            this.stream.write(SVGCanvas.formatCoordinate(x - this.lastPositionX));
            this.stream.write(",");
            this.stream.write(SVGCanvas.formatCoordinate(y - this.lastPositionY));
        }
        this.lastPositionX = x;
        this.lastPositionY = y;
        this.approxPathLength += 16;
    }

    @Override
    public void lineTo(double x, double y) throws IOException {
        y = -y;
        this.addPathNewlines(16);
        this.stream.write("l");
        this.stream.write(SVGCanvas.formatCoordinate(x - this.lastPositionX));
        this.stream.write(",");
        this.stream.write(SVGCanvas.formatCoordinate(y - this.lastPositionY));
        this.lastPositionX = x;
        this.lastPositionY = y;
        this.approxPathLength += 16;
    }

    @Override
    public void cubicCurveTo(double x1, double y1, double x2, double y2, double x, double y) throws IOException {
        y1 = -y1;
        y2 = -y2;
        y = -y;
        this.addPathNewlines(48);
        this.stream.write("c");
        this.stream.write(SVGCanvas.formatCoordinate(x1 - this.lastPositionX));
        this.stream.write(",");
        this.stream.write(SVGCanvas.formatCoordinate(y1 - this.lastPositionY));
        this.stream.write(",");
        this.stream.write(SVGCanvas.formatCoordinate(x2 - this.lastPositionX));
        this.stream.write(",");
        this.stream.write(SVGCanvas.formatCoordinate(y2 - this.lastPositionY));
        this.stream.write(",");
        this.stream.write(SVGCanvas.formatCoordinate(x - this.lastPositionX));
        this.stream.write(",");
        this.stream.write(SVGCanvas.formatCoordinate(y - this.lastPositionY));
        this.lastPositionX = x;
        this.lastPositionY = y;
        this.approxPathLength += 48;
    }

    @Override
    public void addRectangle(double x, double y, double width, double height) throws IOException {
        this.addPathNewlines(40);
        this.moveTo(x, y + height);
        this.stream.write("h");
        this.stream.write(SVGCanvas.formatCoordinate(width));
        this.stream.write("v");
        this.stream.write(SVGCanvas.formatCoordinate(height));
        this.stream.write("h");
        this.stream.write(SVGCanvas.formatCoordinate(-width));
        this.stream.write("z");
        this.approxPathLength += 24;
    }

    @Override
    public void closeSubpath() throws IOException {
        this.addPathNewlines(1);
        this.stream.write("z");
        ++this.approxPathLength;
    }

    private void addPathNewlines(int expectedLength) throws IOException {
        if (this.approxPathLength + expectedLength > 255) {
            this.stream.write("\n");
            this.approxPathLength = 0;
        }
    }

    @Override
    public void fillPath(int color) throws IOException {
        this.stream.write("\" fill=\"#");
        this.stream.write(SVGCanvas.formatColor(color));
        this.stream.write("\"/>\n");
        this.isFirstMoveInPath = true;
    }

    @Override
    public void strokePath(double strokeWidth, int color) throws IOException {
        this.strokePath(strokeWidth, color, Canvas.LineStyle.Solid);
    }

    @Override
    public void strokePath(double strokeWidth, int color, Canvas.LineStyle lineStyle) throws IOException {
        this.stream.write("\" stroke=\"#");
        this.stream.write(SVGCanvas.formatColor(color));
        if (strokeWidth != 1.0) {
            this.stream.write("\" stroke-width=\"");
            this.stream.write(SVGCanvas.formatNumber(strokeWidth));
        }
        if (lineStyle == Canvas.LineStyle.Dashed) {
            this.stream.write("\" stroke-dasharray=\"");
            this.stream.write(SVGCanvas.formatNumber(strokeWidth * 4.0));
        } else if (lineStyle == Canvas.LineStyle.Dotted) {
            this.stream.write("\" stroke-linecap=\"round\" stroke-dasharray=\"0 ");
            this.stream.write(SVGCanvas.formatNumber(strokeWidth * 3.0));
        }
        this.stream.write("\" fill=\"none\"/>\n");
        this.isFirstMoveInPath = true;
    }

    @Override
    public void putText(String text, double x, double y, int fontSize, boolean isBold) throws IOException {
        y = -y;
        this.stream.write("<text x=\"");
        this.stream.write(SVGCanvas.formatCoordinate(x));
        this.stream.write("\" y=\"");
        this.stream.write(SVGCanvas.formatCoordinate(y));
        this.stream.write("\" font-size=\"");
        this.stream.write(SVGCanvas.formatNumber(fontSize));
        if (isBold) {
            this.stream.write("\" font-weight=\"bold");
        }
        this.stream.write("\">");
        this.stream.write(SVGCanvas.escapeXML(text));
        this.stream.write("</text>\n");
    }

    @Override
    public void setTransformation(double translateX, double translateY, double rotate, double scaleX, double scaleY) throws IOException {
        if (this.isInGroup) {
            this.stream.write("</g>\n");
            this.isInGroup = false;
        }
        if (translateX != 0.0 || translateY != 0.0 || scaleX != 1.0 || scaleY != 1.0) {
            this.stream.write("<g transform=\"translate(");
            this.stream.write(SVGCanvas.formatCoordinate(translateX));
            this.stream.write(" ");
            this.stream.write(SVGCanvas.formatCoordinate(-translateY));
            if (rotate != 0.0) {
                this.stream.write(") rotate(");
                this.stream.write(ANGLE_FORMAT.format(-rotate / Math.PI * 180.0));
            }
            if (scaleX != 1.0 || scaleY != 1.0) {
                this.stream.write(") scale(");
                this.stream.write(SVGCanvas.formatNumber(scaleX));
                if (scaleX != scaleY) {
                    this.stream.write(" ");
                    this.stream.write(SVGCanvas.formatNumber(scaleY));
                }
            }
            this.stream.write(")\">\n");
            this.isInGroup = true;
        }
    }

    @Override
    public byte[] toByteArray() throws IOException {
        this.close();
        return this.buffer.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
        this.close();
        this.buffer.writeTo(os);
    }

    public void saveAs(Path path) throws IOException {
        this.close();
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.buffer.writeTo(os);
        }
    }

    private static String formatNumber(double value) {
        return NUMBER_FORMAT.format(value);
    }

    private static String formatCoordinate(double value) {
        return NUMBER_FORMAT.format(value * 2.834645669291339);
    }

    private static String formatColor(int color) {
        return String.format(Locale.US, "%06x", color);
    }

    private static String escapeXML(String text) {
        int length = text.length();
        int lastCopiedPosition = 0;
        StringBuilder result = null;
        for (int i = 0; i < length; ++i) {
            String entity;
            char ch = text.charAt(i);
            if (ch != '<' && ch != '>' && ch != '&' && ch != '\'' && ch != '\"') continue;
            if (result == null) {
                result = new StringBuilder(length + 10);
            }
            if (i > lastCopiedPosition) {
                result.append(text, lastCopiedPosition, i);
            }
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                default: {
                    entity = "&quot;";
                }
            }
            result.append(entity);
            lastCopiedPosition = i + 1;
        }
        if (result == null) {
            return text;
        }
        if (length > lastCopiedPosition) {
            result.append(text, lastCopiedPosition, length);
        }
        return result.toString();
    }
}

