/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;

public class Util {
    private static final String SLASH = "/";

    public static boolean qNameEquals(QName at, QName name) {
        return !name.getNamespaceURI().equals("") ? at.equals(name) : at.getLocalPart().equals(name.getLocalPart());
    }

    public static String getRDFBaseUri(String pkgBaseUri, String internalPath) {
        String subDirectory = internalPath.lastIndexOf(SLASH) == -1 ? "" : SLASH + internalPath.substring(0, internalPath.lastIndexOf(SLASH));
        String baseUri = pkgBaseUri + subDirectory + SLASH;
        return baseUri;
    }

    public static boolean isSubPathOf(String subPath, String superPath) {
        if (superPath == null || subPath == null) {
            return false;
        }
        return SLASH.equals(superPath) || subPath.length() > superPath.length() && subPath.startsWith(superPath);
    }

    public static String toExternalForm(URI u) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        if (u.getScheme() != null) {
            sb.append(u.getScheme());
            sb.append(':');
        }
        if (u.isOpaque()) {
            sb.append(u.getSchemeSpecificPart());
        } else {
            if (u.getHost() != null) {
                boolean needBrackets;
                sb.append("//");
                if (u.getUserInfo() != null) {
                    sb.append(u.getUserInfo());
                    sb.append('@');
                }
                boolean bl = needBrackets = u.getHost().indexOf(58) >= 0 && !u.getHost().startsWith("[") && !u.getHost().endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(u.getHost());
                if (needBrackets) {
                    sb.append(']');
                }
                if (u.getPort() != -1) {
                    sb.append(':');
                    sb.append(u.getPort());
                }
            } else if (u.getRawAuthority() != null) {
                sb.append("//");
                sb.append(u.getRawAuthority());
            } else {
                sb.append("//");
            }
            if (u.getRawPath() != null) {
                sb.append(u.getRawPath());
            }
            if (u.getRawQuery() != null) {
                sb.append('?');
                sb.append(u.getRawQuery());
            }
        }
        if (u.getFragment() != null) {
            sb.append('#');
            sb.append(u.getFragment());
        }
        String ret = new URI(sb.toString()).toASCIIString();
        return ret;
    }
}

