/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.rdfa;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkEndElement;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkStartElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.rdfa.DOMAttributes;
import org.odftoolkit.odfdom.pkg.rdfa.JenaSink;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class BookmarkRDFMetadataExtractor
extends DefaultElementVisitor {
    protected static final char NewLineChar = '\n';
    protected static final char TabChar = '\t';
    private TextBookmarkStartElement bookmarkstart;
    private boolean found;
    protected final Map<TextBookmarkStartElement, ExtractorStringBuilder> builderMap;
    protected final Map<TextBookmarkStartElement, String> stringMap;
    private XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private JenaSink sink;

    public static BookmarkRDFMetadataExtractor newBookmarkTextExtractor() {
        return new BookmarkRDFMetadataExtractor();
    }

    public Model getBookmarkRDFMetadata(OdfFileDom dom) {
        this.bookmarkstart = null;
        this.found = false;
        this.sink = dom.getSink();
        this.visit(dom.getRootElement());
        return this.getModel();
    }

    public Model getBookmarkRDFMetadata(TextBookmarkStartElement bookmarkstart) {
        this.bookmarkstart = bookmarkstart;
        this.found = false;
        this.sink = ((OdfFileDom)((Object)bookmarkstart.getOwnerDocument())).getSink();
        this.visit(((OdfFileDom)((Object)bookmarkstart.getOwnerDocument())).getRootElement());
        return this.getModel();
    }

    private Model getModel() {
        Model m = ModelFactory.createDefaultModel();
        for (Map.Entry<TextBookmarkStartElement, String> entry : this.stringMap.entrySet()) {
            String xhtmlAbout = entry.getKey().getXhtmlAboutAttribute();
            String xhtmlProperty = entry.getKey().getXhtmlPropertyAttribute();
            String xhtmlContent = entry.getKey().getXhtmlContentAttribute();
            if (xhtmlAbout == null || xhtmlProperty == null) continue;
            String qname = entry.getKey().getNodeName();
            String namespaceURI = entry.getKey().getNamespaceURI();
            String localname = entry.getKey().getLocalName();
            String prefix = qname.indexOf(58) == -1 ? "" : qname.substring(0, qname.indexOf(58));
            StartElement e = this.eventFactory.createStartElement(prefix, namespaceURI, localname, this.fromAttributes(new DOMAttributes(entry.getKey().getAttributes())), null, this.sink.getContext());
            xhtmlAbout = this.sink.getExtractor().expandSafeCURIE(e, xhtmlAbout, this.sink.getContext());
            xhtmlProperty = this.sink.getExtractor().expandCURIE(e, xhtmlProperty, this.sink.getContext());
            Resource s = m.createResource(xhtmlAbout);
            Property p = m.createProperty(xhtmlProperty);
            if (xhtmlContent != null) {
                s.addLiteral(p, (Object)xhtmlContent);
                continue;
            }
            s.addLiteral(p, (Object)entry.getValue());
        }
        return m;
    }

    private Iterator fromAttributes(Attributes attributes) {
        LinkedList<Attribute> toReturn = new LinkedList<Attribute>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String prefix = qname.contains(":") ? qname.substring(0, qname.indexOf(":")) : "";
            Attribute attr = this.eventFactory.createAttribute(prefix, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            if (qname.equals("xmlns") || qname.startsWith("xmlns:")) continue;
            toReturn.add(attr);
        }
        return toReturn.iterator();
    }

    private BookmarkRDFMetadataExtractor() {
        this.builderMap = new HashMap<TextBookmarkStartElement, ExtractorStringBuilder>();
        this.stringMap = new HashMap<TextBookmarkStartElement, String>();
    }

    public void visit(OdfElement element) {
        if (this.bookmarkstart != null && this.found) {
            return;
        }
        if (this.bookmarkstart == null) {
            if (element instanceof TextBookmarkStartElement) {
                this.builderMap.put((TextBookmarkStartElement)element, new ExtractorStringBuilder());
            }
        } else if (element == this.bookmarkstart) {
            this.builderMap.put((TextBookmarkStartElement)element, new ExtractorStringBuilder());
        }
        this.appendElementText(element);
        if (element.getNamespaceURI().equals(OdfDocumentNamespace.META.getUri()) || element.getNamespaceURI().equals(OdfDocumentNamespace.DC.getUri())) {
            // empty if block
        }
    }

    private void appendElementText(OdfElement ele) {
        for (Node node = ele.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) {
                this.textBuilderAppend(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node instanceof TextBookmarkEndElement) {
                TextBookmarkEndElement end = (TextBookmarkEndElement)((Object)node);
                this.endBookmark(end);
            }
            OdfElement element = (OdfElement)((Object)node);
            element.accept(this);
        }
    }

    private void textBuilderAppendLine() {
        for (Map.Entry<TextBookmarkStartElement, ExtractorStringBuilder> entry : this.builderMap.entrySet()) {
            entry.getValue().appendLine();
        }
    }

    private void textBuilderAppend(char ch) {
        for (Map.Entry<TextBookmarkStartElement, ExtractorStringBuilder> entry : this.builderMap.entrySet()) {
            entry.getValue().append(ch);
        }
    }

    private void textBuilderAppend(String str) {
        for (Map.Entry<TextBookmarkStartElement, ExtractorStringBuilder> entry : this.builderMap.entrySet()) {
            entry.getValue().append(str);
        }
    }

    private void endBookmark(TextBookmarkEndElement end) {
        TextBookmarkStartElement start = null;
        for (Map.Entry<TextBookmarkStartElement, ExtractorStringBuilder> entry : this.builderMap.entrySet()) {
            if (!entry.getKey().getTextNameAttribute().equals(end.getTextNameAttribute())) continue;
            start = entry.getKey();
            break;
        }
        if (start != null) {
            this.stringMap.put(start, this.builderMap.get((Object)start).toString());
            this.builderMap.remove((Object)start);
            if (this.bookmarkstart != null) {
                this.found = true;
            }
        }
    }

    protected static class ExtractorStringBuilder {
        private StringBuilder mBuilder = new StringBuilder();
        private boolean lastAppendNewLine = false;

        ExtractorStringBuilder() {
        }

        public void append(String str) {
            this.mBuilder.append(str);
        }

        public void append(char ch) {
            this.mBuilder.append(ch);
        }

        public void appendLine() {
            this.mBuilder.append('\n');
            this.lastAppendNewLine = true;
        }

        public String toString() {
            if (this.lastAppendNewLine) {
                this.mBuilder.deleteCharAt(this.mBuilder.length() - 1);
            }
            return this.mBuilder.toString();
        }
    }
}

