/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import net.codecrete.qrbill.generator.SwicoBillInformation;

class SwicoS1Encoder {
    private static final DateTimeFormatter SWICO_DATE_FORMAT = DateTimeFormatter.ofPattern("yyMMdd", Locale.UK);
    private static final DecimalFormat SWICO_NUMBER_FORMAT = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.UK));

    private SwicoS1Encoder() {
    }

    static String encode(SwicoBillInformation billInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("//S1");
        if (billInfo.getInvoiceNumber() != null) {
            sb.append("/10/").append(SwicoS1Encoder.escapedText(billInfo.getInvoiceNumber()));
        }
        if (billInfo.getInvoiceDate() != null) {
            sb.append("/11/").append(SwicoS1Encoder.s1Date(billInfo.getInvoiceDate()));
        }
        if (billInfo.getCustomerReference() != null) {
            sb.append("/20/").append(SwicoS1Encoder.escapedText(billInfo.getCustomerReference()));
        }
        if (billInfo.getVatNumber() != null) {
            sb.append("/30/").append(SwicoS1Encoder.escapedText(billInfo.getVatNumber()));
        }
        if (billInfo.getVatDate() != null) {
            sb.append("/31/").append(SwicoS1Encoder.s1Date(billInfo.getVatDate()));
        } else if (billInfo.getVatStartDate() != null && billInfo.getVatEndDate() != null) {
            sb.append("/31/").append(SwicoS1Encoder.s1Date(billInfo.getVatStartDate())).append(SwicoS1Encoder.s1Date(billInfo.getVatEndDate()));
        }
        if (billInfo.getVatRate() != null) {
            sb.append("/32/").append(SwicoS1Encoder.s1Number(billInfo.getVatRate()));
        } else if (billInfo.getVatRateDetails() != null && !billInfo.getVatRateDetails().isEmpty()) {
            sb.append("/32/");
            SwicoS1Encoder.appendRateDetailTupleList(sb, billInfo.getVatRateDetails());
        }
        if (billInfo.getVatImportTaxes() != null && !billInfo.getVatImportTaxes().isEmpty()) {
            sb.append("/33/");
            SwicoS1Encoder.appendRateDetailTupleList(sb, billInfo.getVatImportTaxes());
        }
        if (billInfo.getPaymentConditions() != null && !billInfo.getPaymentConditions().isEmpty()) {
            sb.append("/40/");
            SwicoS1Encoder.appendConditionTupleList(sb, billInfo.getPaymentConditions());
        }
        return sb.length() > 4 ? sb.toString() : null;
    }

    private static String escapedText(String text) {
        return text.replace("\\", "\\\\").replace("/", "\\/");
    }

    private static String s1Date(LocalDate date) {
        return date.format(SWICO_DATE_FORMAT);
    }

    private static String s1Number(BigDecimal num) {
        return SWICO_NUMBER_FORMAT.format(num);
    }

    private static void appendRateDetailTupleList(StringBuilder sb, List<SwicoBillInformation.RateDetail> list) {
        boolean isFirst = true;
        for (SwicoBillInformation.RateDetail e : list) {
            if (!isFirst) {
                sb.append(";");
            } else {
                isFirst = false;
            }
            sb.append(SwicoS1Encoder.s1Number(e.getRate())).append(":").append(SwicoS1Encoder.s1Number(e.getAmount()));
        }
    }

    private static void appendConditionTupleList(StringBuilder sb, List<SwicoBillInformation.PaymentCondition> list) {
        boolean isFirst = true;
        for (SwicoBillInformation.PaymentCondition e : list) {
            if (!isFirst) {
                sb.append(";");
            } else {
                isFirst = false;
            }
            sb.append(SwicoS1Encoder.s1Number(e.getDiscount())).append(":").append(e.getDays());
        }
    }
}

