/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import io.nayuki.qrcodegen.QrCode;
import java.io.IOException;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.QRCodeText;

class QRCode {
    static final double SIZE = 46.0;
    private final String embeddedText;

    QRCode(Bill bill) {
        this.embeddedText = QRCodeText.create(bill);
    }

    void draw(Canvas graphics, double offsetX, double offsetY) throws IOException {
        QrCode qrCode = QrCode.encodeText((String)this.embeddedText, (QrCode.Ecc)QrCode.Ecc.MEDIUM);
        boolean[][] modules = QRCode.copyModules(qrCode);
        QRCode.clearSwissCrossArea(modules);
        graphics.setTransformation(offsetX, offsetY, 0.0, 46.0 / (double)modules.length / 25.4 * 72.0, 46.0 / (double)modules.length / 25.4 * 72.0);
        graphics.startPath();
        this.drawModulesPath(graphics, modules);
        graphics.fillPath(0);
        graphics.setTransformation(offsetX, offsetY, 0.0, 1.0, 1.0);
        graphics.startPath();
        graphics.addRectangle(20.0, 20.0, 6.0, 6.0);
        graphics.fillPath(0);
        double BAR_WIDTH = 1.1666666666666667;
        double BAR_LENGTH = 3.888888888888889;
        graphics.startPath();
        graphics.addRectangle(22.416666666666668, 21.055555555555557, 1.1666666666666667, 3.888888888888889);
        graphics.addRectangle(21.055555555555557, 22.416666666666668, 3.888888888888889, 1.1666666666666667);
        graphics.fillPath(0xFFFFFF);
    }

    private void drawModulesPath(Canvas graphics, boolean[][] modules) throws IOException {
        int size = modules.length;
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                if (!modules[y][x]) continue;
                this.drawLargestRectangle(graphics, modules, x, y);
            }
        }
    }

    private void drawLargestRectangle(Canvas graphics, boolean[][] modules, int x, int y) throws IOException {
        int size = modules.length;
        int bestW = 1;
        int bestH = 1;
        int maxArea = 1;
        int xLimit = size;
        for (int iy = y; iy < size && modules[iy][x]; ++iy) {
            int w = 0;
            while (x + w < xLimit && modules[iy][x + w]) {
                ++w;
            }
            int area = w * (iy - y + 1);
            if (area > maxArea) {
                maxArea = area;
                bestW = w;
                bestH = iy - y + 1;
            }
            xLimit = x + w;
        }
        double unit = 0.35277777777777775;
        graphics.addRectangle((double)x * 0.35277777777777775, (double)(size - y - bestH) * 0.35277777777777775, (double)bestW * 0.35277777777777775, (double)bestH * 0.35277777777777775);
        QRCode.clearRectangle(modules, x, y, bestW, bestH);
    }

    private static void clearSwissCrossArea(boolean[][] modules) {
        int size = modules.length;
        int start = (int)Math.floor(19.6 * (double)size / 46.0);
        QRCode.clearRectangle(modules, start, start, size - 2 * start, size - 2 * start);
    }

    private static boolean[][] copyModules(QrCode qrCode) {
        int size = qrCode.size;
        boolean[][] modules = new boolean[size][size];
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                modules[y][x] = qrCode.getModule(x, y);
            }
        }
        return modules;
    }

    private static void clearRectangle(boolean[][] modules, int x, int y, int width, int height) {
        for (int iy = y; iy < y + height; ++iy) {
            for (int ix = x; ix < x + width; ++ix) {
                modules[iy][ix] = false;
            }
        }
    }
}

