/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.stream.StreamManager;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.writer.NQuadsWriter;
import org.apache.jena.riot.writer.NTriplesWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFDataMgr {
    static Logger log;
    private static String riotBase;
    private static String streamManagerSymbolStr;
    public static Symbol streamManagerSymbol;

    public static void read(Model model, String uri) {
        RDFDataMgr.read(model.getGraph(), uri);
    }

    public static void read(Graph graph, String uri) {
        RDFDataMgr.read(graph, uri, null, null, null);
    }

    public static void read(Model model, String uri, Lang hintLang) {
        RDFDataMgr.read(model.getGraph(), uri, hintLang);
    }

    public static void read(Graph graph, String uri, Lang hintLang) {
        RDFDataMgr.read(graph, uri, hintLang, null);
    }

    public static void read(Model model, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(model.getGraph(), uri, base, hintLang);
    }

    public static void read(Graph graph, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(graph, uri, base, hintLang, null);
    }

    public static void read(Model model, String uri, Context context) {
        RDFDataMgr.read(model.getGraph(), uri, context);
    }

    public static void read(Graph graph, String uri, Context context) {
        RDFDataMgr.read(graph, uri, null, context);
    }

    public static void read(Model model, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(model, uri, uri, hintLang, context);
    }

    public static void read(Graph graph, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(graph, uri, uri, hintLang, context);
    }

    public static void read(Model model, String uri, String base, Lang hintLang, Context context) {
        RDFDataMgr.read(model.getGraph(), uri, base, hintLang, context);
    }

    public static void read(Graph graph, String uri, String base, Lang hintLang, Context context) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.parse(dest, uri, base, hintLang, context);
    }

    public static void read(Model model, InputStream in, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, lang);
    }

    public static void read(Graph graph, InputStream in, Lang lang) {
        RDFDataMgr.read(graph, in, null, lang);
    }

    public static void read(Model model, InputStream in, String base, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, base, lang);
    }

    public static void read(Graph graph, InputStream in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.process(dest, new TypedInputStream(in), base, lang, null);
    }

    @Deprecated
    public static void read(Model model, Reader in, String base, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, base, lang);
    }

    @Deprecated
    public static void read(Graph graph, Reader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.process(dest, in, base, lang, null);
    }

    public static void read(Model model, StringReader in, String base, Lang lang) {
        Graph g = model.getGraph();
        StreamRDF dest = StreamRDFLib.graph(g);
        RDFDataMgr.process(dest, in, base, lang, null);
    }

    public static void read(Graph graph, StringReader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.process(dest, in, base, lang, null);
    }

    private static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    private static Graph createGraph() {
        return GraphFactory.createDefaultGraph();
    }

    private static Dataset createDataset() {
        return DatasetFactory.createMem();
    }

    private static DatasetGraph createDatasetGraph() {
        return DatasetGraphFactory.createMem();
    }

    public static Model loadModel(String uri) {
        Model m = RDFDataMgr.createModel();
        RDFDataMgr.read(m, uri);
        return m;
    }

    public static Model loadModel(String uri, Lang lang) {
        Model m = RDFDataMgr.createModel();
        RDFDataMgr.read(m, uri, lang);
        return m;
    }

    public static Graph loadGraph(String uri) {
        Graph g = RDFDataMgr.createGraph();
        RDFDataMgr.read(g, uri);
        return g;
    }

    public static Graph loadGraph(String uri, Lang lang) {
        Graph g = RDFDataMgr.createGraph();
        RDFDataMgr.read(g, uri, lang);
        return g;
    }

    public static Dataset loadDataset(String uri) {
        Dataset ds = RDFDataMgr.createDataset();
        RDFDataMgr.read(ds, uri);
        return ds;
    }

    public static Dataset loadDataset(String uri, Lang lang) {
        Dataset ds = RDFDataMgr.createDataset();
        RDFDataMgr.read(ds, uri, lang);
        return ds;
    }

    public static DatasetGraph loadDatasetGraph(String uri) {
        DatasetGraph ds = RDFDataMgr.createDatasetGraph();
        RDFDataMgr.read(ds, uri);
        return ds;
    }

    public static DatasetGraph loadDatasetGraph(String uri, Lang lang) {
        DatasetGraph ds = RDFDataMgr.createDatasetGraph();
        RDFDataMgr.read(ds, uri, lang);
        return ds;
    }

    public static void read(Dataset dataset, String uri) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri);
    }

    public static void read(DatasetGraph dataset, String uri) {
        RDFDataMgr.read(dataset, uri, null);
    }

    public static void read(Dataset dataset, String uri, Lang hintLang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, hintLang);
    }

    public static void read(DatasetGraph dataset, String uri, Lang hintLang) {
        RDFDataMgr.read(dataset, uri, hintLang, null);
    }

    public static void read(Dataset dataset, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, base, hintLang);
    }

    public static void read(DatasetGraph dataset, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(dataset, uri, base, hintLang, null);
    }

    public static void read(Dataset dataset, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, hintLang, context);
    }

    public static void read(DatasetGraph dataset, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(dataset, uri, uri, hintLang, context);
    }

    public static void read(Dataset dataset, String uri, String base, Lang hintLang, Context context) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, uri, hintLang, context);
    }

    public static void read(DatasetGraph dataset, String uri, String base, Lang hintLang, Context context) {
        StreamRDF sink = StreamRDFLib.dataset(dataset);
        RDFDataMgr.parse(sink, uri, base, hintLang, context);
    }

    public static void read(Dataset dataset, InputStream in, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, lang);
    }

    public static void read(DatasetGraph dataset, InputStream in, Lang lang) {
        RDFDataMgr.read(dataset, in, null, lang);
    }

    public static void read(Dataset dataset, InputStream in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    public static void read(DatasetGraph dataset, InputStream in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.process(dest, new TypedInputStream(in), base, lang, null);
    }

    @Deprecated
    public static void read(Dataset dataset, Reader in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    @Deprecated
    public static void read(DatasetGraph dataset, Reader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.process(dest, in, base, lang, null);
    }

    public static void read(Dataset dataset, StringReader in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    public static void read(DatasetGraph dataset, StringReader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.process(dest, in, base, lang, null);
    }

    public static void parse(StreamRDF sink, String uri) {
        RDFDataMgr.parse(sink, uri, null);
    }

    public static void parse(StreamRDF sink, String uri, Lang lang) {
        RDFDataMgr.parse(sink, uri, lang, null);
    }

    public static void parse(StreamRDF sink, String uri, Lang hintLang, Context context) {
        RDFDataMgr.parse(sink, uri, uri, hintLang, context);
    }

    public static void parse(StreamRDF sink, String uri, String base, Lang hintLang, Context context) {
        TypedInputStream in;
        if (uri == null) {
            throw new IllegalArgumentException("URI to read from is null");
        }
        if (base == null) {
            base = SysRIOT.chooseBaseIRI(uri);
        }
        if (hintLang == null) {
            hintLang = RDFLanguages.filenameToLang(uri);
        }
        if ((in = RDFDataMgr.open(uri, context)) == null) {
            throw new RiotException("Not found: " + uri);
        }
        RDFDataMgr.process(sink, in, base, hintLang, context);
        IO.close(in);
    }

    public static void parse(StreamRDF sink, InputStream in, Lang lang) {
        RDFDataMgr.parse(sink, in, null, lang, null);
    }

    public static void parse(StreamRDF sink, InputStream in, String base, Lang hintLang) {
        RDFDataMgr.parse(sink, in, base, hintLang, null);
    }

    public static void parse(StreamRDF sink, Reader in, String base, Lang hintLang, Context context) {
        RDFDataMgr.process(sink, in, base, hintLang, context);
    }

    public static void parse(StreamRDF sink, Reader in, Lang lang) {
        RDFDataMgr.parse(sink, in, null, lang, null);
    }

    public static void parse(StreamRDF sink, Reader in, String base, Lang hintLang) {
        RDFDataMgr.parse(sink, in, base, hintLang, null);
    }

    public static void parse(StreamRDF sink, InputStream in, String base, Lang hintLang, Context context) {
        RDFDataMgr.process(sink, new TypedInputStream(in), base, hintLang, context);
    }

    public static void parse(StreamRDF sink, TypedInputStream in) {
        RDFDataMgr.parse(sink, in, (String)null);
    }

    public static void parse(StreamRDF sink, TypedInputStream in, String base) {
        RDFDataMgr.parse(sink, in, base, (Context)null);
    }

    public static void parse(StreamRDF sink, TypedInputStream in, String base, Context context) {
        Lang hintLang = RDFLanguages.contentTypeToLang(in.getMediaType());
        RDFDataMgr.process(sink, new TypedInputStream(in), base, hintLang, context);
    }

    public static TypedInputStream open(String filenameOrURI) {
        return RDFDataMgr.open(filenameOrURI, (Context)null);
    }

    public static TypedInputStream open(String filenameOrURI, Context context) {
        StreamManager sMgr = StreamManager.get();
        if (context != null) {
            try {
                sMgr = (StreamManager)context.get(streamManagerSymbol, context);
            }
            catch (ClassCastException ex) {
                log.warn("Context symbol '" + streamManagerSymbol + "' is not a " + Utils.classShortName(StreamManager.class));
            }
        }
        return RDFDataMgr.open(filenameOrURI, sMgr);
    }

    public static TypedInputStream open(String filenameOrURI, StreamManager streamManager) {
        TypedInputStream in = streamManager.open(filenameOrURI);
        if (in == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not Found: " + filenameOrURI);
            }
            throw new RiotNotFoundException("Not found: " + filenameOrURI);
        }
        if (log.isDebugEnabled()) {
            log.debug("Found: " + filenameOrURI);
        }
        return in;
    }

    private static void process(StreamRDF destination, TypedInputStream in, String baseUri, Lang hintLang, Context context) {
        ContentType ct = RDFDataMgr.determineCT(baseUri, in.getContentType(), hintLang);
        if (ct == null) {
            throw new RiotException("Failed to determine the content type: (URI=" + baseUri + " : stream=" + in.getContentType() + " : hint=" + hintLang + ")");
        }
        ReaderRIOT reader = RDFDataMgr.getReader(ct);
        if (reader == null) {
            throw new RiotException("No parser registered for content type: " + ct.getContentType());
        }
        reader.read(in, baseUri, ct, destination, context);
    }

    private static void process(StreamRDF destination, Reader in, String baseUri, Lang lang, Context context) {
        ContentType ct = RDFDataMgr.determineCT(baseUri, null, lang);
        if (ct == null) {
            throw new RiotException("Failed to determine the content type: (URI=" + baseUri + " : hint=" + lang + ")");
        }
        ReaderRIOT reader = RDFDataMgr.getReader(ct);
        if (reader == null) {
            throw new RiotException("No parser registered for content type: " + ct.getContentType());
        }
        reader.read(in, baseUri, ct, destination, context);
    }

    private static ReaderRIOT getReader(ContentType ct) {
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        ReaderRIOTFactory r = RDFParserRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        return r.create(lang);
    }

    public static Lang determineLang(String target, String ctStr, Lang hintLang) {
        ContentType ct = RDFDataMgr.determineCT(target, ctStr, hintLang);
        if (ct == null) {
            return hintLang;
        }
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        if (lang == null) {
            return hintLang;
        }
        return lang;
    }

    static ContentType determineCT(String target, String ctStr, Lang hintLang) {
        boolean isTextPlain = "text/plain".equals(ctStr);
        if (ctStr != null) {
            ctStr = WebContent.contentTypeCanonical(ctStr);
        }
        ContentType ct = null;
        if (!isTextPlain) {
            ContentType contentType = ct = ctStr == null ? null : ContentType.create(ctStr);
        }
        if (ct == null && hintLang != null) {
            ct = hintLang.getContentType();
        }
        if (ct == null) {
            ct = RDFLanguages.guessContentType(target);
        }
        return ct;
    }

    public static void write(OutputStream out, Model model, Lang lang) {
        RDFDataMgr.write(out, model.getGraph(), lang);
    }

    public static void write(OutputStream out, Model model, RDFFormat serialization) {
        RDFDataMgr.write(out, model.getGraph(), serialization);
    }

    public static void write(StringWriter out, Model model, Lang lang) {
        RDFDataMgr.write(out, model.getGraph(), lang);
    }

    @Deprecated
    public static void write(Writer out, Model model, Lang lang) {
        RDFDataMgr.write(out, model.getGraph(), lang);
    }

    public static void write(StringWriter out, Model model, RDFFormat serialization) {
        RDFDataMgr.write(out, model.getGraph(), serialization);
    }

    @Deprecated
    public static void write(Writer out, Model model, RDFFormat serialization) {
        RDFDataMgr.write(out, model.getGraph(), serialization);
    }

    public static void write(OutputStream out, Graph graph, Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        RDFDataMgr.write(out, graph, serialization);
    }

    public static void write(OutputStream out, Graph graph, RDFFormat serialization) {
        RDFDataMgr.write$(out, graph, serialization);
    }

    public static void write(StringWriter out, Graph graph, Lang lang) {
        RDFDataMgr.write$((Writer)out, graph, RDFWriterRegistry.defaultSerialization(lang));
    }

    @Deprecated
    public static void write(Writer out, Graph graph, Lang lang) {
        RDFDataMgr.write$(out, graph, RDFWriterRegistry.defaultSerialization(lang));
    }

    public static void write(StringWriter out, Graph graph, RDFFormat serialization) {
        RDFDataMgr.write$((Writer)out, graph, serialization);
    }

    @Deprecated
    public static void write(Writer out, Graph graph, RDFFormat serialization) {
        RDFDataMgr.write$(out, graph, serialization);
    }

    public static void write(OutputStream out, Dataset dataset, Lang lang) {
        RDFDataMgr.write(out, dataset.asDatasetGraph(), lang);
    }

    public static void write(OutputStream out, Dataset dataset, RDFFormat serialization) {
        RDFDataMgr.write(out, dataset.asDatasetGraph(), serialization);
    }

    public static void write(StringWriter out, Dataset dataset, RDFFormat serialization) {
        RDFDataMgr.write$((Writer)out, dataset.asDatasetGraph(), serialization);
    }

    public static void write(StringWriter out, Dataset dataset, Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        RDFDataMgr.write$((Writer)out, dataset.asDatasetGraph(), serialization);
    }

    @Deprecated
    public static void write(Writer out, Dataset dataset, RDFFormat serialization) {
        RDFDataMgr.write$(out, dataset.asDatasetGraph(), serialization);
    }

    public static void write(OutputStream out, DatasetGraph dataset, Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        RDFDataMgr.write(out, dataset, serialization);
    }

    public static void write(OutputStream out, DatasetGraph dataset, RDFFormat serialization) {
        RDFDataMgr.write$(out, dataset, serialization);
    }

    public static void write(StringWriter out, DatasetGraph dataset, Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        RDFDataMgr.write(out, dataset, serialization);
    }

    public static void write(StringWriter out, DatasetGraph dataset, RDFFormat serialization) {
        RDFDataMgr.write$((Writer)out, dataset, serialization);
    }

    @Deprecated
    public static void write(Writer out, DatasetGraph dataset, RDFFormat serialization) {
        RDFDataMgr.write$(out, dataset, serialization);
    }

    public static void writeTriples(OutputStream out, Iterator<Triple> iterator) {
        NTriplesWriter.write(out, iterator);
    }

    public static void writeQuads(OutputStream out, Iterator<Quad> iterator) {
        NQuadsWriter.write(out, iterator);
    }

    public static WriterGraphRIOT createGraphWriter(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        return RDFDataMgr.createGraphWriter$(serialization);
    }

    public static WriterGraphRIOT createGraphWriter(RDFFormat serialization) {
        return RDFDataMgr.createGraphWriter$(serialization);
    }

    public static WriterDatasetRIOT createDatasetWriter(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        return RDFDataMgr.createDatasetWriter$(serialization);
    }

    public static WriterDatasetRIOT createDatasetWriter(RDFFormat serialization) {
        return RDFDataMgr.createDatasetWriter$(serialization);
    }

    private static WriterGraphRIOT createGraphWriter$(RDFFormat serialization) {
        WriterGraphRIOTFactory wf = RDFWriterRegistry.getWriterGraphFactory(serialization);
        if (wf == null) {
            throw new RiotException("No graph writer for " + serialization);
        }
        return wf.create(serialization);
    }

    private static WriterDatasetRIOT createDatasetWriter$(RDFFormat serialization) {
        WriterDatasetRIOTFactory wf = RDFWriterRegistry.getWriterDatasetFactory(serialization);
        if (wf == null) {
            throw new RiotException("No dataset writer for " + serialization);
        }
        return wf.create(serialization);
    }

    private static void write$(OutputStream out, Graph graph, RDFFormat serialization) {
        WriterGraphRIOT w = RDFDataMgr.createGraphWriter$(serialization);
        w.write(out, graph, RiotLib.prefixMap(graph), null, null);
    }

    private static void write$(Writer out, Graph graph, RDFFormat serialization) {
        WriterGraphRIOT w = RDFDataMgr.createGraphWriter$(serialization);
        w.write(out, graph, RiotLib.prefixMap(graph), null, null);
    }

    private static void write$(OutputStream out, DatasetGraph dataset, RDFFormat serialization) {
        WriterDatasetRIOT w = RDFDataMgr.createDatasetWriter$(serialization);
        w.write(out, dataset, RiotLib.prefixMap(dataset), null, null);
    }

    private static void write$(Writer out, DatasetGraph dataset, RDFFormat serialization) {
        WriterDatasetRIOT w = RDFDataMgr.createDatasetWriter$(serialization);
        w.write(out, dataset, RiotLib.prefixMap(dataset), null, null);
    }

    static {
        RIOT.init();
        log = LoggerFactory.getLogger(RDFDataMgr.class);
        riotBase = "http://jena.apache.org/riot/";
        streamManagerSymbolStr = riotBase + "streamManager";
        streamManagerSymbol = Symbol.create(streamManagerSymbolStr);
    }
}

